/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.redis;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.redis.RedisClient;

public class RedisHashCache
implements Level2Cache {
    private String namespace;
    private byte[] regionBytes;
    private RedisClient client;

    public RedisHashCache(String namespace, String region, RedisClient client) {
        if (region == null || region.trim().isEmpty()) {
            region = "_";
        }
        this.client = client;
        this.namespace = namespace;
        this.regionBytes = this.getRegionName(region).getBytes();
    }

    private String getRegionName(String region) {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    @Override
    public byte[] getBytes(String key) {
        try {
            byte[] byArray = this.client.get().hget(this.regionBytes, key.getBytes());
            return byArray;
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> getBytes(Collection<String> keys) {
        try {
            byte[][] bytes = (byte[][])keys.stream().map(k -> k.getBytes()).toArray(x$0 -> new byte[x$0][]);
            List list = this.client.get().hmget(this.regionBytes, bytes);
            return list;
        }
        finally {
            this.client.release();
        }
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        try {
            this.client.get().hset(this.regionBytes, key.getBytes(), bytes);
        }
        finally {
            this.client.release();
        }
    }

    @Override
    public void setBytes(Map<String, byte[]> bytes) {
        try {
            HashMap data = new HashMap();
            bytes.forEach((k, v) -> data.put(k.getBytes(), v));
            this.client.get().hmset(this.regionBytes, data);
        }
        finally {
            this.client.release();
        }
    }

    @Override
    public boolean exists(String key) {
        try {
            boolean bl = this.client.get().hexists(this.regionBytes, key.getBytes());
            return bl;
        }
        finally {
            this.client.release();
        }
    }

    @Override
    public void evict(String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        try {
            byte[][] bytes = (byte[][])Arrays.stream(keys).map(k -> k.getBytes()).toArray(x$0 -> new byte[x$0][]);
            this.client.get().hdel(this.regionBytes, bytes);
        }
        finally {
            this.client.release();
        }
    }

    @Override
    public Collection<String> keys() {
        try {
            Collection collection = this.client.get().hkeys(this.regionBytes).stream().map(bs -> new String((byte[])bs)).collect(Collectors.toList());
            return collection;
        }
        finally {
            this.client.release();
        }
    }

    @Override
    public void clear() {
        try {
            this.client.get().del(this.regionBytes);
        }
        finally {
            this.client.release();
        }
    }
}

