/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.memcached;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.memcached.MemCache;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmemcachedCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(XmemcachedCacheProvider.class);
    private MemcachedClient client;
    private final ConcurrentHashMap<String, Level2Cache> regions = new ConcurrentHashMap();

    @Override
    public String name() {
        return "memcached";
    }

    @Override
    public void start(Properties props) {
        boolean needAuth;
        long ct = System.currentTimeMillis();
        String servers = props.getProperty("servers", "127.0.0.1:11211");
        String username = props.getProperty("username", "");
        String password = props.getProperty("password", "");
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)servers));
        builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        boolean bl = needAuth = username != null && password != null && username.trim().length() > 0 && password.trim().length() > 0;
        if (needAuth) {
            builder.addAuthInfo(AddrUtil.getOneAddress((String)servers), AuthInfo.typical((String)username, (String)password));
        }
        builder.setConnectionPoolSize(Integer.valueOf(props.getProperty("connectionPoolSize", "10")).intValue());
        builder.setConnectTimeout(Long.valueOf(props.getProperty("connectTimeout", "1000")).longValue());
        builder.setHealSessionInterval(Long.valueOf(props.getProperty("healSessionInterval", "1000")).longValue());
        builder.setMaxQueuedNoReplyOperations(Integer.valueOf(props.getProperty("maxQueuedNoReplyOperations", "100")).intValue());
        builder.setOpTimeout(Long.valueOf(props.getProperty("opTimeout", "100")).longValue());
        builder.setSanitizeKeys("true".equalsIgnoreCase(props.getProperty("sanitizeKeys", "false")));
        try {
            this.client = builder.build();
            log.info("Memcached client starts with servers({}),auth({}),pool-size({}),time({}ms)", new Object[]{servers, needAuth, builder.getConfiguration().getSelectorPoolSize(), System.currentTimeMillis() - ct});
        }
        catch (IOException e) {
            log.error("Failed to connect to memcached", (Throwable)e);
        }
    }

    @Override
    public int level() {
        return 2;
    }

    @Override
    public Cache buildCache(String region, CacheExpiredListener listener) {
        return this.regions.computeIfAbsent(region, v -> new MemCache(region, this.client));
    }

    @Override
    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        return this.buildCache(region, listener);
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        return Collections.emptyList();
    }

    @Override
    public void stop() {
        try {
            this.regions().clear();
            this.client.shutdown();
        }
        catch (IOException e) {
            log.error("Failed to disconnect to memcached", (Throwable)e);
        }
    }
}

