/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.lettuce;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.lettuce.LettuceCache;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class LettuceGenericCache
extends LettuceCache {
    public LettuceGenericCache(String namespace, String region, GenericObjectPool<StatefulConnection<String, byte[]>> pool, int scanCount) {
        if (region == null || region.isEmpty()) {
            region = "_";
        }
        this.pool = pool;
        this.namespace = namespace;
        this.region = this.getRegionName(region);
        this.scanCount = scanCount;
    }

    private String getRegionName(String region) {
        if (this.namespace != null && !this.namespace.trim().isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    private String _key(String key) {
        return this.region + ":" + key;
    }

    @Override
    public byte[] getBytes(String key) {
        try (StatefulConnection connection = super.connect();){
            RedisStringCommands cmd = (RedisStringCommands)super.sync(connection);
            byte[] byArray = (byte[])cmd.get((Object)this._key(key));
            return byArray;
        }
    }

    @Override
    public List<byte[]> getBytes(Collection<String> keys) {
        try (StatefulConnection connection = super.connect();){
            RedisStringCommands cmd = (RedisStringCommands)super.sync(connection);
            List<byte[]> list = cmd.mget((Object[])((String[])keys.stream().map(k -> this._key((String)k)).toArray(String[]::new))).stream().map(kv -> kv.hasValue() ? (byte[])kv.getValue() : null).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        try (StatefulConnection connection = super.connect();){
            RedisStringCommands cmd = (RedisStringCommands)super.sync(connection);
            cmd.set((Object)this._key(key), (Object)bytes);
        }
    }

    @Override
    public void setBytes(Map<String, byte[]> bytes) {
        try (StatefulConnection connection = super.connect();){
            RedisStringCommands cmd = (RedisStringCommands)super.sync(connection);
            cmd.mset(bytes.entrySet().stream().collect(Collectors.toMap(k -> this._key((String)k.getKey()), Map.Entry::getValue)));
        }
    }

    @Override
    public void setBytes(String key, byte[] bytes, long timeToLiveInSeconds) {
        try (StatefulConnection connection = super.connect();){
            RedisStringCommands cmd = (RedisStringCommands)super.sync(connection);
            if (timeToLiveInSeconds > 0L) {
                cmd.setex((Object)this._key(key), timeToLiveInSeconds, (Object)bytes);
            } else {
                cmd.set((Object)this._key(key), (Object)bytes);
            }
        }
    }

    @Override
    public void setBytes(Map<String, byte[]> bytes, long timeToLiveInSeconds) {
        try (StatefulConnection connection = super.connect();){
            RedisStringCommands cmd = (RedisStringCommands)super.sync(connection);
            if (timeToLiveInSeconds > 0L) {
                bytes.forEach((k, v) -> cmd.setex((Object)this._key((String)k), timeToLiveInSeconds, v));
            } else {
                bytes.forEach((k, v) -> cmd.set((Object)this._key((String)k), v));
            }
        }
    }

    @Override
    public Collection<String> keys() {
        try (StatefulConnection connection = super.connect();){
            RedisKeyCommands cmd = (RedisKeyCommands)super.sync(connection);
            Collection<String> keys = this.keys((RedisKeyCommands<String, byte[]>)cmd);
            Collection collection = keys.stream().map(k -> k.substring(this.region.length() + 1)).collect(Collectors.toList());
            return collection;
        }
    }

    private Collection<String> keys(RedisKeyCommands<String, byte[]> cmd) {
        ArrayList<String> keys = new ArrayList<String>();
        List partKeys = null;
        ScanCursor scanCursor = ScanCursor.INITIAL;
        ScanArgs scanArgs = new ScanArgs();
        scanArgs.match(this.region + ":*").limit((long)this.scanCount);
        KeyScanCursor keyScanCursor = null;
        while (!scanCursor.isFinished()) {
            keyScanCursor = cmd.scan(scanCursor, scanArgs);
            partKeys = keyScanCursor.getKeys();
            if (partKeys != null && partKeys.size() != 0) {
                keys.addAll(partKeys);
            }
            scanCursor = keyScanCursor;
        }
        return keys;
    }

    @Override
    public void evict(String ... keys) {
        try (StatefulConnection connection = super.connect();){
            RedisKeyCommands cmd = (RedisKeyCommands)super.sync(connection);
            cmd.del((Object[])((String[])Arrays.stream(keys).map(k -> this._key((String)k)).toArray(String[]::new)));
        }
    }

    @Override
    public void clear() {
        try (StatefulConnection connection = super.connect();){
            RedisKeyCommands cmd = (RedisKeyCommands)super.sync(connection);
            Collection<String> keys = this.keys((RedisKeyCommands<String, byte[]>)cmd);
            if (keys != null && keys.size() > 0) {
                cmd.del((Object[])((String[])keys.stream().toArray(String[]::new)));
            }
        }
    }
}

