/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cluster;

import java.util.Properties;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.cluster.ClusterPolicy;
import net.oschina.j2cache.cluster.JGroupsClusterPolicy;
import net.oschina.j2cache.cluster.NoneClusterPolicy;
import net.oschina.j2cache.cluster.RabbitMQClusterPolicy;
import net.oschina.j2cache.cluster.RocketMQClusterPolicy;
import net.oschina.j2cache.lettuce.LettuceCacheProvider;
import net.oschina.j2cache.redis.RedisPubSubClusterPolicy;

public class ClusterPolicyFactory {
    private ClusterPolicyFactory() {
    }

    public static final ClusterPolicy init(CacheProviderHolder holder, String broadcast, Properties props) {
        ClusterPolicy policy = "redis".equalsIgnoreCase(broadcast) ? ClusterPolicyFactory.redis(props, holder) : ("jgroups".equalsIgnoreCase(broadcast) ? ClusterPolicyFactory.jgroups(props, holder) : ("rabbitmq".equalsIgnoreCase(broadcast) ? ClusterPolicyFactory.rabbitmq(props, holder) : ("rocketmq".equalsIgnoreCase(broadcast) ? ClusterPolicyFactory.rocketmq(props, holder) : ("lettuce".equalsIgnoreCase(broadcast) ? ClusterPolicyFactory.lettuce(props, holder) : ("none".equalsIgnoreCase(broadcast) ? new NoneClusterPolicy() : ClusterPolicyFactory.custom(broadcast, props, holder))))));
        return policy;
    }

    private static final ClusterPolicy redis(Properties props, CacheProviderHolder holder) {
        String name = props.getProperty("channel");
        RedisPubSubClusterPolicy policy = new RedisPubSubClusterPolicy(name, props);
        policy.connect(props, holder);
        return policy;
    }

    private static final ClusterPolicy jgroups(Properties props, CacheProviderHolder holder) {
        String name = props.getProperty("channel.name");
        JGroupsClusterPolicy policy = new JGroupsClusterPolicy(name, props);
        policy.connect(props, holder);
        return policy;
    }

    private static final ClusterPolicy rabbitmq(Properties props, CacheProviderHolder holder) {
        RabbitMQClusterPolicy policy = new RabbitMQClusterPolicy(props);
        policy.connect(props, holder);
        return policy;
    }

    private static final ClusterPolicy rocketmq(Properties props, CacheProviderHolder holder) {
        RocketMQClusterPolicy policy = new RocketMQClusterPolicy(props);
        policy.connect(props, holder);
        return policy;
    }

    private static final ClusterPolicy lettuce(Properties props, CacheProviderHolder holder) {
        LettuceCacheProvider policy = new LettuceCacheProvider();
        policy.connect(props, holder);
        return policy;
    }

    private static final ClusterPolicy custom(String classname, Properties props, CacheProviderHolder holder) {
        try {
            ClusterPolicy policy = (ClusterPolicy)Class.forName(classname).newInstance();
            policy.connect(props, holder);
            return policy;
        }
        catch (Exception e) {
            throw new CacheException("Failed in load custom cluster policy. class = " + classname, e);
        }
    }
}

