/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.openid.appauth.Preconditions;

final class AsciiStringListUtil {
    private AsciiStringListUtil() {
        throw new IllegalStateException("This type is not intended to be instantiated");
    }

    @Nullable
    public static String iterableToString(@Nullable Iterable<String> strings) {
        if (strings == null) {
            return null;
        }
        LinkedHashSet<String> stringSet = new LinkedHashSet<String>();
        for (String str : strings) {
            Preconditions.checkArgument(!TextUtils.isEmpty((CharSequence)str), "individual scopes cannot be null or empty");
            stringSet.add(str);
        }
        if (stringSet.isEmpty()) {
            return null;
        }
        return TextUtils.join((CharSequence)" ", stringSet);
    }

    @Nullable
    public static Set<String> stringToSet(@Nullable String spaceDelimitedStr) {
        if (spaceDelimitedStr == null) {
            return null;
        }
        List<String> strings = Arrays.asList(TextUtils.split((String)spaceDelimitedStr, (String)" "));
        LinkedHashSet<String> stringSet = new LinkedHashSet<String>(strings.size());
        stringSet.addAll(strings);
        return stringSet;
    }
}

