/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openid.appauth.AdditionalParamsProcessor;
import net.openid.appauth.AsciiStringListUtil;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.Clock;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import net.openid.appauth.SystemClock;
import net.openid.appauth.TokenRequest;
import net.openid.appauth.internal.UriUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationResponse {
    public static final String EXTRA_RESPONSE = "net.openid.appauth.AuthorizationResponse";
    public static final String TOKEN_TYPE_BEARER = "bearer";
    @VisibleForTesting
    static final String KEY_REQUEST = "request";
    @VisibleForTesting
    static final String KEY_ADDITIONAL_PARAMETERS = "additional_parameters";
    @VisibleForTesting
    static final String KEY_EXPIRES_AT = "expires_at";
    @VisibleForTesting
    static final String KEY_STATE = "state";
    @VisibleForTesting
    static final String KEY_TOKEN_TYPE = "token_type";
    @VisibleForTesting
    static final String KEY_AUTHORIZATION_CODE = "code";
    @VisibleForTesting
    static final String KEY_ACCESS_TOKEN = "access_token";
    @VisibleForTesting
    static final String KEY_EXPIRES_IN = "expires_in";
    @VisibleForTesting
    static final String KEY_ID_TOKEN = "id_token";
    @VisibleForTesting
    static final String KEY_SCOPE = "scope";
    private static final Set<String> BUILT_IN_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("token_type", "state", "code", "access_token", "expires_in", "id_token", "scope")));
    @NonNull
    public final AuthorizationRequest request;
    @Nullable
    public final String state;
    @Nullable
    public final String tokenType;
    @Nullable
    public final String authorizationCode;
    @Nullable
    public final String accessToken;
    @Nullable
    public final Long accessTokenExpirationTime;
    @Nullable
    public final String idToken;
    @Nullable
    public final String scope;
    @NonNull
    public final Map<String, String> additionalParameters;

    private AuthorizationResponse(@NonNull AuthorizationRequest request, @Nullable String state, @Nullable String tokenType, @Nullable String authorizationCode, @Nullable String accessToken, @Nullable Long accessTokenExpirationTime, @Nullable String idToken, @Nullable String scope, @NonNull Map<String, String> additionalParameters) {
        this.request = request;
        this.state = state;
        this.tokenType = tokenType;
        this.authorizationCode = authorizationCode;
        this.accessToken = accessToken;
        this.accessTokenExpirationTime = accessTokenExpirationTime;
        this.idToken = idToken;
        this.scope = scope;
        this.additionalParameters = additionalParameters;
    }

    public boolean hasAccessTokenExpired() {
        return this.hasAccessTokenExpired(SystemClock.INSTANCE);
    }

    @VisibleForTesting
    boolean hasAccessTokenExpired(@NonNull Clock clock) {
        return this.accessTokenExpirationTime != null && Preconditions.checkNotNull(clock).getCurrentTimeMillis() > this.accessTokenExpirationTime;
    }

    @Nullable
    public Set<String> getScopeSet() {
        return AsciiStringListUtil.stringToSet(this.scope);
    }

    @NonNull
    public TokenRequest createTokenExchangeRequest() {
        return this.createTokenExchangeRequest(Collections.emptyMap());
    }

    @NonNull
    public TokenRequest createTokenExchangeRequest(@NonNull Map<String, String> additionalExchangeParameters) {
        Preconditions.checkNotNull(additionalExchangeParameters, "additionalExchangeParameters cannot be null");
        if (this.authorizationCode == null) {
            throw new IllegalStateException("authorizationCode not available for exchange request");
        }
        return new TokenRequest.Builder(this.request.configuration, this.request.clientId).setGrantType("authorization_code").setRedirectUri(this.request.redirectUri).setScope(this.request.scope).setCodeVerifier(this.request.codeVerifier).setAuthorizationCode(this.authorizationCode).setAdditionalParameters(additionalExchangeParameters).build();
    }

    @NonNull
    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_REQUEST, this.request.jsonSerialize());
        JsonUtil.putIfNotNull(json, KEY_STATE, this.state);
        JsonUtil.putIfNotNull(json, KEY_TOKEN_TYPE, this.tokenType);
        JsonUtil.putIfNotNull(json, KEY_AUTHORIZATION_CODE, this.authorizationCode);
        JsonUtil.putIfNotNull(json, KEY_ACCESS_TOKEN, this.accessToken);
        JsonUtil.putIfNotNull(json, KEY_EXPIRES_AT, this.accessTokenExpirationTime);
        JsonUtil.putIfNotNull(json, KEY_ID_TOKEN, this.idToken);
        JsonUtil.putIfNotNull(json, KEY_SCOPE, this.scope);
        JsonUtil.put(json, KEY_ADDITIONAL_PARAMETERS, JsonUtil.mapToJsonObject(this.additionalParameters));
        return json;
    }

    @NonNull
    public String jsonSerializeString() {
        return this.jsonSerialize().toString();
    }

    @NonNull
    public static AuthorizationResponse jsonDeserialize(@NonNull JSONObject json) throws JSONException {
        if (!json.has(KEY_REQUEST)) {
            throw new IllegalArgumentException("authorization request not provided and not found in JSON");
        }
        AuthorizationRequest request = AuthorizationRequest.jsonDeserialize(json.getJSONObject(KEY_REQUEST));
        return new Builder(request).setTokenType(JsonUtil.getStringIfDefined(json, KEY_TOKEN_TYPE)).setAccessToken(JsonUtil.getStringIfDefined(json, KEY_ACCESS_TOKEN)).setAuthorizationCode(JsonUtil.getStringIfDefined(json, KEY_AUTHORIZATION_CODE)).setIdToken(JsonUtil.getStringIfDefined(json, KEY_ID_TOKEN)).setScope(JsonUtil.getStringIfDefined(json, KEY_SCOPE)).setState(JsonUtil.getStringIfDefined(json, KEY_STATE)).setAccessTokenExpirationTime(JsonUtil.getLongIfDefined(json, KEY_EXPIRES_AT)).setAdditionalParameters(JsonUtil.getStringMap(json, KEY_ADDITIONAL_PARAMETERS)).build();
    }

    @NonNull
    public static AuthorizationResponse jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        return AuthorizationResponse.jsonDeserialize(new JSONObject(jsonStr));
    }

    @NonNull
    public Intent toIntent() {
        Intent data = new Intent();
        data.putExtra(EXTRA_RESPONSE, this.jsonSerializeString());
        return data;
    }

    @Nullable
    public static AuthorizationResponse fromIntent(@NonNull Intent dataIntent) {
        Preconditions.checkNotNull(dataIntent, "dataIntent must not be null");
        if (!dataIntent.hasExtra(EXTRA_RESPONSE)) {
            return null;
        }
        try {
            return AuthorizationResponse.jsonDeserialize(dataIntent.getStringExtra(EXTRA_RESPONSE));
        }
        catch (JSONException ex) {
            throw new IllegalArgumentException("Intent contains malformed auth response", ex);
        }
    }

    public static final class Builder {
        @NonNull
        private AuthorizationRequest mRequest;
        @Nullable
        private String mState;
        @Nullable
        private String mTokenType;
        @Nullable
        private String mAuthorizationCode;
        @Nullable
        private String mAccessToken;
        @Nullable
        private Long mAccessTokenExpirationTime;
        @Nullable
        private String mIdToken;
        @Nullable
        private String mScope;
        @NonNull
        private Map<String, String> mAdditionalParameters;

        public Builder(@NonNull AuthorizationRequest request) {
            this.mRequest = Preconditions.checkNotNull(request, "authorization request cannot be null");
            this.mAdditionalParameters = new LinkedHashMap<String, String>();
        }

        @NonNull
        public Builder fromUri(@NonNull Uri uri) {
            return this.fromUri(uri, SystemClock.INSTANCE);
        }

        @NonNull
        @VisibleForTesting
        Builder fromUri(@NonNull Uri uri, @NonNull Clock clock) {
            this.setState(uri.getQueryParameter(AuthorizationResponse.KEY_STATE));
            this.setTokenType(uri.getQueryParameter(AuthorizationResponse.KEY_TOKEN_TYPE));
            this.setAuthorizationCode(uri.getQueryParameter(AuthorizationResponse.KEY_AUTHORIZATION_CODE));
            this.setAccessToken(uri.getQueryParameter(AuthorizationResponse.KEY_ACCESS_TOKEN));
            this.setAccessTokenExpiresIn(UriUtil.getLongQueryParameter(uri, AuthorizationResponse.KEY_EXPIRES_IN), clock);
            this.setIdToken(uri.getQueryParameter(AuthorizationResponse.KEY_ID_TOKEN));
            this.setScope(uri.getQueryParameter(AuthorizationResponse.KEY_SCOPE));
            this.setAdditionalParameters(AdditionalParamsProcessor.extractAdditionalParams(uri, (Set<String>)BUILT_IN_PARAMS));
            return this;
        }

        @NonNull
        public Builder setState(@Nullable String state) {
            Preconditions.checkNullOrNotEmpty(state, "state must not be empty");
            this.mState = state;
            return this;
        }

        @NonNull
        public Builder setTokenType(@Nullable String tokenType) {
            Preconditions.checkNullOrNotEmpty(tokenType, "tokenType must not be empty");
            this.mTokenType = tokenType;
            return this;
        }

        @NonNull
        public Builder setAuthorizationCode(@Nullable String authorizationCode) {
            Preconditions.checkNullOrNotEmpty(authorizationCode, "authorizationCode must not be empty");
            this.mAuthorizationCode = authorizationCode;
            return this;
        }

        @NonNull
        public Builder setAccessToken(@Nullable String accessToken) {
            Preconditions.checkNullOrNotEmpty(accessToken, "accessToken must not be empty");
            this.mAccessToken = accessToken;
            return this;
        }

        @NonNull
        public Builder setAccessTokenExpiresIn(@Nullable Long expiresIn) {
            return this.setAccessTokenExpiresIn(expiresIn, SystemClock.INSTANCE);
        }

        @NonNull
        @VisibleForTesting
        public Builder setAccessTokenExpiresIn(@Nullable Long expiresIn, @NonNull Clock clock) {
            this.mAccessTokenExpirationTime = expiresIn == null ? null : Long.valueOf(clock.getCurrentTimeMillis() + TimeUnit.SECONDS.toMillis(expiresIn));
            return this;
        }

        @NonNull
        public Builder setAccessTokenExpirationTime(@Nullable Long expirationTime) {
            this.mAccessTokenExpirationTime = expirationTime;
            return this;
        }

        @NonNull
        public Builder setIdToken(@Nullable String idToken) {
            Preconditions.checkNullOrNotEmpty(idToken, "idToken cannot be empty");
            this.mIdToken = idToken;
            return this;
        }

        @NonNull
        public Builder setScope(@Nullable String scope) {
            if (TextUtils.isEmpty((CharSequence)scope)) {
                this.mScope = null;
            } else {
                this.setScopes(scope.split(" +"));
            }
            return this;
        }

        @NonNull
        public Builder setScopes(String ... scopes) {
            if (scopes == null) {
                this.mScope = null;
            } else {
                this.setScopes(Arrays.asList(scopes));
            }
            return this;
        }

        @NonNull
        public Builder setScopes(@Nullable Iterable<String> scopes) {
            this.mScope = AsciiStringListUtil.iterableToString(scopes);
            return this;
        }

        @NonNull
        public Builder setAdditionalParameters(@Nullable Map<String, String> additionalParameters) {
            this.mAdditionalParameters = AdditionalParamsProcessor.checkAdditionalParams(additionalParameters, BUILT_IN_PARAMS);
            return this;
        }

        @NonNull
        public AuthorizationResponse build() {
            return new AuthorizationResponse(this.mRequest, this.mState, this.mTokenType, this.mAuthorizationCode, this.mAccessToken, this.mAccessTokenExpirationTime, this.mIdToken, this.mScope, Collections.unmodifiableMap(this.mAdditionalParameters));
        }
    }
}

