/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.browser;

import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.util.Base64;
import androidx.annotation.NonNull;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;

public class BrowserDescriptor {
    private static final int PRIME_HASH_FACTOR = 92821;
    private static final String DIGEST_SHA_512 = "SHA-512";
    public final String packageName;
    public final Set<String> signatureHashes;
    public final String version;
    public final Boolean useCustomTab;

    public BrowserDescriptor(@NonNull PackageInfo packageInfo, boolean useCustomTab) {
        this(packageInfo.packageName, BrowserDescriptor.generateSignatureHashes(packageInfo.signatures), packageInfo.versionName, useCustomTab);
    }

    public BrowserDescriptor(@NonNull String packageName, @NonNull Set<String> signatureHashes, @NonNull String version, boolean useCustomTab) {
        this.packageName = packageName;
        this.signatureHashes = signatureHashes;
        this.version = version;
        this.useCustomTab = useCustomTab;
    }

    @NonNull
    public BrowserDescriptor changeUseCustomTab(boolean newUseCustomTabValue) {
        return new BrowserDescriptor(this.packageName, this.signatureHashes, this.version, newUseCustomTabValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BrowserDescriptor)) {
            return false;
        }
        BrowserDescriptor other = (BrowserDescriptor)obj;
        return this.packageName.equals(other.packageName) && this.version.equals(other.version) && this.useCustomTab == other.useCustomTab && this.signatureHashes.equals(other.signatureHashes);
    }

    public int hashCode() {
        int hash = this.packageName.hashCode();
        hash = 92821 * hash + this.version.hashCode();
        hash = 92821 * hash + (this.useCustomTab != false ? 1 : 0);
        for (String signatureHash : this.signatureHashes) {
            hash = 92821 * hash + signatureHash.hashCode();
        }
        return hash;
    }

    @NonNull
    public static String generateSignatureHash(@NonNull Signature signature) {
        try {
            MessageDigest digest = MessageDigest.getInstance(DIGEST_SHA_512);
            byte[] hashBytes = digest.digest(signature.toByteArray());
            return Base64.encodeToString((byte[])hashBytes, (int)10);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Platform does not supportSHA-512 hashing");
        }
    }

    @NonNull
    public static Set<String> generateSignatureHashes(@NonNull Signature[] signatures) {
        HashSet<String> signatureHashes = new HashSet<String>();
        for (Signature signature : signatures) {
            signatureHashes.add(BrowserDescriptor.generateSignatureHash(signature));
        }
        return signatureHashes;
    }
}

