/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;

public enum ByteBufferZMarshaller implements CompactBytesMarshaller<ByteBuffer>
{
    INSTANCE;


    @Override
    public byte code() {
        return 2;
    }

    @Override
    public void write(Bytes bytes, ByteBuffer byteBuffer) {
        bytes.writeStopBit(byteBuffer.remaining());
        long position = bytes.position();
        bytes.clear();
        bytes.position(position + 4L);
        DataOutputStream dos = new DataOutputStream(new DeflaterOutputStream(bytes.outputStream()));
        try {
            while (byteBuffer.remaining() >= 8) {
                dos.writeLong(byteBuffer.getLong());
            }
            while (byteBuffer.remaining() > 0) {
                dos.write(byteBuffer.get());
            }
            dos.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        bytes.writeUnsignedInt(position, bytes.position() - position - 4L);
        bytes.write(byteBuffer);
    }

    @Override
    public ByteBuffer read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public ByteBuffer read(Bytes bytes, @Nullable ByteBuffer byteBuffer) {
        long length = bytes.readStopBit();
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + length);
        }
        if (byteBuffer == null || (long)byteBuffer.capacity() < length) {
            byteBuffer = this.newByteBuffer((int)length);
        } else {
            byteBuffer.clear();
        }
        byteBuffer.limit((int)length);
        long position = bytes.position();
        long end = position + length;
        long limit = bytes.limit();
        bytes.limit(end);
        DataInputStream dis = new DataInputStream(new InflaterInputStream(bytes.inputStream()));
        try {
            while (byteBuffer.remaining() >= 8) {
                byteBuffer.putLong(dis.readLong());
            }
            while (byteBuffer.remaining() >= 0) {
                byteBuffer.put(dis.readByte());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        bytes.position(end);
        bytes.limit(limit);
        byteBuffer.flip();
        return byteBuffer;
    }

    protected ByteBuffer newByteBuffer(int length) {
        return ByteBuffer.allocate(length);
    }
}

