/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;
import org.xerial.snappy.Snappy;

public enum SnappyStringMarshaller implements CompactBytesMarshaller<CharSequence>
{
    INSTANCE;

    private static final StringFactory STRING_FACTORY;
    private static final int NULL_LENGTH = -1;
    private static final ThreadLocal<ThreadLocals> THREAD_LOCALS;

    private static StringFactory getStringFactory() {
        try {
            return new StringFactory17();
        }
        catch (Exception exception) {
            try {
                return new StringFactory16();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public byte code() {
        return 26;
    }

    public ThreadLocals acquireThreadLocals() {
        ThreadLocals threadLocals = THREAD_LOCALS.get();
        if (threadLocals == null) {
            threadLocals = new ThreadLocals();
            THREAD_LOCALS.set(threadLocals);
        }
        threadLocals.clear();
        return threadLocals;
    }

    @Override
    public void write(Bytes bytes, CharSequence s) {
        if (s == null) {
            bytes.writeStopBit(-1L);
            return;
        }
        if (s.length() == 0) {
            bytes.writeStopBit(0L);
            return;
        }
        int length = s.length();
        bytes.writeStopBit(length);
        ThreadLocals threadLocals = this.acquireThreadLocals();
        Bytes db = threadLocals.decompressedBytes;
        ByteBuffer dbb = threadLocals.decompressedByteBuffer;
        ByteBuffer cbb = bytes.sliceAsByteBuffer(threadLocals.compressedByteBuffer);
        int position = 0;
        while (position < length) {
            int compressedLength;
            while (position < length && db.remaining() >= 3L) {
                db.writeStopBit(s.charAt(position++));
            }
            dbb.position(0);
            dbb.limit((int)db.position());
            int portionLengthPos = cbb.position();
            cbb.putShort((short)0);
            try {
                Snappy.compress((ByteBuffer)dbb, (ByteBuffer)cbb);
                compressedLength = cbb.remaining();
                if (compressedLength >= 65536) {
                    throw new AssertionError();
                }
                cbb.position(cbb.limit());
                cbb.limit(cbb.capacity());
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            cbb.putShort(portionLengthPos, (short)compressedLength);
            db.clear();
        }
        cbb.putShort((short)0);
        bytes.position(bytes.position() + (long)cbb.position());
    }

    @Override
    public String read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public String read(Bytes bytes, @Nullable CharSequence ignored) {
        int chunkLen;
        long size = bytes.readStopBit();
        if (size == -1L) {
            return null;
        }
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + size);
        }
        if (size == 0L) {
            return "";
        }
        ThreadLocals threadLocals = this.acquireThreadLocals();
        Bytes db = threadLocals.decompressedBytes;
        ByteBuffer dbb = threadLocals.decompressedByteBuffer;
        ByteBuffer cbb = bytes.sliceAsByteBuffer(threadLocals.compressedByteBuffer);
        char[] chars = new char[(int)size];
        int pos = 0;
        while ((chunkLen = cbb.getShort() & 0xFFFF) > 0) {
            cbb.limit(cbb.position() + chunkLen);
            dbb.clear();
            try {
                Snappy.uncompress((ByteBuffer)cbb, (ByteBuffer)dbb);
                cbb.position(cbb.limit());
                cbb.limit(cbb.capacity());
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            db.position(0L);
            db.limit(dbb.limit());
            while (db.remaining() > 0L) {
                chars[pos++] = (char)db.readStopBit();
            }
        }
        bytes.position(bytes.position() + (long)cbb.position());
        try {
            return STRING_FACTORY.fromChars(chars);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        STRING_FACTORY = SnappyStringMarshaller.getStringFactory();
        THREAD_LOCALS = new ThreadLocal();
    }

    private static final class StringFactory17
    extends StringFactory {
        private final Constructor<String> constructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);

        private StringFactory17() throws NoSuchMethodException {
            this.constructor.setAccessible(true);
        }

        @Override
        String fromChars(char[] chars) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return this.constructor.newInstance(chars, true);
        }
    }

    private static final class StringFactory16
    extends StringFactory {
        private final Constructor<String> constructor = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);

        private StringFactory16() throws NoSuchMethodException {
            this.constructor.setAccessible(true);
        }

        @Override
        String fromChars(char[] chars) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return this.constructor.newInstance(0, chars.length, chars);
        }
    }

    private static abstract class StringFactory {
        private StringFactory() {
        }

        abstract String fromChars(char[] var1) throws IllegalAccessException, InvocationTargetException, InstantiationException;
    }

    static class ThreadLocals {
        ByteBuffer decompressedByteBuffer = ByteBuffer.allocateDirect(32768);
        Bytes decompressedBytes = ByteBufferBytes.wrap(this.decompressedByteBuffer);
        ByteBuffer compressedByteBuffer = ByteBuffer.allocateDirect(0);

        ThreadLocals() {
        }

        public void clear() {
            this.decompressedByteBuffer.clear();
            this.decompressedBytes.clear();
            this.compressedByteBuffer.clear();
        }
    }
}

