/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;

public enum StringZMapMarshaller implements CompactBytesMarshaller<Map<String, String>>
{
    FAST(1),
    COMPACT(9),
    INSTANCE(0);

    private final int level;
    private static final long NULL_SIZE = -1L;

    private StringZMapMarshaller(int level) {
        this.level = level;
    }

    @Override
    public byte code() {
        return 25;
    }

    @Override
    public void write(Bytes bytes, Map<String, String> kvMap) {
        if (kvMap == null) {
            bytes.writeStopBit(-1L);
            return;
        }
        bytes.writeStopBit(kvMap.size());
        long position = bytes.position();
        bytes.clear();
        bytes.position(position + 4L);
        DataOutputStream dos = new DataOutputStream(new DeflaterOutputStream(bytes.outputStream(), new Deflater(this.level)));
        try {
            for (Map.Entry<String, String> entry : kvMap.entrySet()) {
                dos.writeUTF(entry.getKey());
                dos.writeUTF(entry.getValue());
            }
            dos.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        bytes.writeUnsignedInt(position, bytes.position() - position - 4L);
    }

    @Override
    public Map<String, String> read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public Map<String, String> read(Bytes bytes, @Nullable Map<String, String> kvMap) {
        long size = bytes.readStopBit();
        if (size == -1L) {
            return null;
        }
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + size);
        }
        long length = bytes.readUnsignedInt();
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalStateException(new StreamCorruptedException());
        }
        long position = bytes.position();
        long end = position + length;
        long limit = bytes.limit();
        bytes.limit(end);
        DataInputStream dis = new DataInputStream(new InflaterInputStream(bytes.inputStream()));
        if (kvMap == null) {
            kvMap = new LinkedHashMap<String, String>();
        } else {
            kvMap.clear();
        }
        try {
            int i = 0;
            while ((long)i < size) {
                String key = dis.readUTF();
                String value = dis.readUTF();
                kvMap.put(key, value);
                ++i;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        bytes.position(end);
        bytes.limit(limit);
        return kvMap;
    }
}

