/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.model.constraints.NotNull;

public enum JDKZObjectSerializer implements ObjectSerializer
{
    INSTANCE;


    @Override
    public void writeSerializable(Bytes bytes, Object object, Class expectedClass) throws IOException {
        long position = bytes.position();
        bytes.clear();
        bytes.position(position + 4L);
        OutputStream out = bytes.outputStream();
        ObjectOutputStream oos = new ObjectOutputStream(new DeflaterOutputStream(out));
        oos.writeObject(object);
        oos.close();
        long length = bytes.position() - position - 4L;
        bytes.writeUnsignedInt(position, length);
    }

    @Override
    public <T> T readSerializable(@NotNull Bytes bytes, Class<T> expectedClass, T object) throws IOException, ClassNotFoundException {
        long length = bytes.readUnsignedInt();
        if (length < 8L || length > Integer.MAX_VALUE) {
            throw new StreamCorruptedException("length = " + Long.toHexString(length));
        }
        long end = bytes.position() + length;
        long lim = bytes.limit();
        bytes.limit(end);
        int magic = bytes.readUnsignedShort(bytes.position());
        InputStream in = bytes.inputStream();
        switch (magic) {
            case 60844: {
                break;
            }
            case 40056: {
                in = new InflaterInputStream(in);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown magic number " + Integer.toHexString(magic));
            }
        }
        Object t = new ObjectInputStream(in).readObject();
        bytes.limit(lim);
        if (end != bytes.position()) {
            System.out.println("diff: " + (end - bytes.position()));
            bytes.position(end);
        }
        return (T)t;
    }
}

