/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.nio.MappedByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.ReferenceCounted;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectByteBufferBytes;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.io.serialization.ObjectSerializer;
import sun.nio.ch.DirectBuffer;

public class MappedMemory
implements ReferenceCounted,
BytesStore {
    private final MappedByteBuffer buffer;
    private final DirectByteBufferBytes bytes;
    private final long index;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private volatile boolean unmapped = false;

    public MappedMemory(MappedByteBuffer buffer, long index) {
        this.buffer = buffer;
        this.index = index;
        this.bytes = new DirectByteBufferBytes(buffer);
    }

    public long index() {
        return this.index;
    }

    @Override
    public void reserve() {
        if (this.unmapped) {
            throw new IllegalStateException();
        }
        this.refCount.incrementAndGet();
    }

    @Override
    public boolean release() {
        if (this.unmapped) {
            throw new IllegalStateException();
        }
        if (this.refCount.decrementAndGet() > 0) {
            return false;
        }
        this.close();
        return true;
    }

    @Override
    public int refCount() {
        return this.refCount.get();
    }

    public MappedByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public long address() {
        return ((DirectBuffer)((Object)this.buffer)).address();
    }

    @Override
    public long size() {
        return this.bytes.capacity();
    }

    @Override
    public void free() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectSerializer objectSerializer() {
        return null;
    }

    @Override
    public File file() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bytes bytes() {
        return this.bytes;
    }

    @Override
    public Bytes bytes(long offset, long length) {
        throw new UnsupportedOperationException();
    }

    public static void release(MappedMemory mapmem) {
        if (mapmem != null) {
            mapmem.release();
        }
    }

    public void force() {
        if (!this.unmapped) {
            this.buffer.force();
        }
    }

    public void close() {
        IOTools.clean(this.buffer);
        this.unmapped = true;
    }
}

