/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.IOException;
import java.lang.reflect.Field;
import net.openhft.lang.io.MappedFile;
import net.openhft.lang.io.MappedMemory;
import net.openhft.lang.model.constraints.NotNull;
import sun.misc.Unsafe;

public class ChronicleUnsafe {
    private final MappedFile mappedFile;
    private MappedMemory mappedMemory = null;
    public static final Unsafe UNSAFE;
    private long chunkSize;
    private long offset;
    private final long mask;
    private long last = -1L;

    public ChronicleUnsafe(@NotNull MappedFile mappedFile) {
        long blockSize = mappedFile.blockSize();
        if ((blockSize & -blockSize) != blockSize) {
            throw new IllegalStateException("the block size has to be a power of 2");
        }
        this.mappedFile = mappedFile;
        this.chunkSize = mappedFile.blockSize();
        long shift = (int)(Math.log(blockSize) / Math.log(2.0));
        this.mask = (1L << (int)shift) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public long toAddress(long address) {
        return (this.mask & address ^ this.last) == 0L ? address + this.offset : this.toAddress0(address);
    }

    public long toAddress0(long address) {
        int index = (int)(address / this.chunkSize);
        long remainder = address - (long)index * this.chunkSize;
        if (this.mappedMemory != null && this.mappedMemory.index() != 0L) {
            this.mappedFile.release(this.mappedMemory);
        }
        try {
            this.mappedMemory = this.mappedFile.acquire(index);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        long result = this.mappedMemory.bytes().address() + remainder;
        this.offset = result - address;
        this.last = this.mask & address;
        return result;
    }

    public long toRemainingInChunk(long address) {
        int chunk = (int)(address / this.chunkSize);
        long remainder = address - (long)chunk * this.chunkSize;
        return this.mappedMemory.bytes().capacity() - remainder;
    }

    public int arrayBaseOffset(Class<?> aClass) {
        return UNSAFE.arrayBaseOffset(aClass);
    }

    public int pageSize() {
        throw new UnsupportedOperationException("todo");
    }

    public long allocateMemory(int aVoid) {
        throw new UnsupportedOperationException("todo");
    }

    public long getLong(byte[] bytes, long address) {
        return UNSAFE.getLong(bytes, this.toAddress(address));
    }

    public long getLong(Object object, long address) {
        return UNSAFE.getLong(object, this.toAddress(address));
    }

    public void setMemory(long startAddress, long len, byte defaultValue) {
        long remainingInChunk;
        for (long remaining = len; remaining > 0L; remaining -= remainingInChunk) {
            long address = this.toAddress(startAddress);
            remainingInChunk = this.toRemainingInChunk(startAddress);
            if (remainingInChunk > remaining) {
                remainingInChunk = remaining;
            }
            UNSAFE.setMemory(address, remainingInChunk, defaultValue);
            startAddress += remainingInChunk;
        }
    }

    public byte getByte(long address) {
        return UNSAFE.getByte(this.toAddress(address));
    }

    public void putByte(long address, byte value) {
        UNSAFE.putByte(this.toAddress(address), value);
    }

    public void putLong(long address, long value) {
        UNSAFE.putLong(this.toAddress(address), value);
    }

    public long getLong(long address) {
        return UNSAFE.getLong(this.toAddress(address));
    }

    public void copyMemory(Object o, long positionAddr, Object bytes, long i, long len2) {
        throw new UnsupportedOperationException("todo");
    }

    public short getShort(long address) {
        return UNSAFE.getShort(this.toAddress(address));
    }

    public char getChar(long address) {
        return UNSAFE.getChar(this.toAddress(address));
    }

    public int getInt(long address) {
        return UNSAFE.getInt(this.toAddress(address));
    }

    public int getIntVolatile(Object o, long address) {
        return UNSAFE.getIntVolatile(o, this.toAddress(address));
    }

    public long getLongVolatile(Object o, long address) {
        return UNSAFE.getLongVolatile(o, this.toAddress(address));
    }

    public float getFloat(long address) {
        return UNSAFE.getFloat(this.toAddress(address));
    }

    public double getDouble(long address) {
        return UNSAFE.getDouble(this.toAddress(address));
    }

    public void putShort(long address, short v) {
        UNSAFE.putShort(this.toAddress(address), v);
    }

    public void putChar(long address, char v) {
        UNSAFE.putChar(this.toAddress(address), v);
    }

    public void putInt(long address, int v) {
        UNSAFE.putInt(this.toAddress(address), v);
    }

    public void putOrderedInt(Object o, long address, int v) {
        UNSAFE.putOrderedInt(o, this.toAddress(address), v);
    }

    public boolean compareAndSwapInt(Object o, long address, int expected, int v) {
        return UNSAFE.compareAndSwapInt(o, this.toAddress(address), expected, v);
    }

    public void putOrderedLong(Object o, long address, long v) {
        UNSAFE.putOrderedLong(o, this.toAddress(address), v);
    }

    public boolean compareAndSwapLong(Object o, long address, long expected, long v) {
        return UNSAFE.compareAndSwapLong(o, this.toAddress(address), expected, v);
    }

    public void putFloat(long address, float v) {
        UNSAFE.putFloat(this.toAddress(address), v);
    }

    public void putDouble(long address, double v) {
        UNSAFE.putDouble(this.toAddress(address), v);
    }

    public void putLong(Object o, long address, long aLong) {
        UNSAFE.putLong(o, this.toAddress(address), aLong);
    }

    public void putByte(Object o, long address, byte aByte) {
        UNSAFE.putByte(o, this.toAddress(address), aByte);
    }

    public byte getByte(Object o, long address) {
        return UNSAFE.getByte(o, this.toAddress(address));
    }

    public void copyMemory(long l, long positionAddr, long length) {
        throw new UnsupportedOperationException("todo");
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

