/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.view;

import java.io.IOException;
import java.io.OutputStream;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public class BytesOutputStream
extends OutputStream {
    private Bytes bytes;

    public BytesOutputStream(Bytes bytes) {
        this.bytes = bytes;
    }

    public BytesOutputStream() {
    }

    public BytesOutputStream bytes(Bytes bytes) {
        this.bytes = bytes;
        return this;
    }

    @Override
    public void close() {
    }

    private void checkNotClosed() throws IOException {
        if (this.bytes.isFinished()) {
            throw new IOException("Underlying bytes is closed");
        }
    }

    private void checkAvailable(int n) throws IOException {
        if ((long)n > this.bytes.remaining()) {
            throw new IOException("Not enough available space for writing " + n + " bytes");
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.checkNotClosed();
        this.checkAvailable(len);
        this.bytes.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkNotClosed();
        this.checkAvailable(1);
        this.bytes.writeUnsignedByte(b);
    }
}

