/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.ByteStringAppender;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.MutableDecimal;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.NativeBytesI;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.StopCharTester;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.pool.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckedNativeBytes
implements Bytes,
NativeBytesI {
    private final NativeBytes nativeBytes;
    volatile boolean isClosed = false;

    public CheckedNativeBytes(long startAddr, long capacityAddr) {
        this.checkNotClosed();
        this.nativeBytes = new NativeBytes(startAddr, capacityAddr);
    }

    public CheckedNativeBytes(BytesMarshallerFactory bytesMarshallerFactory, long startAddr, long capacityAddr, AtomicInteger refCount) {
        this.checkNotClosed();
        this.nativeBytes = new NativeBytes(bytesMarshallerFactory, startAddr, capacityAddr, refCount);
    }

    public CheckedNativeBytes(ObjectSerializer objectSerializer, long startAddr, long capacityAddr, AtomicInteger refCount) {
        this.checkNotClosed();
        this.nativeBytes = new NativeBytes(objectSerializer, startAddr, capacityAddr, refCount);
    }

    public CheckedNativeBytes(NativeBytes bytes) {
        this.checkNotClosed();
        this.nativeBytes = new NativeBytes(bytes);
    }

    @Override
    public void clearThreadAssociation() {
        this.checkNotClosed();
        this.nativeBytes.clearThreadAssociation();
    }

    boolean checkSingleThread() {
        this.checkNotClosed();
        return this.nativeBytes.checkSingleThread();
    }

    @Override
    public long size() {
        this.checkNotClosed();
        return this.nativeBytes.size();
    }

    void checkNotClosed() {
        if (this.isClosed) {
            ThreadInfo[] threads;
            System.err.print("Thread " + Thread.currentThread().getName() + " performing processing " + "after free()");
            for (ThreadInfo info : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                System.out.print(info);
            }
            System.exit(-1);
        }
    }

    @Override
    public void free() {
        this.isClosed = true;
        this.nativeBytes.free();
    }

    @Override
    public void reserve() {
        this.checkNotClosed();
        this.nativeBytes.reserve();
    }

    @Override
    public void release() {
        this.checkNotClosed();
        this.nativeBytes.release();
    }

    @Override
    public int refCount() {
        this.checkNotClosed();
        return this.nativeBytes.refCount();
    }

    StringInterner stringInterner() {
        this.checkNotClosed();
        return this.nativeBytes.stringInterner();
    }

    @Override
    public void selfTerminating(boolean selfTerminating) {
        this.checkNotClosed();
        this.nativeBytes.selfTerminating(selfTerminating);
    }

    @Override
    public boolean selfTerminating() {
        this.checkNotClosed();
        return this.nativeBytes.selfTerminating();
    }

    @Override
    public int readUnsignedByteOrThrow() throws BufferUnderflowException {
        return this.nativeBytes.readUnsignedByteOrThrow();
    }

    public int readByteOrThrow(boolean selfTerminating) throws BufferUnderflowException {
        return this.nativeBytes.readByteOrThrow(selfTerminating);
    }

    @Override
    public Boolean parseBoolean(@NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.nativeBytes.parseBoolean(tester);
    }

    @Override
    public void readFully(@NotNull byte[] bytes) {
        this.checkNotClosed();
        this.nativeBytes.readFully(bytes);
    }

    @Override
    public void readFully(@NotNull char[] data) {
        this.checkNotClosed();
        this.nativeBytes.readFully(data);
    }

    @Override
    public int skipBytes(int n) {
        this.checkNotClosed();
        return this.nativeBytes.skipBytes(n);
    }

    @Override
    public boolean readBoolean() {
        this.checkNotClosed();
        return this.nativeBytes.readBoolean();
    }

    @Override
    public boolean readBoolean(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readBoolean(offset);
    }

    @Override
    public int readUnsignedByte() {
        this.checkNotClosed();
        return this.nativeBytes.readUnsignedByte();
    }

    @Override
    public int readUnsignedByte(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readUnsignedByte(offset);
    }

    @Override
    public int readUnsignedShort() {
        this.checkNotClosed();
        return this.nativeBytes.readUnsignedShort();
    }

    @Override
    public int readUnsignedShort(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readUnsignedShort(offset);
    }

    @Override
    @NotNull
    public String readLine() {
        this.checkNotClosed();
        return this.nativeBytes.readLine();
    }

    @Override
    @Nullable
    public String readUTF\u0394() {
        this.checkNotClosed();
        return this.nativeBytes.readUTF\u0394();
    }

    @Override
    @Nullable
    public String readUTF\u0394(long offset) throws IllegalStateException {
        return this.nativeBytes.readUTF\u0394(offset);
    }

    @Override
    public boolean readUTF\u0394(@NotNull StringBuilder stringBuilder) {
        this.checkNotClosed();
        return this.nativeBytes.readUTF\u0394(stringBuilder);
    }

    @Override
    @NotNull
    public String parseUTF(@NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.nativeBytes.parseUTF(tester);
    }

    @Override
    public void parseUTF(@NotNull StringBuilder builder, @NotNull StopCharTester tester) {
        this.checkNotClosed();
        this.nativeBytes.parseUTF(builder, tester);
    }

    @Override
    public boolean stepBackAndSkipTo(@NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.nativeBytes.stepBackAndSkipTo(tester);
    }

    @Override
    public boolean skipTo(@NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.nativeBytes.skipTo(tester);
    }

    @Override
    @NotNull
    public String readUTF() {
        this.checkNotClosed();
        return this.nativeBytes.readUTF();
    }

    @Override
    public short readCompactShort() {
        this.checkNotClosed();
        return this.nativeBytes.readCompactShort();
    }

    @Override
    public int readCompactUnsignedShort() {
        this.checkNotClosed();
        return this.nativeBytes.readCompactUnsignedShort();
    }

    @Override
    public int readInt24() {
        this.checkNotClosed();
        return this.nativeBytes.readInt24();
    }

    @Override
    public int readInt24(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readInt24(offset);
    }

    @Override
    public long readUnsignedInt() {
        this.checkNotClosed();
        return this.nativeBytes.readUnsignedInt();
    }

    @Override
    public long readUnsignedInt(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readUnsignedInt(offset);
    }

    @Override
    public int readCompactInt() {
        this.checkNotClosed();
        return this.nativeBytes.readCompactInt();
    }

    @Override
    public long readCompactUnsignedInt() {
        this.checkNotClosed();
        return this.nativeBytes.readCompactUnsignedInt();
    }

    @Override
    public long readInt48() {
        this.checkNotClosed();
        return this.nativeBytes.readInt48();
    }

    @Override
    public long readInt48(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readInt48(offset);
    }

    @Override
    public long readCompactLong() {
        this.checkNotClosed();
        return this.nativeBytes.readCompactLong();
    }

    @Override
    public long readStopBit() {
        this.checkNotClosed();
        return this.nativeBytes.readStopBit();
    }

    @Override
    public double readCompactDouble() {
        this.checkNotClosed();
        return this.nativeBytes.readCompactDouble();
    }

    @Override
    public void read(@NotNull ByteBuffer bb) {
        this.checkNotClosed();
        this.nativeBytes.read(bb);
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        this.checkNotClosed();
        this.nativeBytes.write(bytes);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.checkNotClosed();
        this.nativeBytes.writeBoolean(v);
    }

    @Override
    public void writeBoolean(long offset, boolean v) {
        this.checkNotClosed();
        this.nativeBytes.writeBoolean(offset, v);
    }

    @Override
    public void writeBytes(@NotNull String s) {
        this.checkNotClosed();
        this.nativeBytes.writeBytes(s);
    }

    @Override
    public void writeChars(@NotNull String s) {
        this.checkNotClosed();
        this.nativeBytes.writeChars(s);
    }

    @Override
    public void writeChars(@NotNull CharSequence cs) {
        this.checkNotClosed();
        this.nativeBytes.writeChars(cs);
    }

    @Override
    public void writeUTF(@NotNull String str) {
        this.checkNotClosed();
        this.nativeBytes.writeUTF(str);
    }

    @Override
    public void writeUTF\u0394(@Nullable CharSequence str) throws IllegalArgumentException {
        this.nativeBytes.writeUTF\u0394(str);
    }

    @Override
    public void writeUTF\u0394(long offset, int maxSize, @Nullable CharSequence s) throws IllegalStateException {
        this.nativeBytes.writeUTF\u0394(offset, maxSize, s);
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull CharSequence str) {
        this.checkNotClosed();
        return this.nativeBytes.append(str);
    }

    @Override
    public void writeByte(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeByte(v);
    }

    @Override
    public void writeUnsignedByte(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeUnsignedByte(v);
    }

    @Override
    public void writeUnsignedByte(long offset, int v) {
        this.checkNotClosed();
        this.nativeBytes.writeUnsignedByte(offset, v);
    }

    @Override
    public void write(@NotNull char[] data) {
        this.checkNotClosed();
        this.nativeBytes.write(data);
    }

    @Override
    public void write(@NotNull char[] data, int off, int len) {
        this.checkNotClosed();
        this.nativeBytes.write(data, off, len);
    }

    @Override
    public void writeUnsignedShort(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeUnsignedShort(v);
    }

    @Override
    public void writeUnsignedShort(long offset, int v) {
        this.checkNotClosed();
        this.nativeBytes.writeUnsignedShort(offset, v);
    }

    @Override
    public void writeCompactShort(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeCompactShort(v);
    }

    @Override
    public void writeCompactUnsignedShort(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeCompactUnsignedShort(v);
    }

    @Override
    public void writeInt24(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeInt24(v);
    }

    @Override
    public void writeInt24(long offset, int v) {
        this.checkNotClosed();
        this.nativeBytes.writeInt24(offset, v);
    }

    @Override
    public void writeUnsignedInt(long v) {
        this.checkNotClosed();
        this.nativeBytes.writeUnsignedInt(v);
    }

    @Override
    public void writeUnsignedInt(long offset, long v) {
        this.checkNotClosed();
        this.nativeBytes.writeUnsignedInt(offset, v);
    }

    @Override
    public void writeCompactInt(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeCompactInt(v);
    }

    @Override
    public void writeCompactUnsignedInt(long v) {
        this.checkNotClosed();
        this.nativeBytes.writeCompactUnsignedInt(v);
    }

    @Override
    public void writeInt48(long v) {
        this.checkNotClosed();
        this.nativeBytes.writeInt48(v);
    }

    @Override
    public void writeInt48(long offset, long v) {
        this.checkNotClosed();
        this.nativeBytes.writeInt48(offset, v);
    }

    @Override
    public void writeCompactLong(long v) {
        this.checkNotClosed();
        this.nativeBytes.writeCompactLong(v);
    }

    @Override
    public void writeStopBit(long n) {
        this.checkNotClosed();
        this.nativeBytes.writeStopBit(n);
    }

    @Override
    public void writeCompactDouble(double v) {
        this.checkNotClosed();
        this.nativeBytes.writeCompactDouble(v);
    }

    @Override
    public void write(@NotNull ByteBuffer bb) {
        this.checkNotClosed();
        this.nativeBytes.write(bb);
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull CharSequence s, int start, int end) {
        this.checkNotClosed();
        return this.nativeBytes.append(s, start, end);
    }

    @Override
    @NotNull
    public ByteStringAppender append(@Nullable Enum value) {
        this.checkNotClosed();
        return this.nativeBytes.append(value);
    }

    @Override
    @NotNull
    public ByteStringAppender append(boolean b) {
        this.checkNotClosed();
        return this.nativeBytes.append(b);
    }

    @Override
    @NotNull
    public ByteStringAppender append(char c) {
        this.checkNotClosed();
        return this.nativeBytes.append(c);
    }

    @Override
    @NotNull
    public ByteStringAppender append(int num) {
        this.checkNotClosed();
        return this.nativeBytes.append(num);
    }

    @Override
    @NotNull
    public ByteStringAppender append(long num) {
        this.checkNotClosed();
        return this.nativeBytes.append(num);
    }

    @Override
    @NotNull
    public ByteStringAppender append(long num, int base) {
        this.checkNotClosed();
        return this.nativeBytes.append(num, base);
    }

    @Override
    @NotNull
    public ByteStringAppender appendDateMillis(long timeInMS) {
        this.checkNotClosed();
        return this.nativeBytes.appendDateMillis(timeInMS);
    }

    @Override
    @NotNull
    public ByteStringAppender appendDateTimeMillis(long timeInMS) {
        this.checkNotClosed();
        return this.nativeBytes.appendDateTimeMillis(timeInMS);
    }

    @Override
    @NotNull
    public ByteStringAppender appendTimeMillis(long timeInMS) {
        this.checkNotClosed();
        return this.nativeBytes.appendTimeMillis(timeInMS);
    }

    @Override
    @NotNull
    public ByteStringAppender append(double d) {
        this.checkNotClosed();
        return this.nativeBytes.append(d);
    }

    @Override
    public double parseDouble() {
        this.checkNotClosed();
        return this.nativeBytes.parseDouble();
    }

    @Override
    @NotNull
    public <E> ByteStringAppender append(@NotNull Iterable<E> list, @NotNull CharSequence separator) {
        this.checkNotClosed();
        return this.nativeBytes.append(list, separator);
    }

    @NotNull
    <E> ByteStringAppender append(@NotNull List<E> list, @NotNull CharSequence separator) {
        this.checkNotClosed();
        return this.nativeBytes.append(list, separator);
    }

    @Override
    @NotNull
    public MutableDecimal parseDecimal(@NotNull MutableDecimal decimal) {
        this.checkNotClosed();
        return this.nativeBytes.parseDecimal(decimal);
    }

    @Override
    public long parseLong() {
        this.checkNotClosed();
        return this.nativeBytes.parseLong();
    }

    @Override
    public long parseLong(int base) {
        this.checkNotClosed();
        return this.nativeBytes.parseLong(base);
    }

    @Override
    @NotNull
    public ByteStringAppender append(double d, int precision) {
        this.checkNotClosed();
        return this.nativeBytes.append(d, precision);
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull MutableDecimal md) {
        this.checkNotClosed();
        return this.nativeBytes.append(md);
    }

    @Override
    @NotNull
    public InputStream inputStream() {
        this.checkNotClosed();
        return this.nativeBytes.inputStream();
    }

    @Override
    @NotNull
    public OutputStream outputStream() {
        this.checkNotClosed();
        return this.nativeBytes.outputStream();
    }

    @Override
    @NotNull
    public ObjectSerializer objectSerializer() {
        this.checkNotClosed();
        return this.nativeBytes.objectSerializer();
    }

    @Override
    public <E> void writeEnum(@Nullable E e) {
        this.checkNotClosed();
        this.nativeBytes.writeEnum(e);
    }

    @Override
    public <E> E readEnum(@NotNull Class<E> eClass) {
        this.checkNotClosed();
        return this.nativeBytes.readEnum(eClass);
    }

    @Override
    public <E extends Enum<E>> E parseEnum(@NotNull Class<E> eClass, @NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.nativeBytes.parseEnum(eClass, tester);
    }

    @Override
    public <E> void writeList(@NotNull Collection<E> list) {
        this.checkNotClosed();
        this.nativeBytes.writeList(list);
    }

    @Override
    public <K, V> void writeMap(@NotNull Map<K, V> map) {
        this.checkNotClosed();
        this.nativeBytes.writeMap(map);
    }

    @Override
    public <E> void readList(@NotNull Collection<E> list, @NotNull Class<E> eClass) {
        this.checkNotClosed();
        this.nativeBytes.readList(list, eClass);
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> readMap(@NotNull Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass) {
        this.checkNotClosed();
        return this.nativeBytes.readMap(map, kClass, vClass);
    }

    @Override
    public int available() {
        this.checkNotClosed();
        return this.nativeBytes.available();
    }

    @Override
    public int read() {
        this.checkNotClosed();
        return this.nativeBytes.read();
    }

    @Override
    public int read(@NotNull byte[] bytes) {
        this.checkNotClosed();
        return this.nativeBytes.read(bytes);
    }

    @Override
    public long skip(long n) {
        this.checkNotClosed();
        return this.nativeBytes.skip(n);
    }

    @Override
    public void close() {
        this.checkNotClosed();
        this.nativeBytes.close();
    }

    @Override
    public void finish() throws IndexOutOfBoundsException {
        this.nativeBytes.finish();
    }

    @Override
    public boolean isFinished() {
        this.checkNotClosed();
        return this.nativeBytes.isFinished();
    }

    @Override
    public AbstractBytes clear() {
        this.checkNotClosed();
        return this.nativeBytes.clear();
    }

    @Override
    public Bytes flip() {
        this.checkNotClosed();
        return this.nativeBytes.flip();
    }

    @Override
    public void flush() {
        this.checkNotClosed();
        this.nativeBytes.flush();
    }

    @Override
    @Nullable
    public Object readObject() {
        this.checkNotClosed();
        return this.nativeBytes.readObject();
    }

    @Override
    @Nullable
    public <T> T readObject(Class<T> tClass) throws IllegalStateException {
        return this.nativeBytes.readObject(tClass);
    }

    @Override
    @Nullable
    public <T> T readInstance(@NotNull Class<T> objClass, T obj) {
        this.checkNotClosed();
        return this.nativeBytes.readInstance(objClass, obj);
    }

    @Override
    public void writeObject(@Nullable Object obj) {
        this.checkNotClosed();
        this.nativeBytes.writeObject(obj);
    }

    @Override
    public <OBJ> void writeInstance(@NotNull Class<OBJ> objClass, @NotNull OBJ obj) {
        this.checkNotClosed();
        this.nativeBytes.writeInstance(objClass, obj);
    }

    @Override
    public boolean tryLockInt(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.tryLockInt(offset);
    }

    @Override
    public boolean tryLockNanosInt(long offset, long nanos) {
        this.checkNotClosed();
        return this.nativeBytes.tryLockNanosInt(offset, nanos);
    }

    @Override
    public void busyLockInt(long offset) throws InterruptedException, IllegalStateException {
        this.nativeBytes.busyLockInt(offset);
    }

    @Override
    public void unlockInt(long offset) throws IllegalMonitorStateException {
        this.nativeBytes.unlockInt(offset);
    }

    @Override
    public void resetLockInt(long offset) {
        this.checkNotClosed();
        this.nativeBytes.resetLockInt(offset);
    }

    @Override
    public int threadIdForLockInt(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.threadIdForLockInt(offset);
    }

    int shortThreadId() {
        this.checkNotClosed();
        return this.nativeBytes.shortThreadId();
    }

    int shortThreadId0() {
        this.checkNotClosed();
        return this.nativeBytes.shortThreadId0();
    }

    Thread currentThread() {
        this.checkNotClosed();
        return this.nativeBytes.currentThread();
    }

    @Override
    public boolean tryLockLong(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.tryLockLong(offset);
    }

    long uniqueTid() {
        this.checkNotClosed();
        return this.nativeBytes.uniqueTid();
    }

    @Override
    public boolean tryLockNanosLong(long offset, long nanos) {
        this.checkNotClosed();
        return this.nativeBytes.tryLockNanosLong(offset, nanos);
    }

    @Override
    public void busyLockLong(long offset) throws InterruptedException, IllegalStateException {
        this.nativeBytes.busyLockLong(offset);
    }

    @Override
    public void unlockLong(long offset) throws IllegalMonitorStateException {
        this.nativeBytes.unlockLong(offset);
    }

    @Override
    public void resetLockLong(long offset) {
        this.checkNotClosed();
        this.nativeBytes.resetLockLong(offset);
    }

    @Override
    public long threadIdForLockLong(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.threadIdForLockLong(offset);
    }

    long getId() {
        this.checkNotClosed();
        return this.nativeBytes.getId();
    }

    @Override
    public int getAndAdd(long offset, int delta) {
        this.checkNotClosed();
        return this.nativeBytes.getAndAdd(offset, delta);
    }

    @Override
    public int addAndGetInt(long offset, int delta) {
        this.checkNotClosed();
        return this.nativeBytes.addAndGetInt(offset, delta);
    }

    @Override
    public byte addByte(long offset, byte b) {
        this.checkNotClosed();
        return this.nativeBytes.addByte(offset, b);
    }

    @Override
    public int addUnsignedByte(long offset, int i) {
        this.checkNotClosed();
        return this.nativeBytes.addUnsignedByte(offset, i);
    }

    @Override
    public short addShort(long offset, short s) {
        this.checkNotClosed();
        return this.nativeBytes.addShort(offset, s);
    }

    @Override
    public int addUnsignedShort(long offset, int i) {
        this.checkNotClosed();
        return this.nativeBytes.addUnsignedShort(offset, i);
    }

    @Override
    public int addInt(long offset, int i) {
        this.checkNotClosed();
        return this.nativeBytes.addInt(offset, i);
    }

    @Override
    public long addUnsignedInt(long offset, long i) {
        this.checkNotClosed();
        return this.nativeBytes.addUnsignedInt(offset, i);
    }

    @Override
    public long addLong(long offset, long i) {
        this.checkNotClosed();
        return this.nativeBytes.addLong(offset, i);
    }

    @Override
    public float addFloat(long offset, float f) {
        this.checkNotClosed();
        return this.nativeBytes.addFloat(offset, f);
    }

    @Override
    public double addDouble(long offset, double d) {
        this.checkNotClosed();
        return this.nativeBytes.addDouble(offset, d);
    }

    @Override
    public int addAtomicInt(long offset, int i) {
        this.checkNotClosed();
        return this.nativeBytes.addAtomicInt(offset, i);
    }

    @Override
    public long addAtomicLong(long offset, long delta) {
        this.checkNotClosed();
        return this.nativeBytes.addAtomicLong(offset, delta);
    }

    @Override
    public float addAtomicFloat(long offset, float delta) {
        this.checkNotClosed();
        return this.nativeBytes.addAtomicFloat(offset, delta);
    }

    @Override
    public double addAtomicDouble(long offset, double delta) {
        this.checkNotClosed();
        return this.nativeBytes.addAtomicDouble(offset, delta);
    }

    @Override
    public float readVolatileFloat(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readVolatileFloat(offset);
    }

    @Override
    public double readVolatileDouble(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readVolatileDouble(offset);
    }

    @Override
    public void writeOrderedFloat(long offset, float v) {
        this.checkNotClosed();
        this.nativeBytes.writeOrderedFloat(offset, v);
    }

    @Override
    public void writeOrderedDouble(long offset, double v) {
        this.checkNotClosed();
        this.nativeBytes.writeOrderedDouble(offset, v);
    }

    @Override
    public int length() {
        this.checkNotClosed();
        return this.nativeBytes.length();
    }

    @Override
    public char charAt(int index) {
        this.checkNotClosed();
        return this.nativeBytes.charAt(index);
    }

    @Override
    public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        this.nativeBytes.readMarshallable(in);
    }

    @Override
    public void writeMarshallable(@NotNull Bytes out) {
        this.checkNotClosed();
        this.nativeBytes.writeMarshallable(out);
    }

    @Override
    public void write(RandomDataInput bytes) {
        this.checkNotClosed();
        this.nativeBytes.write(bytes);
    }

    @Override
    public boolean startsWith(RandomDataInput input) {
        this.checkNotClosed();
        return this.nativeBytes.startsWith(input);
    }

    @Override
    @NotNull
    public String toString() {
        this.checkNotClosed();
        return this.nativeBytes.toString();
    }

    @Override
    @NotNull
    public String toDebugString() {
        this.checkNotClosed();
        return this.nativeBytes.toDebugString();
    }

    @Override
    @NotNull
    public String toDebugString(long limit) {
        this.checkNotClosed();
        return this.nativeBytes.toDebugString(limit);
    }

    @Override
    public void toString(Appendable sb, long start, long position, long end) {
        this.checkNotClosed();
        this.nativeBytes.toString(sb, start, position, end);
    }

    @Override
    public void asString(Appendable appendable) {
        this.checkNotClosed();
        this.nativeBytes.asString(appendable);
    }

    @Override
    public CharSequence asString() {
        this.checkNotClosed();
        return this.nativeBytes.asString();
    }

    @Override
    public boolean compareAndSwapDouble(long offset, double expected, double value) {
        this.checkNotClosed();
        return this.nativeBytes.compareAndSwapDouble(offset, expected, value);
    }

    @Override
    public File file() {
        this.checkNotClosed();
        return this.nativeBytes.file();
    }

    @Override
    public boolean tryRWReadLock(long offset, long timeOutNS) throws IllegalStateException, InterruptedException {
        return this.nativeBytes.tryRWReadLock(offset, timeOutNS);
    }

    @Override
    public boolean tryRWWriteLock(long offset, long timeOutNS) throws IllegalStateException, InterruptedException {
        return this.nativeBytes.tryRWWriteLock(offset, timeOutNS);
    }

    @Override
    public void unlockRWReadLock(long offset) {
        this.checkNotClosed();
        this.nativeBytes.unlockRWReadLock(offset);
    }

    @Override
    public void unlockRWWriteLock(long offset) {
        this.checkNotClosed();
        this.nativeBytes.unlockRWWriteLock(offset);
    }

    String dumpRWLock(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.dumpRWLock(offset);
    }

    @Override
    public NativeBytes slice() {
        this.checkNotClosed();
        return this.nativeBytes.slice();
    }

    @Override
    public NativeBytes slice(long offset, long length) {
        this.checkNotClosed();
        return this.nativeBytes.slice(offset, length);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.checkNotClosed();
        return this.nativeBytes.subSequence(start, end);
    }

    @Override
    public NativeBytes bytes() {
        this.checkNotClosed();
        return this.nativeBytes.bytes();
    }

    @Override
    public NativeBytes bytes(long offset, long length) {
        this.checkNotClosed();
        return this.nativeBytes.bytes(offset, length);
    }

    @Override
    public long address() {
        this.checkNotClosed();
        return this.nativeBytes.address();
    }

    @Override
    public Bytes zeroOut() {
        this.checkNotClosed();
        return this.nativeBytes.zeroOut();
    }

    @Override
    public Bytes zeroOut(long start, long end) {
        this.checkNotClosed();
        return this.nativeBytes.zeroOut(start, end);
    }

    @Override
    public Bytes zeroOut(long start, long end, boolean ifNotZero) {
        this.checkNotClosed();
        return this.nativeBytes.zeroOut(start, end, ifNotZero);
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        this.checkNotClosed();
        return this.nativeBytes.read(bytes, off, len);
    }

    @Override
    public byte readByte() {
        this.checkNotClosed();
        return this.nativeBytes.readByte();
    }

    @Override
    public byte readByte(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readByte(offset);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        this.checkNotClosed();
        this.nativeBytes.readFully(b, off, len);
    }

    @Override
    public void readFully(long offset, byte[] bytes, int off, int len) {
        this.checkNotClosed();
        this.nativeBytes.readFully(offset, bytes, off, len);
    }

    @Override
    public void readFully(@NotNull char[] data, int off, int len) {
        this.checkNotClosed();
        this.nativeBytes.readFully(data, off, len);
    }

    @Override
    public short readShort() {
        this.checkNotClosed();
        return this.nativeBytes.readShort();
    }

    @Override
    public short readShort(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readShort(offset);
    }

    @Override
    public char readChar() {
        this.checkNotClosed();
        return this.nativeBytes.readChar();
    }

    @Override
    public char readChar(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readChar(offset);
    }

    @Override
    public int readInt() {
        this.checkNotClosed();
        return this.nativeBytes.readInt();
    }

    @Override
    public int readInt(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readInt(offset);
    }

    @Override
    public int readVolatileInt() {
        this.checkNotClosed();
        return this.nativeBytes.readVolatileInt();
    }

    @Override
    public int readVolatileInt(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readVolatileInt(offset);
    }

    @Override
    public long readLong() {
        this.checkNotClosed();
        return this.nativeBytes.readLong();
    }

    @Override
    public long readLong(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readLong(offset);
    }

    @Override
    public long readVolatileLong() {
        this.checkNotClosed();
        return this.nativeBytes.readVolatileLong();
    }

    @Override
    public long readVolatileLong(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readVolatileLong(offset);
    }

    @Override
    public float readFloat() {
        this.checkNotClosed();
        return this.nativeBytes.readFloat();
    }

    @Override
    public float readFloat(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readFloat(offset);
    }

    @Override
    public double readDouble() {
        this.checkNotClosed();
        return this.nativeBytes.readDouble();
    }

    @Override
    public double readDouble(long offset) {
        this.checkNotClosed();
        return this.nativeBytes.readDouble(offset);
    }

    @Override
    public void write(int b) {
        this.checkNotClosed();
        this.nativeBytes.write(b);
    }

    @Override
    public void writeByte(long offset, int b) {
        this.checkNotClosed();
        this.nativeBytes.writeByte(offset, b);
    }

    @Override
    public void write(long offset, @NotNull byte[] bytes) {
        this.checkNotClosed();
        this.nativeBytes.write(offset, bytes);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.checkNotClosed();
        this.nativeBytes.write(bytes, off, len);
    }

    @Override
    public void write(long offset, byte[] bytes, int off, int len) {
        this.checkNotClosed();
        this.nativeBytes.write(offset, bytes, off, len);
    }

    @Override
    public void writeShort(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeShort(v);
    }

    @Override
    public void writeShort(long offset, int v) {
        this.checkNotClosed();
        this.nativeBytes.writeShort(offset, v);
    }

    @Override
    public void writeChar(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeChar(v);
    }

    void addPosition(long delta) {
        this.checkNotClosed();
        this.nativeBytes.addPosition(delta);
    }

    @Override
    public void writeChar(long offset, int v) {
        this.checkNotClosed();
        this.nativeBytes.writeChar(offset, v);
    }

    @Override
    public void writeInt(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeInt(v);
    }

    @Override
    public void writeInt(long offset, int v) {
        this.checkNotClosed();
        this.nativeBytes.writeInt(offset, v);
    }

    @Override
    public void writeOrderedInt(int v) {
        this.checkNotClosed();
        this.nativeBytes.writeOrderedInt(v);
    }

    @Override
    public void writeOrderedInt(long offset, int v) {
        this.checkNotClosed();
        this.nativeBytes.writeOrderedInt(offset, v);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int x) {
        this.checkNotClosed();
        return this.nativeBytes.compareAndSwapInt(offset, expected, x);
    }

    @Override
    public void writeLong(long v) {
        this.checkNotClosed();
        this.nativeBytes.writeLong(v);
    }

    @Override
    public void writeLong(long offset, long v) {
        this.checkNotClosed();
        this.nativeBytes.writeLong(offset, v);
    }

    @Override
    public void writeOrderedLong(long v) {
        this.checkNotClosed();
        this.nativeBytes.writeOrderedLong(v);
    }

    @Override
    public void writeOrderedLong(long offset, long v) {
        this.checkNotClosed();
        this.nativeBytes.writeOrderedLong(offset, v);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long x) {
        this.checkNotClosed();
        return this.nativeBytes.compareAndSwapLong(offset, expected, x);
    }

    @Override
    public void writeFloat(float v) {
        this.checkNotClosed();
        this.nativeBytes.writeFloat(v);
    }

    @Override
    public void writeFloat(long offset, float v) {
        this.checkNotClosed();
        this.nativeBytes.writeFloat(offset, v);
    }

    @Override
    public void writeDouble(double v) {
        this.checkNotClosed();
        this.nativeBytes.writeDouble(v);
    }

    @Override
    public void writeDouble(long offset, double v) {
        this.checkNotClosed();
        this.nativeBytes.writeDouble(offset, v);
    }

    @Override
    public void readObject(Object object, int start, int end) {
        this.checkNotClosed();
        this.nativeBytes.readObject(object, start, end);
    }

    @Override
    public void writeObject(Object object, int start, int end) {
        this.checkNotClosed();
        this.nativeBytes.writeObject(object, start, end);
    }

    @Override
    public boolean compare(long offset, RandomDataInput input, long inputOffset, long len) {
        this.checkNotClosed();
        return this.nativeBytes.compare(offset, input, inputOffset, len);
    }

    @Override
    public long position() {
        this.checkNotClosed();
        return this.nativeBytes.position();
    }

    @Override
    public NativeBytes position(long position) {
        this.checkNotClosed();
        return this.nativeBytes.position(position);
    }

    @Override
    public NativeBytes lazyPosition(long position) {
        this.checkNotClosed();
        return this.nativeBytes.lazyPosition(position);
    }

    @Override
    public void write(RandomDataInput bytes, long position, long length) {
        this.checkNotClosed();
        this.nativeBytes.write(bytes, position, length);
    }

    @Override
    public long capacity() {
        this.checkNotClosed();
        return this.nativeBytes.capacity();
    }

    @Override
    public long remaining() {
        this.checkNotClosed();
        return this.nativeBytes.remaining();
    }

    @Override
    public long limit() {
        this.checkNotClosed();
        return this.nativeBytes.limit();
    }

    @Override
    public NativeBytes limit(long limit) {
        this.checkNotClosed();
        return this.nativeBytes.limit(limit);
    }

    @Override
    @NotNull
    public ByteOrder byteOrder() {
        this.checkNotClosed();
        return this.nativeBytes.byteOrder();
    }

    @Override
    public void checkEndOfBuffer() throws IndexOutOfBoundsException {
        this.nativeBytes.checkEndOfBuffer();
    }

    @Override
    public long startAddr() {
        this.checkNotClosed();
        return this.nativeBytes.startAddr();
    }

    long capacityAddr() {
        this.checkNotClosed();
        return this.nativeBytes.capacityAddr();
    }

    protected void cleanup() {
        this.checkNotClosed();
        this.nativeBytes.cleanup();
    }

    @Override
    public Bytes load() {
        this.checkNotClosed();
        return this.nativeBytes.load();
    }

    @Override
    public void alignPositionAddr(int powerOf2) {
        this.checkNotClosed();
        this.nativeBytes.alignPositionAddr(powerOf2);
    }

    @Override
    public void positionAddr(long positionAddr) {
        this.checkNotClosed();
        this.nativeBytes.positionAddr(positionAddr);
    }

    void positionChecks(long positionAddr) {
        this.checkNotClosed();
        this.nativeBytes.positionChecks(positionAddr);
    }

    boolean actualPositionChecks(long positionAddr) {
        this.checkNotClosed();
        return this.nativeBytes.actualPositionChecks(positionAddr);
    }

    void offsetChecks(long offset, long len) {
        this.checkNotClosed();
        this.nativeBytes.offsetChecks(offset, len);
    }

    boolean actualOffsetChecks(long offset, long len) {
        this.checkNotClosed();
        return this.nativeBytes.actualOffsetChecks(offset, len);
    }

    @Override
    public long positionAddr() {
        this.checkNotClosed();
        return this.nativeBytes.positionAddr();
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse) {
        this.checkNotClosed();
        return this.nativeBytes.sliceAsByteBuffer(toReuse);
    }

    protected ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse, Object att) {
        this.checkNotClosed();
        return this.nativeBytes.sliceAsByteBuffer(toReuse, att);
    }
}

