/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.CheckedBytes;
import net.openhft.lang.io.CheckedNativeBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.ObjectSerializer;

public class CheckedBytesStore
implements BytesStore {
    private final BytesStore bytesStore;
    private AtomicBoolean isClosed = new AtomicBoolean();
    Bytes proxy;

    public CheckedBytesStore(BytesStore bytesStore) {
        this.bytesStore = bytesStore;
        this.proxy = bytesStore.bytes() instanceof NativeBytes ? new CheckedNativeBytes((NativeBytes)bytesStore.bytes()) : new CheckedBytes(bytesStore.bytes());
    }

    @Override
    public Bytes bytes() {
        return this.proxy;
    }

    @Override
    public Bytes bytes(long offset, long length) {
        if (this.bytesStore.bytes() instanceof NativeBytes) {
            return new CheckedNativeBytes((NativeBytes)this.bytesStore.bytes(offset, length));
        }
        return new CheckedBytes(this.bytesStore.bytes(offset, length));
    }

    @Override
    public long address() {
        if (this.isClosed.get()) {
            new IllegalStateException(Thread.currentThread().getName() + " called after the byteStore has been freed.").printStackTrace();
            System.exit(-1);
        }
        return this.bytesStore.address();
    }

    @Override
    public long size() {
        if (this.isClosed.get()) {
            new IllegalStateException(Thread.currentThread().getName() + " called after the byteStore has been freed.").printStackTrace();
            System.exit(-1);
        }
        return this.bytesStore.size();
    }

    @Override
    public void free() {
        this.isClosed.set(true);
        this.bytesStore.free();
    }

    @Override
    public ObjectSerializer objectSerializer() {
        return this.bytesStore.objectSerializer();
    }

    @Override
    public File file() {
        return this.bytesStore.file();
    }
}

