/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.collection;

import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;

public class SingleThreadedDirectBitSet
implements DirectBitSet {
    private final Bytes bytes;
    private final long longLength;

    public SingleThreadedDirectBitSet(Bytes bytes) {
        this.bytes = bytes;
        this.longLength = bytes.capacity() >> 3;
    }

    @Override
    public void reserve() {
        this.bytes.reserve();
    }

    @Override
    public void release() {
        this.bytes.release();
    }

    @Override
    public int refCount() {
        return this.bytes.refCount();
    }

    @Override
    public DirectBitSet flip(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        long l2 = l ^ mask;
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public DirectBitSet flip(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                l = this.bytes.readLong(fromByteIndex);
                l2 = l ^ mask;
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                long toByteIndex = toLongIndex << 3;
                mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
                l = this.bytes.readLong(toByteIndex);
                l2 = l ^ mask;
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = fromLongIndex << 3;
            long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            long l = this.bytes.readLong(byteIndex);
            long l2 = l ^ mask;
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    @Override
    public DirectBitSet set(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        if ((l & mask) != 0L) {
            return this;
        }
        long l2 = l | mask;
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public boolean setIfClear(long bitIndex) {
        long l2;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        if (l == (l2 = l | mask)) {
            return false;
        }
        this.bytes.writeLong(byteIndex, l2);
        return true;
    }

    @Override
    public DirectBitSet set(long bitIndex, boolean value) {
        return value ? this.set(bitIndex) : this.clear(bitIndex);
    }

    @Override
    public DirectBitSet set(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                l = this.bytes.readLong(fromByteIndex);
                l2 = l | mask;
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, -1L);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, -1L);
                }
                long toByteIndex = toLongIndex << 3;
                mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
                l = this.bytes.readLong(toByteIndex);
                l2 = l | mask;
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = fromLongIndex << 3;
            long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            long l = this.bytes.readLong(byteIndex);
            long l2 = l | mask;
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    @Override
    public DirectBitSet setAll() {
        for (long i = 0L; i < this.longLength; ++i) {
            this.bytes.writeLong(i << 3, -1L);
        }
        return this;
    }

    @Override
    public DirectBitSet set(long fromIndex, long toIndex, boolean value) {
        return value ? this.set(fromIndex, toIndex) : this.clear(fromIndex, toIndex);
    }

    @Override
    public DirectBitSet clear(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        if ((l & mask) == 0L) {
            return this;
        }
        long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public boolean clearIfSet(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        if ((l & mask) == 0L) {
            return false;
        }
        long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.bytes.writeLong(byteIndex, l2);
        return true;
    }

    @Override
    public DirectBitSet clear(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                l = this.bytes.readLong(fromByteIndex);
                l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, 0L);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, 0L);
                }
                long toByteIndex = toLongIndex << 3;
                mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
                l = this.bytes.readLong(toByteIndex);
                l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = fromLongIndex << 3;
            long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            long l = this.bytes.readLong(byteIndex);
            long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    public boolean allSet(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                mask = -1L << (int)fromIndex;
                if (((this.bytes.readLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) & mask) != 0L) {
                    return false;
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    if ((this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
                    return false;
                }
                return true;
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                if ((this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
                return false;
            }
            mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            return ((this.bytes.readLong(toLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) & mask) == 0L;
        }
        long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
        return ((this.bytes.readLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) & mask) == 0L;
    }

    public boolean allClear(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                mask = -1L << (int)fromIndex;
                if ((this.bytes.readLong(fromLongIndex << 3) & mask) != 0L) {
                    return false;
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    if (this.bytes.readLong(i << 3) == 0L) continue;
                    return false;
                }
                return true;
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                if (this.bytes.readLong(i << 3) == 0L) continue;
                return false;
            }
            mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            return (this.bytes.readLong(toLongIndex << 3) & mask) == 0L;
        }
        long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
        return (this.bytes.readLong(fromLongIndex << 3) & mask) == 0L;
    }

    @Override
    public DirectBitSet clear() {
        this.bytes.zeroOut();
        return this;
    }

    @Override
    public boolean get(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long l = this.bytes.readLong(longIndex << 3);
        return (l & 1L << (int)bitIndex) != 0L;
    }

    @Override
    public boolean isSet(long bitIndex) {
        return this.get(bitIndex);
    }

    @Override
    public boolean isClear(long bitIndex) {
        return !this.get(bitIndex);
    }

    @Override
    public long getLong(long longIndex) {
        if (longIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes.readLong(longIndex << 3);
    }

    @Override
    public long nextSetBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = this.bytes.readLong(fromLongIndex << 3) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.bytes.readLong(i << 3);
            if (l == 0L) continue;
            return (i << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long clearNextSetBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = fromLongIndex << 3;
        long w = this.bytes.readLong(fromByteIndex);
        long l = w >>> (int)fromIndex;
        if (l != 0L) {
            long indexOfSetBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = 1L << (int)indexOfSetBit;
            this.bytes.writeLong(fromByteIndex, w ^ mask);
            return indexOfSetBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long byteIndex = i << 3;
            l = this.bytes.readLong(byteIndex);
            if (l == 0L) continue;
            long indexOfSetBit = (i << 6) + (long)Long.numberOfTrailingZeros(l);
            long mask = 1L << (int)indexOfSetBit;
            this.bytes.writeLong(byteIndex, l ^ mask);
            return indexOfSetBit;
        }
        return -1L;
    }

    @Override
    public long nextSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.bytes.readLong(fromLongIndex << 3) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.bytes.readLong(i << 3) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long nextClearBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = (this.bytes.readLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return (i << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long setNextClearBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = fromLongIndex << 3;
        long w = this.bytes.readLong(fromByteIndex);
        long l = (w ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            long indexOfClearBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = 1L << (int)indexOfClearBit;
            this.bytes.writeLong(fromByteIndex, w ^ mask);
            return indexOfClearBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long byteIndex = i << 3;
            w = this.bytes.readLong(byteIndex);
            l = w ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            long indexOfClearBit = (i << 6) + (long)Long.numberOfTrailingZeros(l);
            long mask = 1L << (int)indexOfClearBit;
            this.bytes.writeLong(byteIndex, w ^ mask);
            return indexOfClearBit;
        }
        return -1L;
    }

    @Override
    public long nextClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.bytes.readLong(fromLongIndex << 3) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.bytes.readLong(i << 3) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousSetBit(long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = this.bytes.readLong(fromLongIndex << 3) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.bytes.readLong(i << 3);
            if (l == 0L) continue;
            return (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long clearPreviousSetBit(long fromIndex) {
        long fromByteIndex;
        long w;
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = (w = this.bytes.readLong(fromByteIndex = fromLongIndex << 3)) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfSetBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = 1L << (int)indexOfSetBit;
            this.bytes.writeLong(fromByteIndex, w ^ mask);
            return indexOfSetBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long byteIndex = i << 3;
            l = this.bytes.readLong(byteIndex);
            if (l == 0L) continue;
            long indexOfSetBit = (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
            long mask = 1L << (int)indexOfSetBit;
            this.bytes.writeLong(byteIndex, l ^ mask);
            return indexOfSetBit;
        }
        return -1L;
    }

    @Override
    public long previousSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            if (fromLongIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.bytes.readLong(fromLongIndex << 3) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.bytes.readLong(i << 3) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousClearBit(long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = (this.bytes.readLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long setPreviousClearBit(long fromIndex) {
        long fromByteIndex;
        long w;
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = ((w = this.bytes.readLong(fromByteIndex = fromLongIndex << 3)) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfClearBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = 1L << (int)indexOfClearBit;
            this.bytes.writeLong(fromByteIndex, w ^ mask);
            return indexOfClearBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long byteIndex = i << 3;
            w = this.bytes.readLong(byteIndex);
            l = w ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            long indexOfClearBit = (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
            long mask = 1L << (int)indexOfClearBit;
            this.bytes.writeLong(byteIndex, w ^ mask);
            return indexOfClearBit;
        }
        return -1L;
    }

    @Override
    public long previousClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            if (fromLongIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.bytes.readLong(fromLongIndex << 3) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.bytes.readLong(i << 3) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long size() {
        return this.longLength << 6;
    }

    @Override
    public long cardinality() {
        long count = 0L;
        for (long i = 0L; i < this.longLength; ++i) {
            count += (long)Long.bitCount(this.bytes.readLong(i << 3));
        }
        return count;
    }

    @Override
    public DirectBitSet and(long longIndex, long value) {
        long l = this.bytes.readLong(longIndex << 3);
        long l2 = l & value;
        this.bytes.writeLong(longIndex << 3, l2);
        return this;
    }

    @Override
    public DirectBitSet or(long longIndex, long value) {
        long l = this.bytes.readLong(longIndex << 3);
        long l2 = l | value;
        this.bytes.writeLong(longIndex << 3, l2);
        return this;
    }

    @Override
    public DirectBitSet xor(long longIndex, long value) {
        long l = this.bytes.readLong(longIndex << 3);
        long l2 = l ^ value;
        this.bytes.writeLong(longIndex << 3, l2);
        return this;
    }

    @Override
    public DirectBitSet andNot(long longIndex, long value) {
        long l = this.bytes.readLong(longIndex << 3);
        long l2 = l & (value ^ 0xFFFFFFFFFFFFFFFFL);
        this.bytes.writeLong(longIndex << 3, l2);
        return this;
    }

    @Override
    public long setNextNContinuousClearBits(long fromIndex, int numberOfBits) {
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numberOfBits == 1) {
            return this.setNextClearBit(fromIndex);
        }
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long nTrailingOnes = -1L >>> 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex2 = bitIndex >> 6;
        if (longIndex2 >= this.longLength) {
            return -1L;
        }
        int bitsFromFirstWord = 64 - ((int)bitIndex & 0x3F);
        long byteIndex2 = longIndex2 << 3;
        long w2 = this.bytes.readLong(byteIndex2);
        block0: while (true) {
            long w1 = w2;
            byteIndex2 += 8L;
            if (++longIndex2 < this.longLength) {
                w2 = this.bytes.readLong(byteIndex2);
            } else if (longIndex2 == this.longLength) {
                w2 = -1L;
            } else {
                return -1L;
            }
            long l = bitsFromFirstWord != 64 ? w1 >>> (int)bitIndex | w2 << bitsFromFirstWord : w1;
            if ((l & 1L) != 0L) {
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x != 0L) {
                    int trailingOnes = Long.numberOfTrailingZeros(x);
                    bitIndex += (long)trailingOnes;
                    if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                        bitsFromFirstWord += 64;
                        continue;
                    }
                    l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                } else {
                    bitIndex += 64L;
                    continue;
                }
            }
            while (true) {
                if ((l & nTrailingOnes) == 0L) {
                    long mask1 = nTrailingOnes << (int)bitIndex;
                    this.bytes.writeLong(byteIndex2 - 8L, w1 ^ mask1);
                    int bitsFromSecondWordToSwitch = numberOfBits - bitsFromFirstWord;
                    if (bitsFromSecondWordToSwitch > 0) {
                        long mask2 = (1L << bitsFromSecondWordToSwitch) - 1L;
                        this.bytes.writeLong(byteIndex2, w2 ^ mask2);
                    }
                    return bitIndex;
                }
                int trailingZeros = Long.numberOfTrailingZeros(l);
                bitIndex += (long)trailingZeros;
                if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x == 0L) break;
                int trailingOnes = Long.numberOfTrailingZeros(x);
                bitIndex += (long)trailingOnes;
                if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
            }
            bitIndex += 64L;
        }
    }

    @Override
    public long clearNextNContinuousSetBits(long fromIndex, int numberOfBits) {
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numberOfBits == 1) {
            return this.clearNextSetBit(fromIndex);
        }
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long nTrailingOnes = -1L >>> 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex2 = bitIndex >> 6;
        if (longIndex2 >= this.longLength) {
            return -1L;
        }
        int bitsFromFirstWord = 64 - ((int)bitIndex & 0x3F);
        long byteIndex2 = longIndex2 << 3;
        long w2 = this.bytes.readLong(byteIndex2);
        block0: while (true) {
            long w1 = w2;
            byteIndex2 += 8L;
            if (++longIndex2 < this.longLength) {
                w2 = this.bytes.readLong(byteIndex2);
            } else if (longIndex2 == this.longLength) {
                w2 = 0L;
            } else {
                return -1L;
            }
            long l = bitsFromFirstWord != 64 ? w1 >>> (int)bitIndex | w2 << bitsFromFirstWord : w1;
            if ((l & 1L) == 0L) {
                if (l != 0L) {
                    int trailingZeros = Long.numberOfTrailingZeros(l);
                    bitIndex += (long)trailingZeros;
                    if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                        bitsFromFirstWord += 64;
                        continue;
                    }
                    l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                } else {
                    bitIndex += 64L;
                    continue;
                }
            }
            while (true) {
                if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nTrailingOnes) == 0L) {
                    long mask1 = nTrailingOnes << (int)bitIndex;
                    this.bytes.writeLong(byteIndex2 - 8L, w1 ^ mask1);
                    int bitsFromSecondWordToSwitch = numberOfBits - bitsFromFirstWord;
                    if (bitsFromSecondWordToSwitch > 0) {
                        long mask2 = (1L << bitsFromSecondWordToSwitch) - 1L;
                        this.bytes.writeLong(byteIndex2, w2 ^ mask2);
                    }
                    return bitIndex;
                }
                int trailingOnes = Long.numberOfTrailingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                bitIndex += (long)trailingOnes;
                if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                if (l == 0L) break;
                int trailingZeros = Long.numberOfTrailingZeros(l);
                bitIndex += (long)trailingZeros;
                if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
            }
            bitIndex += 64L;
        }
    }

    @Override
    public long setPreviousNContinuousClearBits(long fromIndex, int numberOfBits) {
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numberOfBits == 1) {
            return this.setPreviousClearBit(fromIndex);
        }
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        int n64Complement = 64 - numberOfBits;
        long nLeadingOnes = -1L << n64Complement;
        long higherBitBound = fromIndex + 1L;
        long lowLongIndex = fromIndex >> 6;
        if (lowLongIndex >= this.longLength) {
            lowLongIndex = this.longLength - 1L;
            higherBitBound = this.longLength << 6;
        }
        int bitsFromLowWord = 64 - ((int)higherBitBound & 0x3F) & 0x3F;
        long lowByteIndex = lowLongIndex << 3;
        long lw = this.bytes.readLong(lowByteIndex);
        block0: while (true) {
            long hw = lw;
            lowByteIndex -= 8L;
            if (--lowLongIndex >= 0L) {
                lw = this.bytes.readLong(lowByteIndex);
            } else if (lowLongIndex == -1L) {
                lw = -1L;
            } else {
                return -1L;
            }
            long l = bitsFromLowWord != 0 ? lw >>> (int)higherBitBound | hw << bitsFromLowWord : hw;
            if (l < 0L) {
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x != 0L) {
                    int leadingOnes = Long.numberOfLeadingZeros(x);
                    higherBitBound -= (long)leadingOnes;
                    int flw = (bitsFromLowWord += leadingOnes) - 64;
                    if (flw >= 0) {
                        bitsFromLowWord = flw;
                        continue;
                    }
                    l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                } else {
                    higherBitBound -= 64L;
                    continue;
                }
            }
            while (true) {
                if ((l & nLeadingOnes) == 0L) {
                    long hMask = nLeadingOnes >>> bitsFromLowWord;
                    this.bytes.writeLong(lowByteIndex + 8L, hw ^ hMask);
                    int bitsFromLowWordToSwitch = bitsFromLowWord - n64Complement;
                    if (bitsFromLowWordToSwitch > 0) {
                        long lMask = -1L >>> bitsFromLowWordToSwitch ^ 0xFFFFFFFFFFFFFFFFL;
                        this.bytes.writeLong(lowByteIndex, lw ^ lMask);
                    }
                    return higherBitBound - (long)numberOfBits;
                }
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                int flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x == 0L) break;
                int leadingOnes = Long.numberOfLeadingZeros(x);
                higherBitBound -= (long)leadingOnes;
                flw = (bitsFromLowWord += leadingOnes) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            }
            higherBitBound -= 64L;
        }
    }

    @Override
    public long clearPreviousNContinuousSetBits(long fromIndex, int numberOfBits) {
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numberOfBits == 1) {
            return this.clearPreviousSetBit(fromIndex);
        }
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        int n64Complement = 64 - numberOfBits;
        long nLeadingOnes = -1L << n64Complement;
        long higherBitBound = fromIndex + 1L;
        long lowLongIndex = fromIndex >> 6;
        if (lowLongIndex >= this.longLength) {
            lowLongIndex = this.longLength - 1L;
            higherBitBound = this.longLength << 6;
        }
        int bitsFromLowWord = 64 - ((int)higherBitBound & 0x3F) & 0x3F;
        long lowByteIndex = lowLongIndex << 3;
        long lw = this.bytes.readLong(lowByteIndex);
        block0: while (true) {
            int flw;
            long hw = lw;
            lowByteIndex -= 8L;
            if (--lowLongIndex >= 0L) {
                lw = this.bytes.readLong(lowByteIndex);
            } else if (lowLongIndex == -1L) {
                lw = 0L;
            } else {
                return -1L;
            }
            long l = bitsFromLowWord != 0 ? lw >>> (int)higherBitBound | hw << bitsFromLowWord : hw;
            if (l > 0L) {
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            } else if (l == 0L) {
                higherBitBound -= 64L;
                continue;
            }
            while (true) {
                if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nLeadingOnes) == 0L) {
                    long hMask = nLeadingOnes >>> bitsFromLowWord;
                    this.bytes.writeLong(lowByteIndex + 8L, hw ^ hMask);
                    int bitsFromLowWordToSwitch = bitsFromLowWord - n64Complement;
                    if (bitsFromLowWordToSwitch > 0) {
                        long lMask = -1L >>> bitsFromLowWordToSwitch ^ 0xFFFFFFFFFFFFFFFFL;
                        this.bytes.writeLong(lowByteIndex, lw ^ lMask);
                    }
                    return higherBitBound - (long)numberOfBits;
                }
                int leadingOnes = Long.numberOfLeadingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                higherBitBound -= (long)leadingOnes;
                flw = (bitsFromLowWord += leadingOnes) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                if (l == 0L) break;
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            }
            higherBitBound -= 64L;
        }
    }
}

