/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.io.serialization.impl.CollectionMarshaller;

public class SetMarshaller<E>
extends CollectionMarshaller<E, Set<E>>
implements CompactBytesMarshaller<Set<E>> {
    SetMarshaller(BytesMarshaller<E> eBytesMarshaller) {
        super(eBytesMarshaller);
    }

    public static <E> BytesMarshaller<Set<E>> of(BytesMarshaller<E> eBytesMarshaller) {
        return new SetMarshaller<E>(eBytesMarshaller);
    }

    @Override
    public byte code() {
        return 27;
    }

    @Override
    Set<E> newCollection() {
        return new LinkedHashSet();
    }

    @Override
    Set<E> readCollection(Bytes bytes, Set<E> es, int length) {
        Collection ret = this.newCollection();
        Iterator<Object> iterator = es == null ? Collections.emptyIterator() : es.iterator();
        for (int i = 0; i < length; ++i) {
            if (iterator.hasNext()) {
                ret.add(this.eBytesMarshaller.read(bytes, iterator.next()));
                continue;
            }
            ret.add(this.eBytesMarshaller.read(bytes));
        }
        return ret;
    }
}

