/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;

public class MapMarshaller<K, V>
implements CompactBytesMarshaller<Map<K, V>> {
    private final BytesMarshaller<K> kBytesMarshaller;
    private final BytesMarshaller<V> vBytesMarshaller;

    public MapMarshaller(BytesMarshaller<K> kBytesMarshaller, BytesMarshaller<V> vBytesMarshaller) {
        this.kBytesMarshaller = kBytesMarshaller;
        this.vBytesMarshaller = vBytesMarshaller;
    }

    @Override
    public byte code() {
        return 13;
    }

    @Override
    public void write(Bytes bytes, Map<K, V> kvMap) {
        bytes.writeInt(kvMap.size());
        for (Map.Entry<K, V> entry : kvMap.entrySet()) {
            this.kBytesMarshaller.write(bytes, entry.getKey());
            this.vBytesMarshaller.write(bytes, entry.getValue());
        }
    }

    @Override
    public Map<K, V> read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public Map<K, V> read(Bytes bytes, @Nullable Map<K, V> kvMap) {
        if (kvMap == null) {
            kvMap = new LinkedHashMap();
        }
        int size = bytes.readInt();
        for (int i = 0; i < size; ++i) {
            kvMap.put(this.kBytesMarshaller.read(bytes), this.vBytesMarshaller.read(bytes));
        }
        return kvMap;
    }
}

