/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.collection;

import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;

public class SingleThreadedDirectBitSet
implements DirectBitSet {
    private final Bytes bytes;
    private final long longLength;

    public SingleThreadedDirectBitSet(Bytes bytes) {
        this.bytes = bytes;
        this.longLength = bytes.capacity() >> 3;
    }

    @Override
    public void reserve() {
        this.bytes.reserve();
    }

    @Override
    public void release() {
        this.bytes.release();
    }

    @Override
    public int refCount() {
        return this.bytes.refCount();
    }

    @Override
    public DirectBitSet flip(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        long l2 = l ^ mask;
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public DirectBitSet flip(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                l = this.bytes.readLong(fromByteIndex);
                l2 = l ^ mask;
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                long toByteIndex = toLongIndex << 3;
                mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
                l = this.bytes.readLong(toByteIndex);
                l2 = l ^ mask;
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = fromLongIndex << 3;
            long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            long l = this.bytes.readLong(byteIndex);
            long l2 = l ^ mask;
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    @Override
    public DirectBitSet set(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        if ((l & mask) != 0L) {
            return this;
        }
        long l2 = l | mask;
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public boolean setIfClear(long bitIndex) {
        long l2;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        if (l == (l2 = l | mask)) {
            return false;
        }
        this.bytes.writeLong(byteIndex, l2);
        return true;
    }

    @Override
    public DirectBitSet set(long bitIndex, boolean value) {
        return value ? this.set(bitIndex) : this.clear(bitIndex);
    }

    @Override
    public DirectBitSet set(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                l = this.bytes.readLong(fromByteIndex);
                l2 = l | mask;
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, -1L);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, -1L);
                }
                long toByteIndex = toLongIndex << 3;
                mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
                l = this.bytes.readLong(toByteIndex);
                l2 = l | mask;
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = fromLongIndex << 3;
            long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            long l = this.bytes.readLong(byteIndex);
            long l2 = l | mask;
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    @Override
    public DirectBitSet setAll() {
        for (long i = 0L; i < this.longLength; ++i) {
            this.bytes.writeLong(i << 3, -1L);
        }
        return this;
    }

    @Override
    public DirectBitSet set(long fromIndex, long toIndex, boolean value) {
        return value ? this.set(fromIndex, toIndex) : this.clear(fromIndex, toIndex);
    }

    @Override
    public DirectBitSet clear(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        long l = this.bytes.readLong(byteIndex);
        if ((l & mask) == 0L) {
            return this;
        }
        long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public DirectBitSet clear(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex ^ 0xFFFFFFFFFFFFFFFFL;
                l = this.bytes.readLong(fromByteIndex);
                l2 = l & mask;
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, 0L);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.bytes.writeLong(i << 3, 0L);
                }
                long toByteIndex = toLongIndex << 3;
                mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL;
                l = this.bytes.readLong(toByteIndex);
                l2 = l & mask;
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = fromLongIndex << 3;
            long mask = -1L << (int)fromIndex ^ 0xFFFFFFFFFFFFFFFFL | -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            long l = this.bytes.readLong(byteIndex);
            long l2 = l & mask;
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    @Override
    public DirectBitSet clear() {
        this.bytes.zeroOut();
        return this;
    }

    @Override
    public boolean get(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long l = this.bytes.readLong(longIndex << 3);
        return (l & 1L << (int)bitIndex) != 0L;
    }

    @Override
    public long getLong(long longIndex) {
        if (longIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes.readLong(longIndex << 3);
    }

    @Override
    public long nextSetBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = this.bytes.readLong(fromLongIndex << 3) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.bytes.readLong(i << 3);
            if (l == 0L) continue;
            return (i << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long nextSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.bytes.readLong(fromLongIndex << 3) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.bytes.readLong(i << 3) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long nextClearBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = (this.bytes.readLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return (i << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long setNFrom(long fromIndex, int numberOfBits) {
        if (numberOfBits != 1) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        do {
            long fromLongIndex;
            if ((fromLongIndex = fromIndex >> 6) >= this.longLength) {
                return -1L;
            }
            if ((fromIndex = this.nextClearBit(fromIndex)) != -1L) continue;
            return -1L;
        } while (!this.setIfClear(fromIndex));
        return fromIndex;
    }

    @Override
    public long nextClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.bytes.readLong(fromLongIndex << 3) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.bytes.readLong(i << 3) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousSetBit(long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = this.bytes.readLong(fromLongIndex << 3) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.bytes.readLong(i << 3);
            if (l == 0L) continue;
            return (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long previousSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            if (fromLongIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.bytes.readLong(fromLongIndex << 3) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.bytes.readLong(i << 3) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousClearBit(long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = (this.bytes.readLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long previousClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            if (fromLongIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.bytes.readLong(fromLongIndex << 3) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.bytes.readLong(i << 3) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long size() {
        return this.longLength << 6;
    }

    @Override
    public long cardinality() {
        long count = 0L;
        for (long i = 0L; i < this.longLength; ++i) {
            count += (long)Long.bitCount(this.bytes.readLong(i << 3));
        }
        return count;
    }

    @Override
    public DirectBitSet and(long longIndex, long value) {
        long l = this.bytes.readLong(longIndex << 3);
        long l2 = l & value;
        this.bytes.writeLong(longIndex << 3, l2);
        return this;
    }

    @Override
    public DirectBitSet or(long longIndex, long value) {
        long l = this.bytes.readLong(longIndex << 3);
        long l2 = l | value;
        this.bytes.writeLong(longIndex << 3, l2);
        return this;
    }

    @Override
    public DirectBitSet xor(long longIndex, long value) {
        long l = this.bytes.readLong(longIndex << 3);
        long l2 = l ^ value;
        this.bytes.writeLong(longIndex << 3, l2);
        return this;
    }

    @Override
    public DirectBitSet andNot(long longIndex, long value) {
        long l = this.bytes.readLong(longIndex << 3);
        long l2 = l & (value ^ 0xFFFFFFFFFFFFFFFFL);
        this.bytes.writeLong(longIndex << 3, l2);
        return this;
    }
}

