/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Random;
import java.util.logging.Logger;

public enum Jvm {

    public static final String TMP = System.getProperty("java.io.tmpdir");
    private static final boolean IS64BIT = Jvm.is64Bit0();
    private static final int PROCESS_ID = Jvm.getProcessId0();

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid == null) {
            int rpid = new Random().nextInt(65536);
            Logger.getLogger(Jvm.class.getName()).warning("Unable to determine PID, picked a random number=" + rpid);
            return rpid;
        }
        return Integer.parseInt(pid);
    }

    public static long getUniqueTid() {
        return Jvm.getUniqueTid(Thread.currentThread());
    }

    public static long getUniqueTid(Thread thread) {
        return (long)Jvm.getProcessId() << 32 | thread.getId() & 0xFFFFFFFFL;
    }
}

