/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.model;

import java.io.Externalizable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.Copyable;
import net.openhft.lang.model.MethodFilter;
import net.openhft.lang.model.VanillaFilter;

public class DataValueMetaModel {
    private final Set<Class> ignoredClasses = new HashSet<Class>();
    private final List<MethodFilter> filters = new ArrayList<MethodFilter>();

    public DataValueMetaModel() {
        this.addIgnoredClass(Object.class);
        this.addIgnoredClass(Externalizable.class);
        this.addIgnoredClass(Copyable.class);
        this.addIgnoredClass(Byteable.class);
        this.addIgnoredClass(BytesMarshallable.class);
        for (VanillaFilter vanillaFilter : VanillaFilter.values()) {
            this.addMethodFilter(vanillaFilter);
        }
    }

    public void addIgnoredClass(Class aClass) {
        this.ignoredClasses.add(aClass);
    }

    public void addMethodFilter(MethodFilter filter) {
        int pos = this.insertionPoint(filter);
        this.filters.add(pos, filter);
    }

    private int insertionPoint(MethodFilter filter) {
        for (int i = 0; i < this.filters.size(); ++i) {
            if (this.filters.get(i).matches() >= filter.matches()) continue;
            return i;
        }
        return this.filters.size();
    }
}

