/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;
import sun.nio.ch.DirectBuffer;

public class ByteBufferBytes
extends AbstractBytes {
    protected final ByteBuffer buffer;
    protected int start;
    protected int position;
    protected int limit;
    protected AtomicBoolean barrier;

    public ByteBufferBytes(ByteBuffer buffer) {
        this(buffer, 0, buffer.capacity());
    }

    public ByteBufferBytes(ByteBuffer buffer, int start, int limit) {
        this.buffer = buffer;
        this.start = this.position = start;
        this.limit = limit;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    protected void readBarrier() {
        if (this.barrier == null) {
            this.barrier = new AtomicBoolean();
        }
        this.barrier.get();
    }

    protected void writeBarrier() {
        if (this.barrier == null) {
            this.barrier = new AtomicBoolean();
        }
        this.barrier.lazySet(false);
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        if (len < 0 || off < 0 || off + len > bytes.length) {
            throw new IllegalArgumentException();
        }
        long left = this.remaining();
        if (left <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min(left, (long)len);
        for (int i = 0; i < len2; ++i) {
            bytes[off + i] = this.readByte();
        }
        return len2;
    }

    @Override
    public byte readByte() {
        if (this.position < this.limit) {
            return this.buffer.get(this.position++);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public byte readByte(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos < this.limit) {
            return this.buffer.get(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        if (len < 0 || off < 0 || off + len > b.length) {
            throw new IllegalArgumentException();
        }
        long left = this.remaining();
        if (left < (long)len) {
            throw new IllegalStateException(new EOFException());
        }
        for (int i = 0; i < len; ++i) {
            b[off + i] = this.readByte();
        }
    }

    @Override
    public short readShort() {
        if (this.position + 2 <= this.limit) {
            short s = this.buffer.getShort(this.position);
            this.position += 2;
            return s;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readShort(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 2 <= this.limit) {
            return this.buffer.getShort(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public char readChar() {
        if (this.position + 2 <= this.limit) {
            char ch = this.buffer.getChar(this.position);
            this.position += 2;
            return ch;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public char readChar(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 2 <= this.limit) {
            return this.buffer.getChar(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readInt() {
        if (this.position + 4 <= this.limit) {
            int i = this.buffer.getInt(this.position);
            this.position += 4;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readInt(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 4 <= this.limit) {
            return this.buffer.getInt(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readVolatileInt() {
        this.readBarrier();
        return this.readInt();
    }

    @Override
    public int readVolatileInt(long offset) {
        this.readBarrier();
        return this.readInt(offset);
    }

    @Override
    public long readLong() {
        if (this.position + 8 <= this.limit) {
            long l = this.buffer.getLong(this.position);
            this.position += 8;
            return l;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readLong(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 8 <= this.limit) {
            return this.buffer.getLong(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readVolatileLong() {
        this.readBarrier();
        return this.readLong();
    }

    @Override
    public long readVolatileLong(long offset) {
        this.readBarrier();
        return this.readLong(offset);
    }

    @Override
    public float readFloat() {
        if (this.position + 4 <= this.limit) {
            float f = this.buffer.getFloat(this.position);
            this.position += 4;
            return f;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public float readFloat(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 4 <= this.limit) {
            return this.buffer.getFloat(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double readDouble() {
        if (this.position + 8 <= this.limit) {
            double d = this.buffer.getDouble(this.position);
            this.position += 8;
            return d;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double readDouble(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 8 <= this.limit) {
            return this.buffer.getDouble(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void write(int b) {
        if (this.position >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.put(this.position++, (byte)b);
    }

    @Override
    public void writeByte(long offset, int b) {
        int pos = (int)((long)this.start + offset);
        if (pos >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.put(pos, (byte)b);
    }

    @Override
    public void writeShort(int v) {
        if (this.position + 2 <= this.limit) {
            this.buffer.putShort(this.position, (short)v);
            this.position += 2;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeShort(long offset, int v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 2 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putShort(pos, (short)v);
    }

    @Override
    public void writeChar(int v) {
        if (this.position + 2 <= this.limit) {
            this.buffer.putChar(this.position, (char)v);
            this.position += 2;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeChar(long offset, int v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 2 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putChar(pos, (char)v);
    }

    @Override
    public void writeInt(int v) {
        if (this.position + 4 <= this.limit) {
            this.buffer.putInt(this.position, v);
            this.position += 4;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeInt(long offset, int v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 4 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putInt(pos, v);
    }

    @Override
    public void writeOrderedInt(int v) {
        this.writeInt(v);
        this.writeBarrier();
    }

    @Override
    public void writeOrderedInt(long offset, int v) {
        this.writeInt(offset, v);
        this.writeBarrier();
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int x) {
        if (this.buffer instanceof DirectBuffer) {
            return NativeBytes.UNSAFE.compareAndSwapInt(null, ((DirectBuffer)((Object)this.buffer)).address() + offset, expected, x);
        }
        return NativeBytes.UNSAFE.compareAndSwapInt(this.buffer.array(), (long)NativeBytes.BYTES_OFFSET + offset, expected, x);
    }

    @Override
    public void writeLong(long v) {
        if (this.position + 8 <= this.limit) {
            this.buffer.putLong(this.position, v);
            this.position += 8;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeLong(long offset, long v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 8 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putLong(pos, v);
    }

    @Override
    public void writeOrderedLong(long v) {
        this.writeLong(v);
        this.writeBarrier();
    }

    @Override
    public void writeOrderedLong(long offset, long v) {
        this.writeLong((int)offset, v);
        this.writeBarrier();
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long x) {
        if (this.buffer instanceof DirectBuffer) {
            return NativeBytes.UNSAFE.compareAndSwapLong(null, ((DirectBuffer)((Object)this.buffer)).address() + offset, expected, x);
        }
        return NativeBytes.UNSAFE.compareAndSwapLong(this.buffer.array(), (long)NativeBytes.BYTES_OFFSET + offset, expected, x);
    }

    @Override
    public void writeFloat(float v) {
        if (this.position + 4 <= this.limit) {
            this.buffer.putFloat(this.position, v);
            this.position += 4;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeFloat(long offset, float v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 4 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putFloat(pos, v);
    }

    @Override
    public void writeDouble(double v) {
        if (this.position + 8 <= this.limit) {
            this.buffer.putDouble(this.position, v);
            this.position += 8;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeDouble(long offset, double v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 8 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putDouble(pos, v);
    }

    @Override
    public void readObject(Object object, int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeObject(Object object, int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() {
        return this.position - this.start;
    }

    @Override
    public void position(long position) {
        if ((long)this.start + position > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Position to large");
        }
        this.position = (int)((long)this.start + position);
    }

    @Override
    public long capacity() {
        return this.limit - this.start;
    }

    @Override
    public long remaining() {
        return this.limit - this.position;
    }

    @Override
    @NotNull
    public ByteOrder byteOrder() {
        return this.buffer.order();
    }

    @Override
    public void checkEndOfBuffer() throws IndexOutOfBoundsException {
        if (this.position < this.start || this.position > this.limit) {
            throw new IndexOutOfBoundsException();
        }
    }
}

