/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;

public class RawCopier<T> {
    final int start;
    final int end;
    private final Class<T> tClass;

    public RawCopier(Class<T> tClass) {
        Field field;
        this.tClass = tClass;
        ArrayList<Field> fields = new ArrayList<Field>();
        this.addAllFields(fields, tClass);
        Collections.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                long off1 = NativeBytes.UNSAFE.objectFieldOffset(o1);
                long off2 = NativeBytes.UNSAFE.objectFieldOffset(o2);
                return Double.compare(off1, off2);
            }
        });
        this.start = (int)NativeBytes.UNSAFE.objectFieldOffset((Field)fields.get(0));
        Field lastField = null;
        Iterator i$ = fields.iterator();
        while (i$.hasNext() && !Modifier.isTransient((field = (Field)i$.next()).getModifiers()) && field.getType().isPrimitive()) {
            lastField = field;
        }
        this.end = (int)NativeBytes.UNSAFE.objectFieldOffset(lastField) + RawCopier.sizeOf(lastField.getType());
        assert (this.end > this.start) : "end <= start, start: " + this.start + ", end: " + this.end;
    }

    public static <T> RawCopier<T> copies(Class<T> tClass) {
        return new RawCopier<T>(tClass);
    }

    private static int sizeOf(Class<?> type) {
        return NativeBytes.UNSAFE.arrayIndexScale(Array.newInstance(type, 0).getClass());
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public void toBytes(Object obj, Bytes bytes) {
        bytes.writeObject(obj, this.start, this.end);
    }

    public void fromBytes(Bytes bytes, Object obj) {
        bytes.readObject(obj, this.start, this.end);
    }

    public void copy(T from, T to) {
        long i;
        for (i = (long)this.start; i < (long)(this.end - 7); i += 8L) {
            NativeBytes.UNSAFE.putLong(to, i, NativeBytes.UNSAFE.getLong(from, i));
        }
        while (i < (long)this.end) {
            NativeBytes.UNSAFE.putByte(to, i, NativeBytes.UNSAFE.getByte(from, i));
            ++i;
        }
    }

    private void addAllFields(List<Field> fields, Class tClass) {
        if (tClass != null && tClass != Object.class) {
            this.addAllFields(fields, tClass.getSuperclass());
        }
        for (Field field : tClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
    }
}

