/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum IOTools {

    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static void close(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(@NotNull Iterable<? extends Closeable> closeables) {
        for (Closeable closeable : closeables) {
            IOTools.close(closeable);
        }
    }

    public static int stopBitLength(long l) {
        if (l < 0L) {
            return IOTools.stopBitLength(l ^ 0xFFFFFFFFFFFFFFFFL) + 1;
        }
        int count = 1;
        while (l >= 128L) {
            l >>>= 7;
            ++count;
        }
        return count;
    }
}

