/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import java.lang.reflect.Constructor;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesMarshallable;
import net.openhft.lang.io.BytesMarshaller;
import net.openhft.lang.io.StopCharTester;
import org.jetbrains.annotations.NotNull;

public class BytesMarshallableMarshaller<E extends BytesMarshallable>
implements BytesMarshaller<E> {
    @NotNull
    private final Class<E> classMarshaled;
    private final Constructor<E> constructor;

    public BytesMarshallableMarshaller(@NotNull Class<E> classMarshaled) {
        this.classMarshaled = classMarshaled;
        try {
            this.constructor = classMarshaled.getConstructor(new Class[0]);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Class<E> classMarshaled() {
        return this.classMarshaled;
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull E e) {
        e.writeMarshallable(bytes);
    }

    @Override
    public void append(@NotNull Bytes bytes, @NotNull E e) {
        e.writeMarshallable(bytes);
    }

    @Override
    public E read(@NotNull Bytes bytes) {
        BytesMarshallable e;
        try {
            e = (BytesMarshallable)this.constructor.newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
        e.readMarshallable(bytes);
        return (E)e;
    }

    @Override
    public E parse(@NotNull Bytes bytes, StopCharTester tester) {
        return (E)this.read(bytes);
    }
}

