/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger id;
    private final String name;
    private final Boolean daemon;

    public NamedThreadFactory(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/thread/NamedThreadFactory.<init> must not be null");
        }
        this(name, null);
    }

    public NamedThreadFactory(@NotNull String name, Boolean daemon) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/thread/NamedThreadFactory.<init> must not be null");
        }
        this.id = new AtomicInteger();
        this.name = name;
        this.daemon = daemon;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/thread/NamedThreadFactory.newThread must not be null");
        }
        int id = this.id.getAndIncrement();
        String nameN = id == 0 ? this.name : this.name + '-' + id;
        Thread t = new Thread(r, nameN);
        if (this.daemon != null) {
            t.setDaemon(this.daemon);
        }
        Thread thread = t;
        if (thread == null) {
            throw new IllegalStateException("@NotNull method net/openhft/lang/thread/NamedThreadFactory.newThread must not return null");
        }
        return thread;
    }
}

