/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesMarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaBytesMarshaller<E extends Enum<E>>
implements BytesMarshaller<E> {
    @NotNull
    private final Class<E> classMarshaled;
    private final E[] interner;
    private final BitSet internerDup;
    private final Map<String, E> map;
    private final E defaultValue;
    private final int mask;
    private final StringBuilder reader;

    public VanillaBytesMarshaller(@NotNull Class<E> classMarshaled, E defaultValue) {
        if (classMarshaled == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/VanillaBytesMarshaller.<init> must not be null");
        }
        this.interner = new Enum[1024];
        this.internerDup = new BitSet(1024);
        this.map = new LinkedHashMap<String, E>();
        this.reader = new StringBuilder();
        this.classMarshaled = classMarshaled;
        this.defaultValue = defaultValue;
        this.mask = this.interner.length - 1;
        for (Enum e : (Enum[])classMarshaled.getEnumConstants()) {
            this.map.put(e.name(), e);
            int idx = this.hashFor(e.name());
            if (this.internerDup.get(idx)) continue;
            if (this.interner[idx] != null) {
                this.interner[idx] = null;
                this.internerDup.set(idx);
                continue;
            }
            this.interner[idx] = e;
        }
    }

    @Override
    public void write(@NotNull Bytes bytes, @Nullable E e) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/VanillaBytesMarshaller.write must not be null");
        }
        bytes.writeUTF\u0394(e == null ? "" : ((Enum)e).name());
    }

    private int hashFor(@NotNull CharSequence cs) {
        if (cs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/VanillaBytesMarshaller.hashFor must not be null");
        }
        int h = 0;
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            h = 57 * h + cs.charAt(i);
        }
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.mask;
    }

    @Override
    public E read(@NotNull Bytes bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/VanillaBytesMarshaller.read must not be null");
        }
        bytes.readUTF\u0394(this.reader);
        return this.builderToEnum();
    }

    private E builderToEnum() {
        int num = this.hashFor(this.reader);
        int idx = num & this.mask;
        Object e = this.interner[idx];
        if (e != null) {
            return e;
        }
        if (!this.internerDup.get(idx)) {
            return this.defaultValue;
        }
        e = (Enum)this.map.get(this.reader.toString());
        return e == null ? this.defaultValue : e;
    }
}

