/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import java.io.Externalizable;
import java.io.IOException;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesMarshaller;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;

public class ExternalizableMarshaller<E extends Externalizable>
implements BytesMarshaller<E> {
    @NotNull
    private final Class<E> classMarshaled;

    public ExternalizableMarshaller(@NotNull Class<E> classMarshaled) {
        if (classMarshaled == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/ExternalizableMarshaller.<init> must not be null");
        }
        this.classMarshaled = classMarshaled;
    }

    @Override
    public void write(Bytes bytes, @NotNull E e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of net/openhft/lang/io/impl/ExternalizableMarshaller.write must not be null");
        }
        try {
            e.writeExternal(bytes);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public E read(Bytes bytes) {
        Externalizable e;
        try {
            e = (Externalizable)NativeBytes.UNSAFE.allocateInstance(this.classMarshaled);
            e.readExternal(bytes);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
        return (E)e;
    }
}

