/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jetbrains.annotations.NotNull;

public class MutableDecimal
extends Number
implements Comparable<MutableDecimal> {
    static final double[] TENS = new double[16];
    private long value;
    private int scale;

    public MutableDecimal() {
        this(0L, Integer.MIN_VALUE);
    }

    public MutableDecimal(long value, int scale) {
        this.value = value;
        this.scale = scale;
    }

    public MutableDecimal(long value) {
        this(value, 0);
    }

    public MutableDecimal(double d, int precision) {
        this.set(d, precision);
    }

    public void set(double d, int precision) {
        double d2 = precision > 0 ? d * MutableDecimal.tens(precision) : d / MutableDecimal.tens(-precision);
        this.scale = precision;
        if (Math.abs(d2) < 1.0E16) {
            this.value = Math.round(d2);
        } else {
            BigDecimal bd = BigDecimal.valueOf(d).setScale(precision, RoundingMode.HALF_UP);
            this.value = bd.unscaledValue().longValue();
        }
    }

    public void set(long value, int scale) {
        this.value = value;
        this.scale = scale;
    }

    public long value() {
        return this.value;
    }

    public int scale() {
        return this.scale;
    }

    public void clear() {
        this.scale = Integer.MIN_VALUE;
    }

    public boolean isSet() {
        return this.scale > Integer.MIN_VALUE;
    }

    public int hashCode() {
        int hash = (int)this.value;
        hash = (int)((long)hash ^ this.value >>> 32);
        return hash ^= this.scale * 37;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MutableDecimal)) {
            return false;
        }
        MutableDecimal md = (MutableDecimal)obj;
        return this.value == md.value && this.scale == md.scale;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        this.toString(sb);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method net/openhft/lang/io/MutableDecimal.toString must not return null");
        }
        return string;
    }

    public void toString(@NotNull StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/MutableDecimal.toString must not be null");
        }
        if (this.scale == Integer.MIN_VALUE) {
            sb.append("not set");
            return;
        }
        if (this.value == 0L && this.scale <= 0) {
            sb.append('0');
            return;
        }
        boolean neg = false;
        long v = this.value;
        int s = this.scale;
        if (v < 0L) {
            v = -this.value;
            neg = true;
        }
        for (int s2 = this.scale; s2 < 0; ++s2) {
            sb.append('0');
        }
        while (v != 0L || s >= 0) {
            int digit = (int)(v % 10L);
            if (digit < 0) {
                digit = 8;
                v = (v >>> 1) / 5L;
            } else {
                v /= 10L;
            }
            sb.append((char)(48 + digit));
            if (--s != 0) continue;
            sb.append('.');
        }
        if (neg) {
            sb.append('-');
        }
        sb.reverse();
    }

    @NotNull
    public MutableDecimal clone() throws CloneNotSupportedException {
        MutableDecimal mutableDecimal = (MutableDecimal)super.clone();
        if (mutableDecimal == null) {
            throw new IllegalStateException("@NotNull method net/openhft/lang/io/MutableDecimal.clone must not return null");
        }
        return mutableDecimal;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        if (this.scale == 0) {
            return this.value;
        }
        if (this.scale > 0 && this.scale < TENS.length) {
            return this.value / (long)TENS[this.scale];
        }
        if (this.scale < 0 && -this.scale < TENS.length) {
            return this.value * (long)TENS[-this.scale];
        }
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        if (this.scale == 0) {
            return this.value;
        }
        return this.scale <= 0 ? (double)this.value * MutableDecimal.tens(-this.scale) : (double)this.value / MutableDecimal.tens(this.scale);
    }

    private static double tens(int scale) {
        return scale < TENS.length ? TENS[scale] : Math.pow(10.0, scale);
    }

    @Override
    public int compareTo(@NotNull MutableDecimal o) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/MutableDecimal.compareTo must not be null");
        }
        long value = this.value;
        long ovalue = o.value;
        if (this.scale == o.scale) {
            return MutableDecimal.longCompareTo(value, ovalue);
        }
        if (value == 0L && ovalue == 0L) {
            return 0;
        }
        double d = this.doubleValue();
        double od = o.doubleValue();
        double err = (Math.abs(d) + Math.abs(od)) / 1.0E15;
        if (d + err < od) {
            return -1;
        }
        if (d > od + err) {
            return 1;
        }
        return BigDecimal.valueOf(value, this.scale).compareTo(BigDecimal.valueOf(ovalue, o.scale()));
    }

    private static int longCompareTo(long value, long ovalue) {
        return value < ovalue ? -1 : (value > ovalue ? 1 : 0);
    }

    static {
        MutableDecimal.TENS[0] = 1.0;
        for (int i = 1; i < TENS.length; ++i) {
            MutableDecimal.TENS[i] = 10.0 * TENS[i - 1];
        }
    }
}

