/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.jlbh;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.SingleThreaded;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.ImmutableJLBHResult;
import net.openhft.chronicle.jlbh.ImmutableProbeResult;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHResult;
import net.openhft.chronicle.jlbh.LatencyDistributor;
import net.openhft.chronicle.jlbh.PercentileSummary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SingleThreaded
public class JLBH
implements NanoSampler {
    public static final int TIME_CALL_NANO_TIME = 18;
    private final SortedMap<String, Histogram> additionHistograms = new ConcurrentSkipListMap<String, Histogram>();
    private final long latencyBetweenTasks;
    private final LatencyDistributor latencyDistributor;
    @NotNull
    private final JLBHOptions jlbhOptions;
    @NotNull
    private final PrintStream printStream;
    private final Consumer<JLBHResult> resultConsumer;
    @NotNull
    private final List<double[]> percentileRuns;
    @NotNull
    private final Map<String, List<double[]>> additionalPercentileRuns;
    @NotNull
    private final OSJitterMonitor osJitterMonitor = new OSJitterMonitor();
    @NotNull
    private final Histogram endToEndHistogram = this.createHistogram();
    @NotNull
    private final Histogram osJitterHistogram = this.createHistogram();
    @NotNull
    private final AtomicBoolean warmUpComplete = new AtomicBoolean();
    private final AtomicBoolean abortTestRun = new AtomicBoolean();
    private final long mod;
    private final long length;
    private volatile long noResultsReturned;
    private boolean warmedUp;
    private volatile Thread testThread;

    public JLBH(@NotNull JLBHOptions jlbhOptions) {
        this(jlbhOptions, System.out, null);
    }

    public JLBH(@NotNull JLBHOptions jlbhOptions, @NotNull PrintStream printStream, Consumer<JLBHResult> resultConsumer) {
        long mod2;
        String resourceTracing = System.getProperty("jvm.resource.tracing");
        if (resourceTracing != null && (resourceTracing.isEmpty() || Boolean.parseBoolean(resourceTracing))) {
            System.out.println("***** WARNING : JLBH can not be run if jvm.resource.tracing=" + resourceTracing + ", please remove all \"jvm.resource.tracing\" as this will corrupt your stats *****");
            System.exit(-1);
        }
        this.jlbhOptions = jlbhOptions;
        this.printStream = printStream;
        this.resultConsumer = resultConsumer;
        if (jlbhOptions.jlbhTask == null) {
            throw new IllegalStateException("jlbhTask must be set");
        }
        this.latencyBetweenTasks = jlbhOptions.throughputTimeUnit.toNanos(1L) / (long)jlbhOptions.throughput;
        this.percentileRuns = new ArrayList<double[]>();
        this.additionalPercentileRuns = new TreeMap<String, List<double[]>>();
        this.latencyDistributor = jlbhOptions.latencyDistributor;
        this.length = jlbhOptions.iterations > 200000000L ? 60000000000L : (jlbhOptions.iterations > 50000000L ? 20000000000L : (jlbhOptions.iterations > 10000000L ? 10000000000L : 5000000000L));
        for (mod2 = 1000L; mod2 <= jlbhOptions.iterations / 200L; mod2 *= 10L) {
        }
        this.mod = mod2;
    }

    static CharSequence padUntil(CharSequence cs, int length, char ch) {
        StringBuilder sb = new StringBuilder(cs);
        while (sb.length() < length) {
            sb.append(ch);
        }
        return sb;
    }

    public NanoSampler addProbe(String name) {
        return (NanoSampler)this.additionHistograms.computeIfAbsent(name, n -> this.createHistogram());
    }

    @NotNull
    public Map<String, List<double[]>> additionalPercentileRuns() {
        return this.additionalPercentileRuns;
    }

    public void abort() {
        this.abortTestRun.set(true);
        this.testThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.startTimeoutCheckerIfRequired();
        this.testThread = Thread.currentThread();
        this.initStartOSJitterMonitor();
        long warmupStart = this.warmup();
        int interruptCheckThrottle = 0;
        int interruptCheckThrottleMask = 1023;
        AffinityLock lock = this.jlbhOptions.acquireLock.get();
        try {
            for (int run = 0; run < this.jlbhOptions.runs && !this.abortTestRun.get(); ++run) {
                long startTimeNs;
                long runStart = System.currentTimeMillis();
                long lastPrint = startTimeNs = System.nanoTime();
                long iterations = this.jlbhOptions.iterations;
                int i = 0;
                while ((long)i < iterations) {
                    if (i % 16 == 0 && (long)i % this.mod == 0L && startTimeNs > lastPrint + this.length) {
                        System.out.printf("... run %,d out of %,d%n", i, iterations);
                        lastPrint = startTimeNs;
                        startTimeNs = System.nanoTime();
                    }
                    if (i == 0 && run == 0) {
                        this.waitForWarmupToComplete(warmupStart);
                        runStart = System.currentTimeMillis();
                        startTimeNs = System.nanoTime();
                    } else {
                        long latencyBetweenTasks = this.latencyDistributor.apply(this.latencyBetweenTasks);
                        if (this.jlbhOptions.accountForCoordinatedOmission) {
                            long now = System.nanoTime();
                            if (now < (startTimeNs += latencyBetweenTasks)) {
                                long millis = (startTimeNs - now) / 1000000L - 2L;
                                if (millis > 0L) {
                                    Jvm.pause((long)millis);
                                }
                                startTimeNs = JLBH.busyWaitUntil(startTimeNs);
                            }
                        } else if ((double)latencyBetweenTasks > 2000000.0) {
                            long end = System.nanoTime() + latencyBetweenTasks;
                            Jvm.pause((long)(latencyBetweenTasks / 1000000L - 1L));
                            startTimeNs = JLBH.busyWaitUntil(startTimeNs);
                        } else {
                            long nowNS = System.nanoTime();
                            startTimeNs = (startTimeNs += latencyBetweenTasks - 14L) < nowNS + 18L ? nowNS : JLBH.busyWaitUntil(startTimeNs);
                        }
                    }
                    interruptCheckThrottle = interruptCheckThrottle + 1 & interruptCheckThrottleMask;
                    if (interruptCheckThrottle == 0 && this.testThread.isInterrupted()) break;
                    this.jlbhOptions.jlbhTask.run(startTimeNs);
                    ++i;
                }
                this.endOfRun(run, runStart);
            }
        }
        finally {
            this.osJitterMonitor.terminate();
            Thread.interrupted();
            Jvm.pause((long)5L);
            if (lock != null) {
                lock.release();
            }
            Jvm.pause((long)5L);
        }
        this.endOfAllRuns();
    }

    private static long busyWaitUntil(long startTimeNs) {
        long nanoTime;
        while (startTimeNs > (nanoTime = System.nanoTime())) {
        }
        startTimeNs = nanoTime;
        return startTimeNs;
    }

    private void startTimeoutCheckerIfRequired() {
        if (this.jlbhOptions.timeout > 0L) {
            Thread sampleTimeoutChecker = new Thread(this::checkSampleTimeout);
            sampleTimeoutChecker.setDaemon(true);
            sampleTimeoutChecker.start();
        }
    }

    private void waitForWarmupToComplete(long warmupStart) {
        while (!this.warmUpComplete.get()) {
            Jvm.pause((long)500L);
            this.printStream.println("Complete: " + this.noResultsReturned);
            if (!this.testThread.isInterrupted()) continue;
            return;
        }
        this.printStream.println("Warm up complete (" + this.jlbhOptions.warmUpIterations + " iterations took " + (double)(System.currentTimeMillis() - warmupStart) / 1000.0 + " s)");
        if (this.jlbhOptions.pauseAfterWarmupMS != 0) {
            this.printStream.println("Pausing after warmup for " + this.jlbhOptions.pauseAfterWarmupMS + " ms");
            Jvm.pause((long)this.jlbhOptions.pauseAfterWarmupMS);
        }
        this.jlbhOptions.jlbhTask.warmedUp();
    }

    private void initStartOSJitterMonitor() {
        this.jlbhOptions.jlbhTask.init(this);
        if (this.jlbhOptions.recordOSJitter) {
            this.osJitterMonitor.setDaemon(true);
            this.osJitterMonitor.start();
        }
    }

    private long warmup() {
        long warmupStart = System.currentTimeMillis();
        for (int i = 0; i < this.jlbhOptions.warmUpIterations; ++i) {
            this.jlbhOptions.jlbhTask.run(System.nanoTime());
        }
        return warmupStart;
    }

    private void endOfAllRuns() {
        this.printPercentilesSummary("end to end", this.percentileRuns, this.printStream);
        if (this.additionalPercentileRuns.size() > 0) {
            this.additionalPercentileRuns.forEach((label, percentileRuns1) -> this.printPercentilesSummary((String)label, (List<double[]>)percentileRuns1, this.printStream));
        }
        this.consumeResults();
        this.jlbhOptions.jlbhTask.complete();
    }

    public List<double[]> percentileRuns() {
        return this.percentileRuns;
    }

    private void endOfRun(int run, long runStart) {
        while (!this.abortTestRun.get() && this.endToEndHistogram.totalCount() < this.jlbhOptions.iterations) {
            Thread.yield();
        }
        long totalRunTime = System.currentTimeMillis() - runStart;
        this.percentileRuns.add(this.endToEndHistogram.getPercentiles());
        this.printStream.println(JLBH.padUntil("-------------------------------- BENCHMARK RESULTS (RUN " + (run + 1) + ") " + this.timeUnitToString(TimeUnit.MICROSECONDS) + " ----", 100, '-'));
        this.printStream.println("Run time: " + (double)totalRunTime / 1000.0 + " s, distribution: " + this.latencyDistributor);
        this.printStream.println("Correcting for co-ordinated:" + this.jlbhOptions.accountForCoordinatedOmission);
        this.printStream.println("Target throughput:" + this.jlbhOptions.throughput + "/" + this.timeUnitToString(this.jlbhOptions.throughputTimeUnit) + " = 1 message every " + this.latencyBetweenTasks / 1000L + "us");
        this.printStream.printf("%-48s", String.format("End to End: (%,d)", this.endToEndHistogram.totalCount()));
        this.printStream.println(this.endToEndHistogram.toMicrosFormat());
        if (this.additionHistograms.size() > 0) {
            this.additionHistograms.forEach((key, value) -> {
                List ds = this.additionalPercentileRuns.computeIfAbsent((String)key, i -> new ArrayList());
                ds.add(value.getPercentiles());
                this.printStream.printf("%-48s", String.format("%s (%,d)", key, value.totalCount()));
                this.printStream.println(value.toMicrosFormat());
            });
        }
        if (this.jlbhOptions.recordOSJitter) {
            this.printStream.printf("%-48s", String.format("OS Jitter (%,d)", this.osJitterHistogram.totalCount()));
            this.printStream.println(this.osJitterHistogram.toMicrosFormat());
        }
        this.printStream.println(JLBH.padUntil("----", 100, '-'));
        this.noResultsReturned = 0L;
        this.endToEndHistogram.reset();
        this.additionHistograms.values().forEach(Histogram::reset);
        this.osJitterMonitor.reset();
        this.jlbhOptions.jlbhTask.runComplete();
    }

    private void checkSampleTimeout() {
        long previousSampleCount = 0L;
        long previousSampleTime = 0L;
        while (true) {
            Jvm.pause((long)TimeUnit.SECONDS.toMillis(10L));
            if (previousSampleCount < this.noResultsReturned) {
                previousSampleCount = this.noResultsReturned;
                previousSampleTime = System.currentTimeMillis();
                continue;
            }
            if (previousSampleTime < System.currentTimeMillis() - this.jlbhOptions.timeout) break;
        }
        this.printStream.println("Sample timed out. Aborting test...");
        this.abort();
    }

    public void eventLoopHandler(@NotNull EventLoop eventLoop) {
        if (!this.jlbhOptions.accountForCoordinatedOmission) {
            throw new UnsupportedOperationException();
        }
        this.initStartOSJitterMonitor();
        eventLoop.addHandler((EventHandler)new WarmupHandler());
        Jvm.pause((long)100L);
        this.waitForWarmupToComplete(System.currentTimeMillis());
        eventLoop.addHandler((EventHandler)new JLBHEventHandler());
    }

    private void consumeResults() {
        if (this.resultConsumer != null) {
            ImmutableProbeResult endToEndProbeResult = new ImmutableProbeResult(this.percentileRuns);
            Map<String, ImmutableProbeResult> additionalProbeResults = this.additionalPercentileRuns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, probe -> new ImmutableProbeResult((List)probe.getValue())));
            this.resultConsumer.accept(new ImmutableJLBHResult(endToEndProbeResult, additionalProbeResults));
        }
    }

    public void printPercentilesSummary(String label, @NotNull List<double[]> percentileRuns, Appendable appendable) {
        try {
            boolean skipFirst;
            appendable.append(JLBH.padUntil("-------------------------------- SUMMARY (" + label + ") " + this.timeUnitToString(TimeUnit.MICROSECONDS) + " ----", 100, '-')).append("\n");
            double[] percentiles = Histogram.percentilesFor((long)this.jlbhOptions.iterations);
            boolean bl = skipFirst = percentiles.length > 3;
            if (this.jlbhOptions.skipFirstRun == JLBHOptions.SKIP_FIRST_RUN.SKIP) {
                skipFirst = true;
            } else if (this.jlbhOptions.skipFirstRun == JLBHOptions.SKIP_FIRST_RUN.NO_SKIP) {
                skipFirst = false;
            }
            PercentileSummary percentileSummary = new PercentileSummary(skipFirst, percentileRuns, percentiles);
            appendable.append(this.generateRunSummaryHeader(this.jlbhOptions.runs)).append('\n');
            percentileSummary.forEachRow((percentile, values, variance) -> {
                try {
                    appendable.append(this.formatPercentile(percentile));
                    for (double value : values) {
                        appendable.append(String.format("%12.2f ", value));
                    }
                    appendable.append(String.format("%12.2f%n", variance));
                }
                catch (IOException e) {
                    throw new IORuntimeException("Error writing percentile summary", (Throwable)e);
                }
            });
            appendable.append(JLBH.padUntil("----", 100, '-')).append("\n");
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private String formatPercentile(double percentile) {
        String s;
        if (percentile == 1.0) {
            s = "worst";
        } else {
            double p2 = (double)Math.round(percentile * 1000000.0) / 10000.0;
            s = Double.toString(p2);
        }
        s = s + ":     ";
        return s.substring(0, 9);
    }

    private void addPrToPrint(@NotNull StringBuilder sb, String pr, int runs) {
        sb.append(pr);
        for (int i = 0; i < runs; ++i) {
            sb.append("%12.2f ");
        }
        sb.append("%12.2f");
        sb.append("%n");
    }

    private String generateRunSummaryHeader(int runs) {
        StringBuilder sb = new StringBuilder();
        sb.append("Percentile");
        for (int i = 1; i < runs + 1; ++i) {
            if (i == 1) {
                sb.append("   run").append(i);
                continue;
            }
            sb.append("         run").append(i);
        }
        sb.append("      % Variation");
        return sb.toString();
    }

    private String timeUnitToString(@NotNull TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "day";
            }
        }
        throw new IllegalArgumentException("Unrecognized time unit value '" + (Object)((Object)timeUnit) + "'");
    }

    public void sampleNanos(long durationNs) {
        this.sample(durationNs);
    }

    public void sample(long durationNs) {
        ++this.noResultsReturned;
        if (this.noResultsReturned < (long)this.jlbhOptions.warmUpIterations && !this.warmedUp) {
            this.endToEndHistogram.sample((double)durationNs);
            return;
        }
        if (this.noResultsReturned == (long)this.jlbhOptions.warmUpIterations && !this.warmedUp) {
            this.warmedUp = true;
            this.endToEndHistogram.reset();
            if (!this.additionHistograms.isEmpty()) {
                this.additionHistograms.values().forEach(Histogram::reset);
            }
            this.warmUpComplete.set(true);
            return;
        }
        this.endToEndHistogram.sample((double)durationNs);
    }

    @NotNull
    protected Histogram createHistogram() {
        return new Histogram();
    }

    private final class WarmupHandler
    implements EventHandler {
        private int iteration;

        private WarmupHandler() {
        }

        public boolean action() throws InvalidEventHandlerException {
            if (this.iteration >= ((JLBH)JLBH.this).jlbhOptions.warmUpIterations) {
                throw InvalidEventHandlerException.reusable();
            }
            ((JLBH)JLBH.this).jlbhOptions.jlbhTask.run(System.nanoTime());
            ++this.iteration;
            return true;
        }

        public void loopStarted() {
            JLBH.this.testThread = Thread.currentThread();
        }
    }

    private final class JLBHEventHandler
    implements EventHandler {
        private int run;
        private long iteration;
        private long i;
        private long runStart;
        private long nextInvokeTime;
        private boolean waitingForEndOfRun = false;
        private long lastPrint;

        JLBHEventHandler() {
            this.resetTime();
            this.lastPrint = this.nextInvokeTime;
        }

        private void resetTime() {
            this.runStart = System.currentTimeMillis();
            this.nextInvokeTime = System.nanoTime() + JLBH.this.latencyBetweenTasks;
        }

        public boolean action() throws InvalidEventHandlerException {
            boolean busy = false;
            long iterations = ((JLBH)JLBH.this).jlbhOptions.iterations;
            if (!this.waitingForEndOfRun) {
                long now = System.nanoTime();
                if (now >= this.nextInvokeTime) {
                    ((JLBH)JLBH.this).jlbhOptions.jlbhTask.run(this.nextInvokeTime);
                    this.nextInvokeTime += JLBH.this.latencyBetweenTasks;
                    ++this.iteration;
                    busy = true;
                    if (this.i >= iterations - 1L) {
                        this.waitingForEndOfRun = true;
                        this.i = 0L;
                        ++this.run;
                    } else {
                        ++this.i;
                    }
                    if (this.i % 16L == 0L && this.i % JLBH.this.mod == 0L && this.nextInvokeTime > this.lastPrint + JLBH.this.length) {
                        System.out.printf("... run %,d out of %,d%n", this.i, iterations);
                        this.lastPrint = this.nextInvokeTime;
                    }
                }
            } else if (JLBH.this.endToEndHistogram.totalCount() >= iterations) {
                JLBH.this.endOfRun(this.run - 1, this.runStart);
                this.resetTime();
                this.waitingForEndOfRun = false;
                if (this.run == ((JLBH)JLBH.this).jlbhOptions.runs) {
                    JLBH.this.endOfAllRuns();
                    throw new InvalidEventHandlerException();
                }
            }
            return busy;
        }
    }

    private final class OSJitterMonitor
    extends Thread {
        final AtomicBoolean reset = new AtomicBoolean(false);
        final AtomicBoolean running = new AtomicBoolean(false);

        private OSJitterMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running.set(true);
            Affinity.setAffinity((BitSet)AffinityLock.BASE_AFFINITY);
            @Nullable AffinityLock affinityLock = null;
            if (((JLBH)JLBH.this).jlbhOptions.jitterAffinity) {
                JLBH.this.printStream.println("Jitter thread running with affinity.");
                affinityLock = AffinityLock.acquireLock();
            }
            try {
                long lastTime;
                long start = lastTime = System.nanoTime();
                while (this.running.get()) {
                    if (this.reset.compareAndSet(true, false)) {
                        JLBH.this.osJitterHistogram.reset();
                        lastTime = System.nanoTime();
                    }
                    for (int i = 0; i < 1000; ++i) {
                        long time = System.nanoTime();
                        if (time - lastTime > (long)((JLBH)JLBH.this).jlbhOptions.recordJitterGreaterThanNs) {
                            JLBH.this.osJitterHistogram.sampleNanos(time - lastTime);
                        }
                        lastTime = time;
                    }
                    if (!((double)lastTime > (double)start + 6.0E10)) continue;
                    Jvm.pause((long)1L);
                }
            }
            finally {
                if (affinityLock != null) {
                    affinityLock.release();
                }
            }
        }

        void reset() {
            this.reset.set(true);
        }

        void terminate() {
            this.running.set(false);
        }
    }
}

