/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.jlbh;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.openhft.chronicle.jlbh.JLBHResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImmutableRunResult
implements JLBHResult.RunResult {
    private final Map<JLBHResult.RunResult.Percentile, Duration> percentiles;

    public ImmutableRunResult(double[] percentiles) {
        this.percentiles = ImmutableRunResult.asMap(percentiles);
    }

    private static Map<JLBHResult.RunResult.Percentile, Duration> asMap(double[] percentiles) {
        EnumMap<JLBHResult.RunResult.Percentile, Duration> data = new EnumMap<JLBHResult.RunResult.Percentile, Duration>(JLBHResult.RunResult.Percentile.class);
        data.put(JLBHResult.RunResult.Percentile.PERCENTILE_50TH, ImmutableRunResult.durationOf(percentiles[0]));
        data.put(JLBHResult.RunResult.Percentile.PERCENTILE_90TH, ImmutableRunResult.durationOf(percentiles[1]));
        data.put(JLBHResult.RunResult.Percentile.PERCENTILE_99TH, ImmutableRunResult.durationOf(percentiles[2]));
        if (percentiles.length > 4) {
            data.put(JLBHResult.RunResult.Percentile.PERCENTILE_99_7TH, ImmutableRunResult.durationOf(percentiles[3]));
        }
        if (percentiles.length > 5) {
            data.put(JLBHResult.RunResult.Percentile.PERCENTILE_99_9TH, ImmutableRunResult.durationOf(percentiles[4]));
        }
        if (percentiles.length > 6) {
            data.put(JLBHResult.RunResult.Percentile.PERCENTILE_99_97TH, ImmutableRunResult.durationOf(percentiles[5]));
        }
        if (percentiles.length > 7) {
            data.put(JLBHResult.RunResult.Percentile.PERCENTILE_99_99TH, ImmutableRunResult.durationOf(percentiles[6]));
        }
        data.put(JLBHResult.RunResult.Percentile.WORST, ImmutableRunResult.durationOf(percentiles[percentiles.length - 1]));
        return Collections.unmodifiableMap(data);
    }

    private static Duration durationOf(double percentile) {
        return Duration.of((long)percentile, ChronoUnit.NANOS);
    }

    @Override
    @NotNull
    public Map<JLBHResult.RunResult.Percentile, Duration> percentiles() {
        return this.percentiles;
    }

    @Override
    @NotNull
    public Duration get50thPercentile() {
        return this.percentiles.get((Object)JLBHResult.RunResult.Percentile.PERCENTILE_50TH);
    }

    @Override
    @NotNull
    public Duration get90thPercentile() {
        return this.percentiles.get((Object)JLBHResult.RunResult.Percentile.PERCENTILE_90TH);
    }

    @Override
    @NotNull
    public Duration get99thPercentile() {
        return this.percentiles.get((Object)JLBHResult.RunResult.Percentile.PERCENTILE_99TH);
    }

    @Override
    @Nullable
    public Duration get999thPercentile() {
        return this.percentiles.get((Object)JLBHResult.RunResult.Percentile.PERCENTILE_99_9TH);
    }

    @Override
    @Nullable
    public Duration get9999thPercentile() {
        return this.percentiles.get((Object)JLBHResult.RunResult.Percentile.PERCENTILE_99_99TH);
    }

    @Override
    @NotNull
    public Duration getWorst() {
        return this.percentiles.get((Object)JLBHResult.RunResult.Percentile.WORST);
    }

    public String toString() {
        return "ImmutableRunResult{percentiles=" + this.percentiles + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRunResult summary = (ImmutableRunResult)o;
        return this.percentiles.equals(summary.percentiles);
    }

    public int hashCode() {
        return this.percentiles.hashCode();
    }
}

