/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import net.openhft.compiler.CompilerUtils;
import net.openhft.compiler.JavaSourceFromString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(CachedCompiler.class);
    private static final Map<ClassLoader, Map<String, Class>> loadedClassesMap = new WeakHashMap<ClassLoader, Map<String, Class>>();
    private static final PrintWriter DEFAULT_WRITER = new PrintWriter(System.err);
    @Nullable
    private final File sourceDir;
    @Nullable
    private final File classDir;
    private final Map<String, JavaFileObject> javaFileObjects = new HashMap<String, JavaFileObject>();

    public CachedCompiler(@Nullable File sourceDir, @Nullable File classDir) {
        this.sourceDir = sourceDir;
        this.classDir = classDir;
    }

    public static void close() {
        try {
            CompilerUtils.s_fileManager.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Class loadFromJava(@NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        return this.loadFromJava(this.getClass().getClassLoader(), className, javaCode, DEFAULT_WRITER);
    }

    public Class loadFromJava(@NotNull ClassLoader classLoader, @NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        return this.loadFromJava(classLoader, className, javaCode, DEFAULT_WRITER);
    }

    @NotNull
    Map<String, byte[]> compileFromJava(@NotNull String className, @NotNull String javaCode) {
        return this.compileFromJava(className, javaCode, DEFAULT_WRITER);
    }

    @NotNull
    Map<String, byte[]> compileFromJava(@NotNull String className, @NotNull String javaCode, final @NotNull PrintWriter writer) {
        Iterable<JavaFileObject> compilationUnits;
        if (this.sourceDir != null) {
            String filename = className.replaceAll("\\.", '\\' + File.separator) + ".java";
            File file = new File(this.sourceDir, filename);
            CompilerUtils.writeText(file, javaCode);
            compilationUnits = CompilerUtils.s_standardJavaFileManager.getJavaFileObjects(file);
        } else {
            this.javaFileObjects.put(className, new JavaSourceFromString(className, javaCode));
            compilationUnits = this.javaFileObjects.values();
        }
        boolean ok = CompilerUtils.s_compiler.getTask(writer, CompilerUtils.s_fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    writer.println(diagnostic);
                }
            }
        }, null, null, compilationUnits).call();
        Map<String, byte[]> result = CompilerUtils.s_fileManager.getAllBuffers();
        if (!ok) {
            if (this.sourceDir == null) {
                this.javaFileObjects.remove(className);
            }
            return Collections.emptyMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadFromJava(@NotNull ClassLoader classLoader, @NotNull String className, @NotNull String javaCode, @Nullable PrintWriter writer) throws ClassNotFoundException {
        PrintWriter printWriter;
        Map<String, Class> loadedClasses;
        Class<?> clazz = null;
        Map<ClassLoader, Map<String, Class>> map = loadedClassesMap;
        synchronized (map) {
            loadedClasses = loadedClassesMap.get(classLoader);
            if (loadedClasses == null) {
                loadedClasses = new LinkedHashMap<String, Class>();
                loadedClassesMap.put(classLoader, loadedClasses);
            } else {
                clazz = loadedClasses.get(className);
            }
        }
        PrintWriter printWriter2 = printWriter = writer == null ? DEFAULT_WRITER : writer;
        if (clazz != null) {
            return clazz;
        }
        for (Map.Entry<String, byte[]> entry : this.compileFromJava(className, javaCode, printWriter).entrySet()) {
            String filename;
            boolean changed;
            String className2 = entry.getKey();
            Map<ClassLoader, Map<String, Class>> map2 = loadedClassesMap;
            synchronized (map2) {
                if (loadedClasses.containsKey(className2)) {
                    continue;
                }
            }
            byte[] bytes = entry.getValue();
            if (this.classDir != null && (changed = CompilerUtils.writeBytes(new File(this.classDir, filename = className2.replaceAll("\\.", '\\' + File.separator) + ".class"), bytes))) {
                LOG.info("Updated {} in {}", (Object)className2, (Object)this.classDir);
            }
            Class clazz2 = CompilerUtils.defineClass(classLoader, className2, bytes);
            Map<ClassLoader, Map<String, Class>> map3 = loadedClassesMap;
            synchronized (map3) {
                loadedClasses.put(className2, clazz2);
            }
        }
        Map<ClassLoader, Map<String, Class>> map4 = loadedClassesMap;
        synchronized (map4) {
            clazz = classLoader.loadClass(className);
            loadedClasses.put(className, clazz);
        }
        return clazz;
    }
}

