/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.tcp.AppenderAdapter;
import net.openhft.lang.model.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppenderAdapters {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppenderAdapters.class);

    public static AppenderAdapter createAdapter(Chronicle chronicle) throws IOException {
        if (chronicle instanceof IndexedChronicle) {
            return new IndexedAppenderAdapter(chronicle, chronicle.createAppender());
        }
        if (chronicle instanceof VanillaChronicle) {
            return new VanillaAppenderAdapter(chronicle, chronicle.createAppender());
        }
        throw new IllegalArgumentException("Can only adapt Indexed or Vanilla chronicles");
    }

    static final class VanillaAppenderAdapter
    extends AppenderAdapter {
        private final VanillaChronicle chronicle;
        private final VanillaChronicle.VanillaAppender appender;

        public VanillaAppenderAdapter(@NotNull Chronicle chronicle, @NotNull ExcerptAppender appender) {
            super(appender);
            this.chronicle = (VanillaChronicle)chronicle;
            this.appender = (VanillaChronicle.VanillaAppender)appender;
        }

        @Override
        public void writePaddedEntry() {
            LOGGER.warn("VanillaChronicle should not receive padded entries");
        }

        @Override
        public void startExcerpt(long capacity, long index) {
            int cycle = (int)(index >>> this.chronicle.getEntriesForCycleBits());
            this.appender.startExcerpt(capacity, cycle);
        }
    }

    static final class IndexedAppenderAdapter
    extends AppenderAdapter {
        public IndexedAppenderAdapter(@NotNull Chronicle chronicle, @NotNull ExcerptAppender appender) {
            super(appender);
        }

        @Override
        public void writePaddedEntry() {
            ((ExcerptAppender)this.wrapped).addPaddedEntry();
        }

        @Override
        public void startExcerpt(long capacity, long index) {
            ((ExcerptAppender)this.wrapped).startExcerpt(capacity);
        }
    }
}

