/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.tcp.ChronicleTcp;
import net.openhft.chronicle.tcp.SinkTcp;
import net.openhft.chronicle.tools.WrappedChronicle;
import net.openhft.chronicle.tools.WrappedExcerptAppenders;
import net.openhft.chronicle.tools.WrappedExcerpts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteChronicleQueue
extends WrappedChronicle {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChronicleQueue.class);
    private final SinkTcp connection;
    private final ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder;
    private final boolean blocking;
    private volatile boolean closed;
    private long lastReconnectionAttemptMS;
    private long reconnectionIntervalMS;
    private long lastReconnectionAttempt;
    private ExcerptCommon excerpt;

    protected RemoteChronicleQueue(ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder, SinkTcp connection, boolean blocking) {
        super(builder.chronicle());
        this.connection = connection;
        this.builder = builder.clone();
        this.closed = false;
        this.blocking = blocking;
        this.excerpt = null;
        this.reconnectionIntervalMS = builder.reconnectionIntervalMillis();
        this.lastReconnectionAttemptMS = 0L;
        this.lastReconnectionAttempt = 0L;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.closeConnection();
        }
        super.close();
    }

    @Override
    public Excerpt createExcerpt() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExcerptTailer createTailer() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExcerptAppender createAppender() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected synchronized ExcerptCommon createAppender0() throws IOException {
        if (this.excerpt != null) {
            throw new IllegalStateException("An excerpt has already been created");
        }
        this.excerpt = new StatelessExcerptAppender();
        return this.excerpt;
    }

    protected synchronized ExcerptCommon createExcerpt0() throws IOException {
        if (this.excerpt != null) {
            throw new IllegalStateException("An excerpt has already been created");
        }
        this.excerpt = new StatelessExcerpt();
        return this.excerpt;
    }

    private boolean openConnection() {
        boolean connected;
        if (!this.connection.isOpen()) {
            try {
                this.connection.open(this.blocking);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (connected = this.connection.isOpen()) {
            this.lastReconnectionAttempt = 0L;
            this.lastReconnectionAttemptMS = 0L;
        } else {
            ++this.lastReconnectionAttempt;
            if (this.builder.reconnectionWarningThreshold() > 0 && this.lastReconnectionAttempt > (long)this.builder.reconnectionWarningThreshold()) {
                LOGGER.warn("Failed to establish a connection {}", (Object)ChronicleTcp.connectionName("", this.builder));
            }
        }
        return connected;
    }

    private void closeConnection() {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error closing socketChannel", (Throwable)e);
        }
    }

    @Override
    public String name() {
        return null;
    }

    protected boolean shouldConnect() {
        if (this.lastReconnectionAttempt >= (long)this.builder.reconnectionAttempts()) {
            long now = System.currentTimeMillis();
            if (now < this.lastReconnectionAttemptMS + this.reconnectionIntervalMS) {
                return false;
            }
            this.lastReconnectionAttemptMS = now;
        }
        return true;
    }

    private final class StatelessExcerpt
    extends WrappedExcerpts.ByteBufferBytesExcerptWrapper {
        private final Logger logger;
        private final ByteBuffer writeBuffer;
        private long index;
        private int readCount;

        public StatelessExcerpt() {
            super(RemoteChronicleQueue.this.builder.minBufferSize());
            this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "@" + RemoteChronicleQueue.this.connection.toString()));
            this.index = -1L;
            this.writeBuffer = ChronicleTcp.createBufferOfSize(16);
            this.readCount = RemoteChronicleQueue.this.builder.readSpinCount();
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public Excerpt toStart() {
            this.index(-1L);
            return this;
        }

        @Override
        public Excerpt toEnd() {
            this.index(-2L);
            return this;
        }

        @Override
        public Chronicle chronicle() {
            return RemoteChronicleQueue.this;
        }

        public synchronized void close() {
            try {
                RemoteChronicleQueue.this.connection.writeAction(this.writeBuffer, 2L, 0L);
                RemoteChronicleQueue.this.closeConnection();
            }
            catch (IOException e) {
                this.logger.warn("", (Throwable)e);
            }
            super.close();
            RemoteChronicleQueue.this.excerpt = null;
        }

        @Override
        public boolean index(long index) {
            try {
                if (!RemoteChronicleQueue.this.connection.isOpen()) {
                    if (RemoteChronicleQueue.this.shouldConnect()) {
                        if (!RemoteChronicleQueue.this.openConnection()) {
                            return false;
                        }
                        this.cleanup();
                    } else {
                        return false;
                    }
                }
                RemoteChronicleQueue.this.connection.writeAction(this.writeBuffer, 1L, index);
                while (true) {
                    RemoteChronicleQueue.this.connection.readUpTo(this.buffer(), 12, -1);
                    int receivedSize = this.buffer().getInt();
                    long receivedIndex = this.buffer().getLong();
                    switch (receivedSize) {
                        case -126: {
                            if (index == -1L) {
                                return receivedIndex == -1L;
                            }
                            if (index == -2L) {
                                return this.advanceIndex();
                            }
                            if (index == receivedIndex) {
                                return this.advanceIndex();
                            }
                        }
                        case -128: 
                        case -127: {
                            return false;
                        }
                    }
                    if (receivedSize <= 0) continue;
                    RemoteChronicleQueue.this.connection.readUpTo(this.buffer(), receivedSize, -1);
                }
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    this.logger.trace("", (Throwable)e);
                } else {
                    this.logger.warn("", (Throwable)e);
                }
                return false;
            }
        }

        @Override
        public boolean nextIndex() {
            this.finish();
            try {
                if (!RemoteChronicleQueue.this.connection.isOpen()) {
                    if (this.index(this.index)) {
                        return this.nextIndex();
                    }
                    return false;
                }
                if (!RemoteChronicleQueue.this.connection.readUpTo(this.buffer(), 12, this.readCount)) {
                    return false;
                }
                int receivedSize = this.buffer().getInt();
                long receivedIndex = this.buffer().getLong();
                switch (receivedSize) {
                    case -128: {
                        return false;
                    }
                    case -127: 
                    case -126: {
                        return this.nextIndex();
                    }
                }
                if (receivedSize > 0x8000000 || receivedSize < 0) {
                    throw new StreamCorruptedException("Size was " + receivedSize);
                }
                this.resize(receivedSize);
                RemoteChronicleQueue.this.connection.readUpTo(this.buffer(), receivedSize, -1);
                this.index = receivedIndex;
            }
            catch (IOException e1) {
                if (e1 instanceof EOFException) {
                    this.logger.trace("Exception reading from socket", (Throwable)e1);
                } else {
                    this.logger.warn("Exception reading from socket", (Throwable)e1);
                }
                try {
                    RemoteChronicleQueue.this.connection.close();
                }
                catch (IOException e2) {
                    this.logger.warn("Error closing soocket", (Throwable)e2);
                }
                return false;
            }
            return true;
        }

        protected boolean advanceIndex() throws IOException {
            if (this.nextIndex()) {
                this.finish();
                return true;
            }
            return false;
        }
    }

    private final class StatelessExcerptAppender
    extends WrappedExcerptAppenders.ByteBufferBytesExcerptAppenderWrapper {
        private final Logger logger;
        private final ByteBuffer readBuffer;
        private final ByteBuffer commandBuffer;
        private long lastIndex;
        private long actionType;

        public StatelessExcerptAppender() {
            super(RemoteChronicleQueue.this.builder.minBufferSize());
            this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "@" + RemoteChronicleQueue.this.connection.toString()));
            this.readBuffer = ChronicleTcp.createBufferOfSize(12);
            this.commandBuffer = ChronicleTcp.createBufferOfSize(16);
            this.lastIndex = -1L;
            this.actionType = RemoteChronicleQueue.this.builder.appendRequireAck() ? 20L : 21L;
        }

        public long capacity() {
            return super.limit();
        }

        @Override
        public void startExcerpt() {
            this.startExcerpt(RemoteChronicleQueue.this.builder.minBufferSize());
        }

        @Override
        public void startExcerpt(long excerptSize) {
            if (!this.isFinished()) {
                this.finish();
            }
            super.startExcerpt(excerptSize);
        }

        @Override
        public Chronicle chronicle() {
            return RemoteChronicleQueue.this;
        }

        @Override
        public void finish() {
            if (!this.isFinished()) {
                if (!RemoteChronicleQueue.this.connection.isOpen() && !this.waitForConnection()) {
                    super.finish();
                    throw new IllegalStateException("Unable to connect to the Source");
                }
                try {
                    RemoteChronicleQueue.this.connection.writeAction(this.commandBuffer, this.actionType, this.position());
                    ByteBuffer buffer = ((WrappedExcerptAppenders.ByteBufferBytesAppender)this.wrapped).buffer();
                    buffer.limit((int)((WrappedExcerptAppenders.ByteBufferBytesAppender)this.wrapped).position());
                    RemoteChronicleQueue.this.connection.writeAllOrEOF(buffer);
                    if (RemoteChronicleQueue.this.builder.appendRequireAck()) {
                        RemoteChronicleQueue.this.connection.readUpTo(this.readBuffer, 12, -1);
                        int recType = this.readBuffer.getInt();
                        long recIndex = this.readBuffer.getLong();
                        switch (recType) {
                            case -129: {
                                this.lastIndex = recIndex;
                                break;
                            }
                            case -130: {
                                throw new IllegalStateException("Message discarded by server, reason: " + (recIndex == -4L ? "unsupported" : "unknown"));
                            }
                            default: {
                                this.logger.warn("Unknown message received {}, {}", (Object)recType, (Object)recIndex);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.trace("", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
            super.finish();
        }

        public synchronized void close() {
            RemoteChronicleQueue.this.closeConnection();
            super.close();
            RemoteChronicleQueue.this.excerpt = null;
        }

        @Override
        public long index() {
            return -1L;
        }

        @Override
        public long lastWrittenIndex() {
            return this.lastIndex;
        }

        private boolean waitForConnection() {
            for (int i = RemoteChronicleQueue.this.builder.reconnectionAttempts(); !RemoteChronicleQueue.this.connection.isOpen() && i > 0; ++i) {
                RemoteChronicleQueue.this.openConnection();
                if (RemoteChronicleQueue.this.connection.isOpen()) continue;
                try {
                    Thread.sleep(RemoteChronicleQueue.this.builder.reconnectionIntervalMillis());
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return RemoteChronicleQueue.this.connection.isOpen();
        }
    }
}

