/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.tools.WrappedExcerpt;
import net.openhft.lang.model.constraints.NotNull;

public class CheckedExcerpt
extends WrappedExcerpt {
    public CheckedExcerpt(@NotNull ExcerptCommon common) {
        super(common);
    }

    public void write(int i) {
        this.checkSpaceLeft(1L);
        super.write(i);
    }

    public void writeByte(int i) {
        this.checkSpaceLeft(1L);
        super.writeByte(i);
    }

    public void writeByte(long offset, int i) {
        this.checkSpaceLeft(offset, 1L);
        super.writeByte(offset, i);
    }

    public void writeShort(int i) {
        this.checkSpaceLeft(2L);
        super.writeShort(i);
    }

    public void writeShort(long offset, int i) {
        this.checkSpaceLeft(offset, 2L);
        super.writeShort(offset, i);
    }

    public void writeChar(int i) {
        this.checkSpaceLeft(1L);
        super.writeChar(i);
    }

    public void writeChar(long offset, int i) {
        this.checkSpaceLeft(offset, 1L);
        super.writeChar(offset, i);
    }

    public void writeInt(int i) {
        this.checkSpaceLeft(4L);
        super.writeInt(i);
    }

    public void writeInt(long offset, int i) {
        this.checkSpaceLeft(offset, 4L);
        super.writeInt(offset, i);
    }

    public void writeOrderedInt(int i) {
        this.checkSpaceLeft(4L);
        super.writeOrderedInt(i);
    }

    public void writeOrderedInt(long offset, int i) {
        this.checkSpaceLeft(offset, 4L);
        super.writeOrderedInt(offset, i);
    }

    public boolean compareAndSwapInt(long offset, int expected, int x) {
        this.checkSpaceLeft(offset, 4L);
        return super.compareAndSwapInt(offset, expected, x);
    }

    public void writeLong(long l) {
        this.checkSpaceLeft(8L);
        super.writeLong(l);
    }

    public void writeLong(long offset, long l) {
        this.checkSpaceLeft(offset, 8L);
        super.writeLong(offset, l);
    }

    public void writeOrderedLong(long l) {
        this.checkSpaceLeft(8L);
        super.writeOrderedLong(l);
    }

    public void writeOrderedLong(long offset, long l) {
        this.checkSpaceLeft(offset, 8L);
        super.writeOrderedLong(offset, l);
    }

    public boolean compareAndSwapLong(long offset, long expected, long x) {
        this.checkSpaceLeft(offset, 8L);
        return super.compareAndSwapLong(offset, expected, x);
    }

    public void writeFloat(float v) {
        this.checkSpaceLeft(4L);
        super.writeFloat(v);
    }

    public void writeFloat(long offset, float v) {
        this.checkSpaceLeft(4L);
        super.writeFloat(offset, v);
    }

    public void writeDouble(double v) {
        this.checkSpaceLeft(8L);
        super.writeDouble(v);
    }

    public void writeDouble(long offset, double v) {
        this.checkSpaceLeft(offset, 8L);
        super.writeDouble(offset, v);
    }

    public void writeObject(Object object, int start, int end) {
        this.checkSpaceLeft(end - start);
        super.writeObject(object, start, end);
    }

    private void checkSpaceLeft(long offset, long requiredSize) {
        this.checkSpaceLeft0(requiredSize, this.limit() - offset);
    }

    private void checkSpaceLeft(long requiredSize) {
        this.checkSpaceLeft0(requiredSize, this.remaining());
    }

    private void checkSpaceLeft0(long requiredSize, long availableSize) {
        if (requiredSize > availableSize) {
            throw new IllegalStateException("Not enough space left, required is " + requiredSize + " remaining is " + availableSize);
        }
    }
}

