/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.io.IOException;
import net.openhft.chronicle.ChronicleConfig;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.tools.ChronicleTools;

class ChronicleWarmup {
    public static final boolean DONE;
    public static final int WARMUP_ITER = 200000;
    private static final String TMP;

    ChronicleWarmup() {
    }

    static {
        TMP = System.getProperty("java.io.tmpdir");
        ChronicleConfig cc = ChronicleConfig.DEFAULT.clone();
        cc.dataBlockSize(64);
        cc.indexBlockSize(64);
        String basePath = TMP + "/warmup-" + Math.random();
        ChronicleTools.deleteOnExit(basePath);
        try {
            IndexedChronicle ic = new IndexedChronicle(basePath, cc);
            ExcerptAppender appender = ic.createAppender();
            ExcerptTailer tailer = ic.createTailer();
            for (int i = 0; i < 200000; ++i) {
                appender.startExcerpt();
                appender.writeInt(i);
                appender.finish();
                boolean b = tailer.nextIndex() || tailer.nextIndex();
                tailer.readInt();
                tailer.finish();
            }
            ic.close();
            System.gc();
            DONE = true;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }
}

