/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal;

import java.util.Map;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapMarshaller<K, V>
implements WriteMarshallable {
    private Map<K, V> map;
    private Class<K> kClass;
    private Class<V> vClass;
    private boolean leaf;

    public void params(@Nullable Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass, boolean leaf) {
        this.map = map;
        this.kClass = kClass;
        this.vClass = vClass;
        this.leaf = leaf;
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) throws InvalidMarshallableException {
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            ValueOut valueOut = wire.writeEvent(this.kClass, entry.getKey());
            boolean wasLeaf = valueOut.swapLeaf(this.leaf);
            valueOut.object(this.vClass, entry.getValue());
            valueOut.swapLeaf(wasLeaf);
        }
    }
}

