/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.scoped.ScopedResourcePool;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.YamlKeys;
import net.openhft.chronicle.wire.YamlToken;
import org.jetbrains.annotations.NotNull;

public class YamlTokeniser {
    static final int NO_INDENT = -1;
    static final Set<YamlToken> NO_TEXT = EnumSet.of(YamlToken.SEQUENCE_START, new YamlToken[]{YamlToken.SEQUENCE_ENTRY, YamlToken.SEQUENCE_END, YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.MAPPING_END, YamlToken.DIRECTIVES_END});
    static final ScopedResourcePool<StringBuilder> SBP = StringBuilderPool.createThreadLocal((int)1);
    protected final List<YTContext> contexts = new ArrayList<YTContext>();
    private final BytesIn<?> in;
    private final List<YTContext> freeContexts = new ArrayList<YTContext>();
    private final List<YamlToken> pushed = new ArrayList<YamlToken>();
    Bytes<?> temp = null;
    long lineStart;
    long blockStart;
    long blockEnd;
    int flowDepth = Integer.MAX_VALUE;
    char blockQuote = '\u0000';
    boolean hasSequenceEntry;
    long lastKeyPosition = -1L;
    private YamlToken last = YamlToken.STREAM_START;

    public YamlTokeniser(BytesIn<?> inputStream) {
        this.reset();
        this.in = inputStream;
    }

    public int contextSize() {
        return this.contexts.size();
    }

    void reset() {
        long pos;
        this.contexts.clear();
        this.freeContexts.clear();
        if (this.temp != null) {
            this.temp.clear();
        }
        this.blockStart = this.blockEnd = (pos = this.in == null ? 0L : this.in.readPosition());
        this.lineStart = this.blockEnd;
        this.flowDepth = Integer.MAX_VALUE;
        this.blockQuote = '\u0000';
        this.hasSequenceEntry = false;
        this.lastKeyPosition = -1L;
        this.pushed.clear();
        this.last = YamlToken.STREAM_START;
        this.pushContext0(YamlToken.STREAM_START, -1);
    }

    public YamlToken context() {
        return this.contexts.isEmpty() ? YamlToken.STREAM_START : this.topContext().token;
    }

    public YTContext topContext() {
        return this.contexts.get(this.contextSize() - 1);
    }

    public YTContext secondTopContext() {
        return this.contexts.get(this.contextSize() - 2);
    }

    public YamlToken current() {
        if (this.last == YamlToken.STREAM_START) {
            return this.next(-1);
        }
        return this.last;
    }

    public YamlToken next() {
        return this.next(this.contextIndent());
    }

    @NotNull
    public YamlToken next(int minIndent) {
        YamlToken next;
        if (!this.pushed.isEmpty()) {
            YamlToken next2;
            this.last = next2 = this.popPushed();
            return this.last;
        }
        this.last = next = this.next0(minIndent);
        return this.last;
    }

    YamlToken next0(int minIndent) {
        this.consumeWhitespace();
        this.blockStart = this.blockEnd = this.in.readPosition();
        if (this.temp != null) {
            this.temp.clear();
        }
        YTContext context = this.topContext();
        int indent2 = Math.toIntExact(this.in.readPosition() - this.lineStart) * 2;
        int ch = this.in.readUnsignedByte();
        switch (ch) {
            case -1: {
                if (this.contextIndent() <= minIndent) {
                    return YamlToken.NONE;
                }
                this.contextPop();
                return this.popPushed();
            }
            case 35: {
                this.readComment();
                return YamlToken.COMMENT;
            }
            case 34: {
                if (this.wouldChangeContext(minIndent, indent2)) {
                    return this.dontRead();
                }
                this.lastKeyPosition = this.in.readPosition() - 1L;
                this.readDoublyQuoted();
                if (this.isFieldEnd()) {
                    return this.indent(YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.TEXT, indent2);
                }
                return YamlToken.TEXT;
            }
            case 39: {
                if (this.wouldChangeContext(minIndent, indent2)) {
                    return this.dontRead();
                }
                this.lastKeyPosition = this.in.readPosition() - 1L;
                this.readSinglyQuoted();
                if (this.isFieldEnd()) {
                    return this.indent(YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.TEXT, indent2);
                }
                return YamlToken.TEXT;
            }
            case 63: {
                if (this.wouldChangeContext(minIndent, indent2)) {
                    return this.dontRead();
                }
                this.lastKeyPosition = this.in.readPosition() - 1L;
                YamlToken indentB = this.indent(YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.STREAM_START, indent2);
                this.contextPush(YamlToken.MAPPING_KEY, indent2);
                return indentB;
            }
            case 45: {
                int next = this.in.peekUnsignedByte();
                if (next <= 32) {
                    if (this.wouldChangeContext(minIndent, indent2 + 1)) {
                        return this.dontRead();
                    }
                    this.hasSequenceEntry = true;
                    return this.indent(YamlToken.SEQUENCE_START, YamlToken.SEQUENCE_ENTRY, YamlToken.STREAM_START, indent2 + 1);
                }
                if (indent2 == 0 && next == 45 && this.in.peekUnsignedByte(this.in.readPosition() + 1L) == 45 && this.in.peekUnsignedByte(this.in.readPosition() + 2L) <= 32) {
                    if (this.contextIndent() <= minIndent && minIndent >= 0) {
                        return this.dontRead();
                    }
                    this.in.readSkip(2L);
                    this.pushed.add(YamlToken.DIRECTIVES_END);
                    this.popAll(1);
                    this.contextPush(YamlToken.DIRECTIVES_END, -1);
                    return this.popPushed();
                }
                this.unreadLast();
                return this.readText(indent2);
            }
            case 46: {
                int next = this.in.peekUnsignedByte();
                if (indent2 == 0 && next == 46 && this.in.peekUnsignedByte(this.in.readPosition() + 1L) == 46 && this.in.peekUnsignedByte(this.in.readPosition() + 2L) <= 32) {
                    if (this.contextIndent() <= minIndent) {
                        return this.dontRead();
                    }
                    this.in.readSkip(2L);
                    this.popAll(1);
                    return this.popPushed();
                }
                this.unreadLast();
                return this.readText(indent2);
            }
            case 38: {
                if (this.in.peekUnsignedByte() <= 32) break;
                this.readWord();
                return YamlToken.ANCHOR;
            }
            case 42: {
                if (this.in.peekUnsignedByte() <= 32) break;
                this.readWord();
                return YamlToken.ALIAS;
            }
            case 124: {
                if (this.in.peekUnsignedByte() > 32) break;
                this.readLiteral();
                return this.seq(YamlToken.LITERAL);
            }
            case 62: {
                if (this.in.peekUnsignedByte() > 32) break;
                this.readFolded();
                return this.seq(YamlToken.LITERAL);
            }
            case 37: {
                this.readDirective();
                return YamlToken.DIRECTIVE;
            }
            case 64: 
            case 96: {
                this.readReserved();
                return this.seq(YamlToken.RESERVED);
            }
            case 33: {
                this.readWord();
                this.push(this.seq(YamlToken.TAG));
                if (this.context() == YamlToken.STREAM_START) {
                    this.pushContext0(YamlToken.DIRECTIVES_END, -1);
                    this.push(YamlToken.DIRECTIVES_END);
                }
                return this.popPushed();
            }
            case 123: {
                return this.flow(YamlToken.MAPPING_START);
            }
            case 125: {
                if (minIndent == Integer.MAX_VALUE || context.keysCount() > 0) {
                    return this.dontRead();
                }
                return this.flowPop(YamlToken.MAPPING_START, '}');
            }
            case 91: {
                this.hasSequenceEntry = false;
                return this.flow(YamlToken.SEQUENCE_START);
            }
            case 93: {
                if (minIndent == Integer.MAX_VALUE) {
                    return this.dontRead();
                }
                return this.flowPop(YamlToken.SEQUENCE_START, ']');
            }
            case 44: {
                if (this.flowDepth >= this.contextSize()) {
                    this.flowDepth = this.contextSize();
                }
                this.hasSequenceEntry = false;
                return this.next0(minIndent);
            }
            case 58: {
                if (this.in.peekUnsignedByte() > 32) break;
                int pos = this.pushed.size();
                while (this.context() != YamlToken.MAPPING_KEY && this.contextSize() > 1) {
                    this.contextPop();
                }
                if (this.context() == YamlToken.MAPPING_KEY) {
                    this.contextPop();
                }
                this.reversePushed(pos);
                return this.pushed.isEmpty() ? this.next0(minIndent) : this.popPushed();
            }
            case 36: 
            case 40: 
            case 41: 
            case 43: 
            case 47: 
            case 59: 
            case 60: 
            case 61: 
            case 92: 
            case 94: 
            case 95: 
            case 126: {
                break;
            }
        }
        if (this.wouldChangeContext(minIndent, indent2)) {
            return this.dontRead();
        }
        this.unreadLast();
        return this.readText(indent2);
    }

    private boolean wouldChangeContext(int minIndent, int indent) {
        if (this.isInFlow()) {
            return false;
        }
        return minIndent > indent;
    }

    private YamlToken dontRead() {
        this.unreadLast();
        return YamlToken.NONE;
    }

    private YamlToken flowPop(YamlToken flowStartToken, char flowEndChar) {
        int pos = this.pushed.size();
        while (this.context() != flowStartToken) {
            if (this.contextSize() <= 1) {
                throw new IllegalArgumentException("Unexpected '" + flowEndChar + '\'');
            }
            this.contextPop();
        }
        this.contextPop();
        this.reversePushed(pos);
        return this.popPushed();
    }

    private YamlToken flow(YamlToken token) {
        this.pushed.add(token);
        if (!this.hasSequenceEntry && token != YamlToken.SEQUENCE_START && this.context() == YamlToken.SEQUENCE_START) {
            this.hasSequenceEntry = true;
            this.pushed.add(YamlToken.SEQUENCE_ENTRY);
        }
        this.contextPush(token, -1);
        if (this.flowDepth > this.contextSize()) {
            this.flowDepth = this.contextSize();
        }
        return this.popPushed();
    }

    private void readReserved() {
        throw new UnsupportedOperationException();
    }

    private void readDirective() {
        this.readWords();
    }

    private void readFolded() {
        this.readLiteral(false);
    }

    private Bytes<?> temp() {
        if (this.temp == null) {
            this.temp = Bytes.allocateElasticOnHeap((int)32);
        }
        this.temp.clear();
        return this.temp;
    }

    private void readLiteral() {
        this.readLiteral(true);
    }

    private void readLiteral(boolean withNewLines) {
        long length;
        this.readNewline();
        this.readIndent();
        int indent2 = Math.toIntExact(this.in.readPosition() - this.lineStart);
        this.blockEnd = -1L;
        this.blockStart = -1L;
        Bytes<?> temp = this.temp();
        long start = this.in.readPosition();
        while (true) {
            int ch;
            if ((ch = this.in.readUnsignedByte()) < 0) break;
            if (ch != 13 && ch != 10) continue;
            this.unreadLast();
            if (withNewLines) {
                this.readNewline();
            }
            length = this.in.readPosition() - start;
            temp.write((BytesStore)this.in, start, length);
            this.readIndent();
            int indent3 = Math.toIntExact(this.in.readPosition() - this.lineStart);
            if (indent3 < indent2) {
                return;
            }
            if (!withNewLines && temp.peekUnsignedByte(temp.writePosition() - 1L) > 32) {
                temp.append(' ');
            }
            if (indent3 > indent2) {
                this.in.readPosition(this.lineStart + (long)indent2);
            }
            start = this.in.readPosition();
        }
        length = this.in.readPosition() - start;
        temp.write((BytesStore)this.in, start, length);
    }

    private void readIndent() {
        int ch;
        while ((ch = this.in.peekUnsignedByte()) >= 0 && ch <= 32) {
            this.in.readSkip(1L);
            if (ch != 13 && ch != 10) continue;
            this.lineStart = this.in.readPosition();
        }
    }

    private void readNewline() {
        int ch;
        while ((ch = this.in.peekUnsignedByte()) >= 0 && ch < 32) {
            this.in.readSkip(1L);
            this.lineStart = this.in.readPosition();
        }
    }

    private YamlToken indent(YamlToken currentIndentedContextToken, @NotNull YamlToken keyDefinitionToken, @NotNull YamlToken nextTokenToParse, int currentIndentLevel) {
        if (nextTokenToParse != YamlToken.STREAM_START) {
            this.pushed.add(nextTokenToParse);
        }
        if (this.isInFlow()) {
            return keyDefinitionToken;
        }
        int pos = this.pushed.size();
        while (currentIndentLevel < this.contextIndent()) {
            this.contextPop();
        }
        int contextIndent = this.contextIndent();
        if (currentIndentedContextToken != null && currentIndentLevel != contextIndent) {
            this.pushed.add(currentIndentedContextToken);
        }
        this.pushed.add(keyDefinitionToken);
        this.reversePushed(pos);
        if (currentIndentedContextToken != null && currentIndentLevel > this.contextIndent()) {
            this.contextPush(currentIndentedContextToken, currentIndentLevel);
        }
        return this.popPushed();
    }

    private YamlToken readText(int currentIndentLevel) {
        long pos = this.in.readPosition();
        this.blockQuote = '\u0000';
        this.readWords();
        if (this.isFieldEnd()) {
            this.lastKeyPosition = pos;
            if (this.topContext().token != YamlToken.MAPPING_KEY) {
                return this.indent(YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.TEXT, currentIndentLevel);
            }
        }
        YamlToken token = YamlToken.TEXT;
        return this.seq(token);
    }

    private YamlToken seq(YamlToken token) {
        if (!this.hasSequenceEntry && this.context() == YamlToken.SEQUENCE_START && this.isInFlow()) {
            this.hasSequenceEntry = true;
            this.pushed.add(token);
            return YamlToken.SEQUENCE_ENTRY;
        }
        return token;
    }

    private void unreadLast() {
        this.in.readSkip(-1L);
    }

    private int contextIndent() {
        return this.contexts.isEmpty() ? 0 : this.topContext().indent;
    }

    private boolean isInFlow() {
        return this.contextSize() >= this.flowDepth;
    }

    void popAll(int downTo) {
        int pos = this.pushed.size();
        while (this.contextSize() > downTo) {
            this.contextPop();
        }
        this.reversePushed(pos);
    }

    private void reversePushed(int pos) {
        int i = pos;
        for (int j = this.pushed.size() - 1; i < j; ++i, --j) {
            this.pushed.set(i, this.pushed.set(j, this.pushed.get(i)));
        }
    }

    private YamlToken popPushed() {
        return this.pushed.isEmpty() ? this.next(Integer.MIN_VALUE) : this.pushed.remove(this.pushed.size() - 1);
    }

    private void readWord() {
        this.blockStart = this.in.readPosition();
        boolean isQuote = this.in.peekUnsignedByte() == 60;
        int ch = this.in.readUnsignedByte();
        do {
            if (ch <= 32 || !isQuote && ",{}:?'\"#".indexOf(ch) >= 0) {
                this.unreadLast();
                break;
            }
            this.blockEnd = this.in.readPosition();
            if (!isQuote || ch != 62) continue;
            ++this.blockStart;
            --this.blockEnd;
            break;
        } while ((ch = this.in.readUnsignedByte()) != -1);
    }

    private void readWords() {
        this.blockStart = this.in.readPosition();
        block6: while (this.in.readRemaining() > 0L) {
            int ch = this.in.readUnsignedByte();
            switch (ch) {
                case 58: {
                    if (this.in.peekUnsignedByte() > 32) continue block6;
                    this.unreadLast();
                    return;
                }
                case 44: {
                    if (this.context() != YamlToken.SEQUENCE_START && this.context() != YamlToken.MAPPING_START) continue block6;
                    this.unreadLast();
                    return;
                }
                case 91: {
                    long pos = this.in.readPosition();
                    if (this.in.peekUnsignedByte(pos - 2L) > 32 && this.in.peekUnsignedByte() == 93) {
                        this.in.readSkip(1L);
                        this.blockEnd = pos + 1L;
                        return;
                    }
                    this.unreadLast();
                    return;
                }
                case 10: 
                case 13: 
                case 35: 
                case 93: 
                case 123: 
                case 125: {
                    this.unreadLast();
                    return;
                }
            }
            if (ch <= 32) continue;
            this.blockEnd = this.in.readPosition();
        }
    }

    private void contextPop() {
        YamlToken toEnd;
        YTContext context0 = this.contexts.remove(this.contextSize() - 1);
        if (this.flowDepth > this.contextSize()) {
            this.flowDepth = Integer.MAX_VALUE;
        }
        if ((toEnd = context0.token.toEnd) == null) {
            throw new IllegalStateException("context: " + context0);
        }
        if (toEnd != YamlToken.NONE) {
            this.pushed.add(toEnd);
        }
        this.freeContexts.add(context0);
    }

    void revertToContext(int contextSize) {
        this.pushed.clear();
        while (this.contextSize() > contextSize) {
            YTContext context0 = this.contexts.remove(this.contextSize() - 1);
            if (this.flowDepth == this.contextSize()) {
                this.flowDepth = Integer.MAX_VALUE;
            }
            this.freeContexts.add(context0);
        }
    }

    private void contextPush(YamlToken context, int indent) {
        if (this.context() == YamlToken.STREAM_START && context != YamlToken.DIRECTIVES_END) {
            this.pushContext0(YamlToken.DIRECTIVES_END, -1);
            this.pushContext0(context, indent);
            this.push(YamlToken.DIRECTIVES_END);
            return;
        }
        this.pushContext0(context, indent);
    }

    private void readDoublyQuoted() {
        this.blockQuote = (char)34;
        this.blockStart = this.in.readPosition();
        while (this.in.readRemaining() > 0L) {
            int ch = this.in.readUnsignedByte();
            if (ch == 92) {
                ch = this.in.readUnsignedByte();
            } else if (ch == this.blockQuote) {
                this.blockEnd = this.in.readPosition() - 1L;
                return;
            }
            if (ch >= 0) continue;
            throw new IllegalStateException("Unterminated quotes " + this.in.subBytes(this.blockStart - 1L, this.in.readPosition()));
        }
    }

    private void readSinglyQuoted() {
        this.blockQuote = (char)39;
        this.blockStart = this.in.readPosition();
        while (this.in.readRemaining() > 0L) {
            int ch = this.in.readUnsignedByte();
            if (ch == this.blockQuote) {
                int ch2 = this.in.peekUnsignedByte();
                if (ch2 == this.blockQuote) {
                    this.in.readSkip(1L);
                    continue;
                }
                this.blockEnd = this.in.readPosition() - 1L;
                return;
            }
            if (ch >= 0) continue;
            throw new IllegalStateException("Unterminated quotes " + this.in.subBytes(this.blockStart - 1L, this.in.readPosition()));
        }
    }

    private boolean isFieldEnd() {
        this.consumeSpaces();
        if (this.in.peekUnsignedByte() == 58) {
            int ch = this.in.peekUnsignedByte(this.in.readPosition() + 1L);
            this.in.readSkip(ch == 9 || ch == 32 ? 2L : 1L);
            return true;
        }
        return false;
    }

    private void readComment() {
        this.consumeSpaces();
        this.blockStart = this.blockEnd = this.in.readPosition();
        int ch;
        while ((ch = this.in.readUnsignedByte()) >= 0) {
            if (ch == 10 || ch == 13) {
                this.unreadLast();
                return;
            }
            if (ch <= 32) continue;
            this.blockEnd = this.in.readPosition();
        }
        return;
    }

    private void consumeSpaces() {
        int ch;
        while ((ch = this.in.peekUnsignedByte()) == 32 || ch == 9) {
            this.in.readSkip(1L);
        }
    }

    private void consumeWhitespace() {
        int ch;
        while ((ch = this.in.peekUnsignedByte()) >= 0 && ch <= 32) {
            this.in.readSkip(1L);
            if (ch != 10 && ch != 13) continue;
            this.lineStart = this.in.readPosition();
        }
    }

    public long lineStart() {
        return this.lineStart;
    }

    public void lineStart(long lineStart) {
        this.lineStart = lineStart;
    }

    public long blockStart() {
        return this.blockStart;
    }

    public long blockEnd() {
        return this.blockEnd;
    }

    private void pushContext0(YamlToken token, int indent) {
        YTContext context = this.freeContexts.isEmpty() ? new YTContext() : this.freeContexts.remove(this.freeContexts.size() - 1);
        context.token = token;
        context.indent = indent;
        if (context.keys != null) {
            context.keys.reset();
        }
        this.contexts.add(context);
    }

    public String toString() {
        String name = this.last.name();
        return (Object)((Object)this.last) + " " + (this.blockQuote == '\u0000' || name.endsWith("_START") || name.endsWith("_END") ? "" : this.blockQuote + " ") + this.text();
    }

    public char blockQuote() {
        return this.blockQuote;
    }

    public String text() {
        try (ScopedResource sbTl = SBP.get();){
            StringBuilder sb = (StringBuilder)sbTl.get();
            this.text(sb);
            String string = sb.length() == 0 ? "" : sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void text(StringBuilder outputBuilder) {
        if (this.blockEnd < 0L && this.temp != null) {
            outputBuilder.append((CharSequence)this.temp);
            return;
        }
        outputBuilder.setLength(0);
        if (this.blockStart == this.blockEnd || NO_TEXT.contains((Object)this.last)) {
            return;
        }
        long pos = this.in.readPosition();
        try {
            this.in.readPosition(this.blockStart);
            this.in.parseUtf8((Appendable)outputBuilder, Math.toIntExact(this.blockEnd - this.blockStart));
        }
        finally {
            this.in.readPosition(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double parseDouble() {
        if (this.blockEnd < 0L && this.temp != null) {
            return this.temp.parseDouble();
        }
        if (this.blockStart == this.blockEnd || NO_TEXT.contains((Object)this.last)) {
            return -0.0;
        }
        long pos = this.in.readPosition();
        try {
            this.in.readPosition(this.blockStart);
            double d = this.in.parseDouble();
            return d;
        }
        finally {
            this.in.readPosition(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long parseLong() {
        if (this.blockEnd < 0L && this.temp != null) {
            return this.temp.parseLong();
        }
        if (this.blockStart == this.blockEnd || NO_TEXT.contains((Object)this.last)) {
            return 0L;
        }
        long pos = this.in.readPosition();
        try {
            block26: {
                this.in.readPosition(this.blockStart);
                if (this.in.peekUnsignedByte() == 48) {
                    long l;
                    int i = this.in.peekUnsignedByte(this.in.readPosition() + 1L);
                    try (ScopedResource sbTl = SBP.get();){
                        StringBuilder sb = (StringBuilder)sbTl.get();
                        if (Character.isDigit(i)) {
                            this.in.readSkip(1L);
                            this.in.parseUtf8((Appendable)sb, Math.toIntExact(this.blockEnd - this.blockStart) - 1);
                            long l2 = Long.parseLong(sb.toString(), 8);
                            return l2;
                        }
                        if (i != 111) break block26;
                        this.in.readSkip(2L);
                        this.in.parseUtf8((Appendable)sb, Math.toIntExact(this.blockEnd - this.blockStart) - 2);
                        l = Long.parseLong(sb.toString(), 8);
                    }
                    return l;
                }
            }
            long l = this.in.parseLong();
            return l;
        }
        finally {
            this.in.readPosition(pos);
        }
    }

    public void push(YamlToken token) {
        this.pushed.add(token);
    }

    public boolean isText(String s) {
        return this.text().equals(s);
    }

    public YamlKeys keys() {
        YTContext context = this.topContext();
        YamlKeys key = context.keys;
        if (key == null) {
            context.keys = new YamlKeys();
            return context.keys;
        }
        return key;
    }

    public void rereadFrom(long offset) {
        this.lineStart = offset;
        this.pushed.clear();
    }

    static class YTContext
    extends SelfDescribingMarshallable {
        YamlToken token;
        int indent;
        YamlKeys keys = null;

        YTContext() {
        }

        int keysCount() {
            return this.keys == null ? 0 : this.keys.count;
        }
    }
}

