/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public enum YamlLogging {

    @NotNull
    public static volatile String title = "";
    private static volatile boolean showServerWrites = Jvm.getBoolean((String)"yaml.logging");
    private static volatile boolean clientWrites = Jvm.getBoolean((String)"yaml.logging");
    @NotNull
    private static volatile String writeMessage = "";
    private static volatile boolean clientReads = Jvm.getBoolean((String)"yaml.logging");
    private static volatile boolean showServerReads = Jvm.getBoolean((String)"yaml.logging");
    private static volatile boolean showHeartBeats = false;

    public static void setAll(boolean flag) {
        clientWrites = clientReads = flag;
        showServerWrites = clientReads;
        showServerReads = clientReads;
    }

    public static void setAll(@NotNull YamlLoggingLevel level) {
        clientWrites = clientReads = level.isSet();
        showServerWrites = clientReads;
        showServerReads = clientReads;
    }

    public static boolean showClientReads() {
        return clientReads;
    }

    public static void writeMessage(@NotNull String message) {
        writeMessage = message;
    }

    public static void showServerWrites(boolean flag) {
        showServerWrites = flag;
    }

    public static boolean showClientWrites() {
        return clientWrites;
    }

    @NotNull
    public static String writeMessage() {
        return writeMessage;
    }

    public static boolean showHeartBeats() {
        return showHeartBeats;
    }

    public static boolean showServerReads() {
        return showServerReads;
    }

    public static void showHeartBeats(boolean flag) {
        showHeartBeats = flag;
    }

    public static void showClientWrites(boolean flag) {
        clientWrites = flag;
    }

    public static void showClientReads(boolean flag) {
        clientReads = flag;
    }

    public static boolean showServerWrites() {
        return showServerWrites;
    }

    public static void showServerReads(boolean flag) {
        showServerReads = flag;
    }

    public static enum YamlLoggingLevel {
        OFF{

            @Override
            public boolean isSet() {
                return false;
            }
        }
        ,
        DEBUG_ONLY{

            @Override
            public boolean isSet() {
                return Jvm.isDebug();
            }
        }
        ,
        ON{

            @Override
            public boolean isSet() {
                return true;
            }
        };


        public abstract boolean isSet();
    }
}

