/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import org.jetbrains.annotations.NotNull;

class ValueInState {
    private static final long[] EMPTY_ARRAY = new long[0];
    private long savedPosition;
    private int unexpectedSize;
    private long savedValue;
    @NotNull
    private long[] unexpected = EMPTY_ARRAY;

    ValueInState() {
    }

    public void reset() {
        this.savedPosition = 0L;
        this.unexpectedSize = 0;
        this.savedValue = Long.MIN_VALUE;
    }

    public void addUnexpected(long wirePosition) {
        if (this.unexpectedSize >= this.unexpected.length) {
            int newSize = this.unexpected.length * 3 / 2 + 8;
            @NotNull long[] unexpected2 = new long[newSize];
            System.arraycopy(this.unexpected, 0, unexpected2, 0, this.unexpected.length);
            this.unexpected = unexpected2;
        }
        this.unexpected[this.unexpectedSize++] = wirePosition;
    }

    public void savedPosition(long savedPosition) {
        this.savedPosition = savedPosition;
    }

    public long savedPosition() {
        return this.savedPosition;
    }

    public int unexpectedSize() {
        return this.unexpectedSize;
    }

    public long unexpected(int index) {
        return this.unexpected[index];
    }

    public void savedValue(long savedValue) {
        this.savedValue = savedValue;
    }

    public long savedValue() {
        return this.savedValue;
    }

    public void removeUnexpected(int i) {
        int length = this.unexpectedSize - i - 1;
        if (length > 0) {
            System.arraycopy(this.unexpected, i + 1, this.unexpected, i, length);
        }
        --this.unexpectedSize;
    }
}

