/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.text.MessageFormat;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.converter.PowerOfTwoLongConverter;
import net.openhft.chronicle.wire.converter.SymbolsLongConverter;

public interface LongConverter {
    public static LongConverter forSymbols(String chars) {
        return Maths.isPowerOf2((long)chars.length()) ? new PowerOfTwoLongConverter(chars) : new SymbolsLongConverter(chars);
    }

    public static int maxParseLength(int based) {
        return (int)Math.ceil(64.0 / Math.log(based) * Math.log(2.0));
    }

    public long parse(CharSequence var1);

    default public long parse(CharSequence textToParse, int beginIndex, int endIndex) {
        return this.parse(textToParse.toString().substring(beginIndex, endIndex));
    }

    public void append(StringBuilder var1, long var2);

    default public void append(Bytes<?> destination, long numericValue) {
        try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
            StringBuilder sb = (StringBuilder)stlSb.get();
            this.append(sb, numericValue);
            destination.append((CharSequence)sb);
        }
    }

    default public String asString(long numericValue) {
        return this.asText(numericValue).toString();
    }

    default public CharSequence asText(int numericValue) {
        return this.asText((long)numericValue & 0xFFFFFFFFL);
    }

    default public CharSequence asText(long numericValue) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, numericValue);
        return sb;
    }

    default public int maxParseLength() {
        return Integer.MAX_VALUE;
    }

    default public void lengthCheck(CharSequence textToCheck) {
        if (textToCheck.length() > this.maxParseLength()) {
            throw new IllegalArgumentException(MessageFormat.format("text={0} exceeds the maximum allowable length of {1}", textToCheck, this.maxParseLength()));
        }
    }

    default public void lengthCheck(CharSequence textToCheck, int beginIndex, int endIndex) {
        if ((beginIndex | endIndex | endIndex - beginIndex | textToCheck.length() - endIndex + beginIndex | this.maxParseLength() - endIndex + beginIndex) < 0) {
            throw new IllegalArgumentException(MessageFormat.format("range [{0}, {1}) exceeds the maximum allowable length of {2}", beginIndex, endIndex, this.maxParseLength()));
        }
    }

    default public boolean allSafeChars() {
        return true;
    }

    default public void addEncode(char alias, char as) {
        throw new UnsupportedOperationException();
    }
}

