/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.Nullable;

public class TextReadDocumentContext
implements ReadDocumentContext {
    public static final BytesStore<?, ?> SOD_SEP = BytesStore.from((String)"---");
    public static final BytesStore<?, ?> EOD_SEP = BytesStore.from((String)"...");
    @Nullable
    protected Wire wire;
    protected boolean present;
    protected boolean notComplete;
    private boolean metaData;
    private long readPosition;
    private long readLimit;
    private long start = -1L;
    private boolean rollback;

    public TextReadDocumentContext(@Nullable Wire wire) {
        this.wire = wire;
    }

    public static void consumeToEndOfMessage(Bytes<?> bytes) {
        while (bytes.readRemaining() > 0L) {
            while (bytes.readRemaining() > 0L && bytes.readUnsignedByte() >= 32) {
            }
            if (!TextReadDocumentContext.isEndOfMessage(bytes)) continue;
            break;
        }
    }

    public static boolean isEndOfMessage(Bytes<?> bytes) {
        return (bytes.startsWith(SOD_SEP) || bytes.startsWith(EOD_SEP)) && TextReadDocumentContext.isWhiteSpaceAt(bytes);
    }

    protected static boolean isWhiteSpaceAt(Bytes<?> bytes) {
        return bytes.peekUnsignedByte(bytes.readPosition() + 3L) <= 32;
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void closeReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    @Override
    public void closeReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    @Override
    @Nullable
    public Wire wire() {
        return this.wire;
    }

    @Override
    public void close() {
        long readLimit = this.readLimit;
        long readPosition = this.readPosition;
        Wire wire0 = this.wire;
        Bytes<?> bytes = wire0.bytes();
        bytes.readLimit(readLimit);
        if (this.rollback) {
            if (this.start > -1L) {
                bytes.readPosition(this.start);
            }
            this.rollback = false;
        } else {
            bytes.readPosition(readPosition);
            if (TextReadDocumentContext.isEndOfMessage(bytes)) {
                bytes.readSkip(3L);
            }
            while (!bytes.isEmpty() && bytes.peekUnsignedByte() <= 32) {
                bytes.readSkip(1L);
            }
        }
        this.start = -1L;
        this.wire.getValueIn().resetState();
        this.present = false;
    }

    @Override
    public void reset() {
        this.close();
        this.readLimit = 0L;
        this.readPosition = 0L;
        this.start = -1L;
        this.present = false;
        this.notComplete = false;
        this.rollback = false;
    }

    @Override
    public void start() {
        this.wire.getValueIn().resetState();
        Bytes<?> bytes = this.wire.bytes();
        this.present = false;
        this.wire.consumePadding();
        while (TextReadDocumentContext.isEndOfMessage(bytes)) {
            this.skipSep(bytes);
        }
        if (bytes.readRemaining() < 1L) {
            this.readLimit = this.readPosition = bytes.readLimit();
            this.notComplete = false;
            return;
        }
        this.metaData = this.wire.hasMetaDataPrefix();
        this.start = bytes.readPosition();
        TextReadDocumentContext.consumeToEndOfMessage(bytes);
        this.readLimit = bytes.readLimit();
        this.readPosition = bytes.readPosition();
        bytes.readLimit(bytes.readPosition());
        bytes.readPosition(this.start);
        this.present = true;
    }

    protected void skipSep(Bytes<?> bytes) {
        bytes.readSkip(3L);
        this.wire.getValueIn().resetState();
        this.wire.consumePadding();
    }

    @Override
    public void rollbackOnClose() {
        this.rollback = true;
    }

    @Override
    public long index() {
        return this.readPosition;
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return this.notComplete;
    }

    public String toString() {
        return Objects.toString(this.wire);
    }
}

