/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.extractor;

import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.domestic.extractor.DocumentExtractor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocumentExtractorUtil {
    private DocumentExtractorUtil() {
    }

    public static <I, E> DocumentExtractor<E> ofMethod(@NotNull Class<I> type, @NotNull BiConsumer<? super I, ? super E> methodReference, @Nullable Supplier<? extends E> supplier) {
        MethodNameAndMessageType<E> info = DocumentExtractorUtil.methodOf(type, methodReference);
        String expectedEventName = info.name();
        Class elementType = info.messageType();
        StringBuilder eventName = new StringBuilder();
        return (wire, index) -> {
            wire.startEvent();
            try {
                Bytes<?> bytes = wire.bytes();
                while (bytes.readRemaining() > 0L) {
                    if (wire.isEndEvent()) {
                    } else {
                        long start = bytes.readPosition();
                        wire.readEventName(eventName);
                        if (StringUtils.isEqual((CharSequence)expectedEventName, (CharSequence)eventName)) {
                            Object using = supplier.get();
                            Object t = wire.getValueIn().object(using, elementType);
                            return t;
                        }
                        wire.consumePadding();
                        if (bytes.readPosition() != start) continue;
                    }
                    break;
                }
            }
            finally {
                wire.endEvent();
            }
            return null;
        };
    }

    public static <I, M> MethodNameAndMessageType<M> methodOf(@NotNull Class<I> type, @NotNull BiConsumer<? super I, ? super M> methodReference) {
        AtomicReference method = new AtomicReference();
        Class[] interfaces = new Class[]{type};
        Object proxy = Proxy.newProxyInstance(type.getClassLoader(), interfaces, (p, m, args) -> {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The provided method reference does not take exactly one parameter");
            }
            String methodName = m.getName();
            Class<?> messageType = m.getParameters()[0].getType();
            method.set(new MethodNameAndMessageType(methodName, messageType));
            return p;
        });
        methodReference.accept(proxy, null);
        return (MethodNameAndMessageType)ObjectUtils.requireNonNull(method.get());
    }

    public static final class MethodNameAndMessageType<M> {
        private final String name;
        private final Class<M> messageType;

        public MethodNameAndMessageType(@NotNull String name, @NotNull Class<M> messageType) {
            this.name = name;
            this.messageType = messageType;
        }

        public String name() {
            return this.name;
        }

        public Class<M> messageType() {
            return this.messageType;
        }
    }
}

