/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import java.util.function.Supplier;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;

public class ChronicleChannelSupplier
extends ChronicleChannelCfg<ChronicleChannelSupplier>
implements Supplier<ChronicleChannel> {
    private final transient ChronicleContext context;
    private final ChannelHandler handler;
    private String protocol;
    private String connectionId;

    public ChronicleChannelSupplier(ChronicleContext context, ChannelHandler handler) {
        this.context = context;
        this.handler = handler;
    }

    @Override
    public ChronicleChannel get() {
        ChronicleChannel channel;
        this.handler.systemContext(this.context.systemContext());
        if (this.connectionId != null && this.handler.sessionName() == null) {
            this.handler.sessionName(this.connectionId);
        }
        switch (this.protocol) {
            case "tcp": {
                channel = ChronicleChannel.newChannel(this.context.socketRegistry(), this, this.handler, this.context.closeCallback());
                break;
            }
            case "internal": {
                channel = this.handler.asInternalChannel(this.context, this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported protocol " + this.protocol);
            }
        }
        this.context.addCloseable(channel);
        return channel;
    }

    public String protocol() {
        return this.protocol;
    }

    public ChronicleChannelSupplier protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public ChronicleChannelSupplier connectionId(String connectionId) {
        this.connectionId = connectionId;
        return this;
    }
}

