/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytesDescription;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.Resettable;
import net.openhft.chronicle.core.io.SingleThreadedChecked;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.util.ClassLocal;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.AbstractCommonMarshallable;
import net.openhft.chronicle.wire.AsMarshallable;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.CommentAnnotationNotifier;
import net.openhft.chronicle.wire.DynamicEnum;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.UnexpectedFieldHandlingException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireMarshallerForUnexpectedFields;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireMarshaller<T> {
    private static final Class[] UNEXPECTED_FIELDS_PARAMETER_TYPES = new Class[]{Object.class, ValueIn.class};
    private static final FieldAccess[] NO_FIELDS = new FieldAccess[0];
    private static Method isRecord;
    @NotNull
    final FieldAccess[] fields;
    final TreeMap<CharSequence, FieldAccess> fieldMap = new TreeMap(WireMarshaller::compare);
    private final boolean isLeaf;
    @Nullable
    private final T defaultValue;
    public static final ClassLocal<WireMarshaller> WIRE_MARSHALLER_CL;

    protected WireMarshaller(@NotNull Class<T> tClass, @NotNull FieldAccess[] fields, boolean isLeaf) {
        this(fields, isLeaf, WireMarshaller.defaultValueForType(tClass));
    }

    WireMarshaller(@NotNull FieldAccess[] fields, boolean isLeaf, @Nullable T defaultValue) {
        this.fields = fields;
        this.isLeaf = isLeaf;
        this.defaultValue = defaultValue;
        for (FieldAccess field : fields) {
            this.fieldMap.put(field.key.name(), field);
        }
    }

    @NotNull
    public static <T> WireMarshaller<T> of(@NotNull Class<T> tClass) {
        if (tClass.isInterface() || tClass.isEnum() && !DynamicEnum.class.isAssignableFrom(tClass)) {
            return new WireMarshaller<T>(tClass, NO_FIELDS, true);
        }
        Object defaultObject = WireMarshaller.defaultValueForType(tClass);
        @NotNull LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        WireMarshaller.getAllField(tClass, map);
        FieldAccess[] fields = (FieldAccess[])map.values().stream().filter(field -> !Jvm.isJava15Plus() || !field.getName().matches("^.*\\$\\d+$")).map(field -> FieldAccess.create(field, defaultObject)).toArray(FieldAccess[]::new);
        Map<String, Long> fieldCount = Stream.of(fields).collect(Collectors.groupingBy(f -> f.field.getName(), Collectors.counting()));
        fieldCount.forEach((n, c) -> {
            if (c > 1L) {
                Jvm.warn().on(tClass, "Has " + c + " fields called '" + n + "'");
            }
        });
        List collect = Stream.of(fields).filter(WireMarshaller::leafable).collect(Collectors.toList());
        boolean isLeaf = collect.isEmpty();
        return WireMarshaller.overridesUnexpectedFields(tClass) ? new WireMarshallerForUnexpectedFields<T>(fields, isLeaf, defaultObject) : new WireMarshaller<T>(fields, isLeaf, defaultObject);
    }

    protected static boolean leafable(FieldAccess c) {
        Class<?> type = c.field.getType();
        if (WireMarshaller.isCollection(type)) {
            return !Boolean.TRUE.equals(c.isLeaf);
        }
        if (DynamicEnum.class.isAssignableFrom(type)) {
            return false;
        }
        return WriteMarshallable.class.isAssignableFrom(type);
    }

    private static <T> boolean overridesUnexpectedFields(Class<T> tClass) {
        try {
            Method method = tClass.getMethod("unexpectedField", UNEXPECTED_FIELDS_PARAMETER_TYPES);
            return method.getDeclaringClass() != ReadMarshallable.class;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @NotNull
    private static <T> WireMarshaller<T> ofThrowable(@NotNull Class<T> tClass) {
        Object defaultObject = WireMarshaller.defaultValueForType(tClass);
        @NotNull LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        WireMarshaller.getAllField(tClass, map);
        FieldAccess[] fields = (FieldAccess[])map.values().stream().map(field -> FieldAccess.create(field, defaultObject)).toArray(FieldAccess[]::new);
        boolean isLeaf = false;
        return new WireMarshaller<T>(fields, isLeaf, defaultObject);
    }

    private static boolean isCollection(@NotNull Class<?> c) {
        return c.isArray() || Collection.class.isAssignableFrom(c) || Map.class.isAssignableFrom(c);
    }

    public static void getAllField(@NotNull Class clazz, @NotNull Map<String, Field> map) {
        if (clazz != Object.class && clazz != AbstractCommonMarshallable.class) {
            WireMarshaller.getAllField(clazz.getSuperclass(), map);
        }
        for (Field field : clazz.getDeclaredFields()) {
            String fieldName;
            if ((field.getModifiers() & 0x88) != 0 || ("ordinal".equals(fieldName = field.getName()) || "hash".equals(fieldName)) && Enum.class.isAssignableFrom(clazz)) continue;
            String name = fieldName;
            if (name.startsWith("this$0")) {
                if (!ValidatableUtil.validateEnabled()) continue;
                Jvm.warn().on(WireMarshaller.class, "Found " + name + ", in " + clazz + " which will be ignored!");
                continue;
            }
            Jvm.setAccessible((AccessibleObject)field);
            map.put(name, field);
        }
    }

    static <T> T defaultValueForType(@NotNull Class<T> tClass) {
        if (ObjectUtils.isConcreteClass(tClass) && !tClass.getName().startsWith("java") && !tClass.isEnum() && !tClass.isArray()) {
            Object t = ObjectUtils.newInstance(tClass);
            IOTools.unmonitor((Object)t);
            return (T)t;
        }
        if (DynamicEnum.class.isAssignableFrom(tClass)) {
            try {
                Object t = OS.memory().allocateInstance(tClass);
                Jvm.getField(Enum.class, (String)"name").set(t, "[unset]");
                Jvm.getField(Enum.class, (String)"ordinal").set(t, -1);
                IOTools.unmonitor((Object)t);
                return (T)t;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    private static int compare(CharSequence cs0, CharSequence cs1) {
        int len = Math.min(cs0.length(), cs1.length());
        for (int i = 0; i < len; ++i) {
            int cmp = Character.compare(cs0.charAt(i), cs1.charAt(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(cs0.length(), cs1.length());
    }

    private static Type[] computeActualTypeArguments(Class iface, Field field) {
        Type[] actual = WireMarshaller.consumeActualTypeArguments(new HashMap<String, Type>(), iface, field.getGenericType());
        if (actual == null) {
            return iface.getTypeParameters();
        }
        return actual;
    }

    private static Type[] consumeActualTypeArguments(Map<String, Type> prevTypeParameters, Class iface, Type type) {
        Class cls = null;
        HashMap<String, Type> typeParameters = new HashMap<String, Type>();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] typeArguments = pType.getActualTypeArguments();
            cls = (Class)((ParameterizedType)type).getRawType();
            TypeVariable<Class<T>>[] typeParamDecls = cls.getTypeParameters();
            for (int i = 0; i < Math.min(typeParamDecls.length, typeArguments.length); ++i) {
                Object value;
                if (typeArguments[i] instanceof TypeVariable) {
                    value = prevTypeParameters.get(((TypeVariable)typeArguments[i]).getName());
                    if (value == null) {
                        Type[] bounds = ((TypeVariable)typeArguments[i]).getBounds();
                        value = bounds.length == 0 ? Object.class : bounds[0];
                    }
                } else {
                    value = typeArguments[i];
                }
                typeParameters.put(typeParamDecls[i].getName(), (Type)value);
            }
        } else if (type instanceof Class) {
            cls = (Class)type;
        }
        if (iface.equals(cls)) {
            TypeVariable<Class<T>>[] parameters = iface.getTypeParameters();
            Type[] result = new Type[parameters.length];
            for (int i = 0; i < result.length; ++i) {
                TypeVariable parameter = (TypeVariable)typeParameters.get(parameters[i].getName());
                result[i] = parameter != null ? parameter : parameters[i];
            }
            return result;
        }
        if (cls != null) {
            for (Type ifaceType : cls.getGenericInterfaces()) {
                Type[] result = WireMarshaller.consumeActualTypeArguments(typeParameters, iface, ifaceType);
                if (result == null) continue;
                return result;
            }
            return WireMarshaller.consumeActualTypeArguments(typeParameters, iface, cls.getGenericSuperclass());
        }
        return null;
    }

    public WireMarshaller<T> excludeFields(String ... fieldNames) {
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fieldNames));
        return new WireMarshaller<T>((FieldAccess[])Stream.of(this.fields).filter(f -> !fieldSet.contains(f.field.getName())).toArray(FieldAccess[]::new), this.isLeaf, this.defaultValue);
    }

    public void writeMarshallable(T t, @NotNull WireOut out) throws InvalidMarshallableException {
        ValidatableUtil.validate(t);
        HexDumpBytesDescription<?> bytes = out.bytesComment();
        bytes.adjustHexDumpIndentation(1);
        try {
            for (FieldAccess field : this.fields) {
                field.write(t, out);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        bytes.adjustHexDumpIndentation(-1);
    }

    public void writeMarshallable(T t, Bytes<?> bytes) {
        for (FieldAccess field : this.fields) {
            try {
                field.getAsBytes(t, bytes);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Deprecated
    public void writeMarshallable(T t, @NotNull WireOut out, T ignored, boolean copy) throws InvalidMarshallableException {
        this.writeMarshallable(t, out, copy);
    }

    public void writeMarshallable(T t, @NotNull WireOut out, boolean copy) throws InvalidMarshallableException {
        ValidatableUtil.validate(t);
        try {
            for (FieldAccess field : this.fields) {
                field.write(t, out, this.defaultValue, copy);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public void readMarshallable(T t, @NotNull WireIn in, T ignored, boolean overwrite) throws InvalidMarshallableException {
        this.readMarshallable(t, in, overwrite);
    }

    public void readMarshallable(T t, @NotNull WireIn in, boolean overwrite) throws InvalidMarshallableException {
        if (in.hintReadInputOrder()) {
            this.readMarshallableInputOrder(t, in, overwrite);
        } else {
            this.readMarshallableDTOOrder(t, in, overwrite);
        }
        ValidatableUtil.validate(t);
    }

    @Deprecated
    public void readMarshallableDTOOrder(T t, @NotNull WireIn in, T ignored, boolean overwrite) throws InvalidMarshallableException {
        this.readMarshallableDTOOrder(t, in, overwrite);
    }

    public void readMarshallableDTOOrder(T t, @NotNull WireIn in, boolean overwrite) throws InvalidMarshallableException {
        try {
            for (FieldAccess field : this.fields) {
                ValueIn vin = in.read(field.key);
                field.readValue(t, this.defaultValue, vin, overwrite);
            }
            ValidatableUtil.validate(t);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public void readMarshallableInputOrder(T t, @NotNull WireIn in, T ignored, boolean overwrite) throws InvalidMarshallableException {
        this.readMarshallableDTOOrder(t, in, overwrite);
    }

    public void readMarshallableInputOrder(T t, @NotNull WireIn in, boolean overwrite) throws InvalidMarshallableException {
        try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
            StringBuilder sb = (StringBuilder)stlSb.get();
            for (int i = 0; i < this.fields.length; ++i) {
                ValueIn vin;
                boolean more = in.hasMore();
                FieldAccess field = this.fields[i];
                ValueIn valueIn = vin = more ? in.read(sb) : null;
                if (more && this.matchesFieldName(sb, field)) {
                    field.readValue(t, this.defaultValue, in.getValueIn(), overwrite);
                    continue;
                }
                while (i < this.fields.length) {
                    FieldAccess field2 = this.fields[i];
                    field2.setDefaultValue(this.defaultValue, t);
                    ++i;
                }
                if (vin == null || sb.length() <= 0) {
                    return;
                }
                do {
                    FieldAccess fieldAccess;
                    if ((fieldAccess = this.fieldMap.get(sb)) == null) {
                        vin.skipValue();
                    } else {
                        fieldAccess.readValue(t, this.defaultValue, vin, overwrite);
                    }
                    vin = in.read(sb);
                } while (in.hasMore());
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean matchesFieldName(StringBuilder sb, FieldAccess field) {
        return sb.length() == 0 || StringUtils.equalsCaseIgnore((CharSequence)field.field.getName(), (CharSequence)sb);
    }

    public void writeKey(T t, Bytes<?> bytes) {
        try {
            this.fields[0].getAsBytes(t, bytes);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isEqual(Object o1, Object o2) {
        for (FieldAccess field : this.fields) {
            if (field.isEqual(o1, o2)) continue;
            return false;
        }
        return true;
    }

    public Object getField(Object o, String name) throws NoSuchFieldException {
        try {
            FieldAccess field = this.fieldMap.get(name);
            if (field == null) {
                throw new NoSuchFieldException(name);
            }
            return field.field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getLongField(@NotNull Object o, String name) throws NoSuchFieldException {
        try {
            FieldAccess field = this.fieldMap.get(name);
            if (field == null) {
                throw new NoSuchFieldException(name);
            }
            Field field2 = field.field;
            return field2.getType() == Long.TYPE ? field2.getLong(o) : (field2.getType() == Integer.TYPE ? (long)field2.getInt(o) : (Long)ObjectUtils.convertTo(Long.class, (Object)field2.get(o)));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setField(Object o, String name, Object value) throws NoSuchFieldException {
        try {
            FieldAccess field = this.fieldMap.get(name);
            if (field == null) {
                throw new NoSuchFieldException(name);
            }
            @NotNull Field field2 = field.field;
            value = ObjectUtils.convertTo(field2.getType(), (Object)value);
            field2.set(o, value);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setLongField(Object o, String name, long value) throws NoSuchFieldException {
        try {
            FieldAccess field = this.fieldMap.get(name);
            if (field == null) {
                throw new NoSuchFieldException(name);
            }
            @NotNull Field field2 = field.field;
            if (field2.getType() == Long.TYPE) {
                field2.setLong(o, value);
            } else if (field2.getType() == Integer.TYPE) {
                field2.setInt(o, (int)value);
            } else {
                field2.set(o, ObjectUtils.convertTo(field2.getType(), (Object)value));
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    public T defaultValue() {
        return this.defaultValue;
    }

    public void reset(T o) {
        try {
            for (FieldAccess field : this.fields) {
                field.setDefaultValue(this.defaultValue, o);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    static {
        if (Jvm.isJava14Plus()) {
            try {
                isRecord = Jvm.getMethod(Class.class, (String)"isRecord", (Class[])new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        WIRE_MARSHALLER_CL = ClassLocal.withInitial(tClass -> Throwable.class.isAssignableFrom((Class<?>)tClass) ? WireMarshaller.ofThrowable(tClass) : WireMarshaller.of(tClass));
    }

    static class DoubleFieldAccess
    extends FieldAccess {
        DoubleFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            if (previous == null) {
                write.float64(UnsafeMemory.unsafeGetDouble((Object)o, (long)this.offset));
            } else {
                write.float64(UnsafeMemory.unsafeGetDouble((Object)o, (long)this.offset), UnsafeMemory.unsafeGetDouble((Object)previous, (long)this.offset));
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            double v = overwrite ? read.float64() : read.float64(UnsafeMemory.unsafeGetDouble((Object)o, (long)this.offset));
            UnsafeMemory.unsafePutDouble((Object)o, (long)this.offset, (double)v);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeDouble(UnsafeMemory.unsafeGetDouble((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return Maths.same((double)UnsafeMemory.unsafeGetDouble((Object)o, (long)this.offset), (double)UnsafeMemory.unsafeGetDouble((Object)o2, (long)this.offset));
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.unsafePutDouble((Object)to, (long)this.offset, (double)UnsafeMemory.unsafeGetDouble((Object)from, (long)this.offset));
        }
    }

    static class LongFieldAccess
    extends FieldAccess {
        LongFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            if (previous == null) {
                write.int64(UnsafeMemory.unsafeGetLong((Object)o, (long)this.offset));
            } else {
                write.int64(UnsafeMemory.unsafeGetLong((Object)o, (long)this.offset), UnsafeMemory.unsafeGetLong((Object)previous, (long)this.offset));
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            long i = overwrite ? read.int64() : read.int64(UnsafeMemory.unsafeGetLong((Object)o, (long)this.offset));
            UnsafeMemory.unsafePutLong((Object)o, (long)this.offset, (long)i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeLong(UnsafeMemory.unsafeGetLong((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.unsafeGetLong((Object)o, (long)this.offset) == UnsafeMemory.unsafeGetLong((Object)o2, (long)this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.unsafePutLong((Object)to, (long)this.offset, (long)UnsafeMemory.unsafeGetLong((Object)from, (long)this.offset));
        }
    }

    static class FloatFieldAccess
    extends FieldAccess {
        FloatFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            if (previous == null) {
                write.float32(UnsafeMemory.unsafeGetFloat((Object)o, (long)this.offset));
            } else {
                write.float32(UnsafeMemory.unsafeGetFloat((Object)o, (long)this.offset), UnsafeMemory.unsafeGetFloat((Object)previous, (long)this.offset));
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            float v = overwrite ? read.float32() : read.float32(UnsafeMemory.unsafeGetFloat((Object)o, (long)this.offset));
            UnsafeMemory.unsafePutFloat((Object)o, (long)this.offset, (float)v);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeFloat(UnsafeMemory.unsafeGetFloat((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return Maths.same((float)UnsafeMemory.unsafeGetFloat((Object)o, (long)this.offset), (float)UnsafeMemory.unsafeGetFloat((Object)o2, (long)this.offset));
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.unsafePutFloat((Object)to, (long)this.offset, (float)UnsafeMemory.unsafeGetFloat((Object)from, (long)this.offset));
        }
    }

    static class IntConversionFieldAccess
    extends FieldAccess {
        @NotNull
        private final LongConverter converter;

        IntConversionFieldAccess(@NotNull Field field, @NotNull LongConversion conversion) {
            super(field);
            this.converter = (LongConverter)ObjectUtils.newInstance(conversion.value());
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            int anInt = this.getInt(o);
            if (write.isBinary()) {
                write.int32(anInt);
            } else {
                try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                    StringBuilder sb = (StringBuilder)stlSb.get();
                    this.converter.append(sb, (long)anInt);
                    if (!write.isBinary() && sb.length() == 0) {
                        write.text("");
                    } else {
                        write.rawText(sb);
                    }
                }
            }
        }

        protected int getInt(Object o) {
            return UnsafeMemory.unsafeGetInt((Object)o, (long)this.offset);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            long i;
            if (read.isBinary()) {
                i = read.int64();
            } else {
                try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                    StringBuilder sb = (StringBuilder)stlSb.get();
                    read.text(sb);
                    i = this.converter.parse(sb);
                }
            }
            UnsafeMemory.unsafePutLong((Object)o, (long)this.offset, (long)i);
        }

        protected void putInt(Object o, int i) {
            UnsafeMemory.unsafePutInt((Object)o, (long)this.offset, (int)i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                StringBuilder sb = (StringBuilder)stlSb.get();
                bytes.readUtf8(sb);
                long i = this.converter.parse(sb);
                bytes.writeLong(i);
            }
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return this.getInt(o) == this.getInt(o2);
        }

        @Override
        protected void copy(Object from, Object to) {
            this.putInt(to, this.getInt(from));
        }
    }

    static class IntLongConverterFieldAccess
    extends LongConverterFieldAccess {
        public IntLongConverterFieldAccess(@NotNull Field field, @NotNull LongConverter longConverter) {
            super(field, longConverter);
        }

        @Override
        protected boolean rangeCheck(long i) {
            return (i & 0xFFFFFFFFL) == i;
        }

        @Override
        protected long getLong(Object o) {
            return (long)UnsafeMemory.unsafeGetInt((Object)o, (long)this.offset) & 0xFFFFFFFFL;
        }

        @Override
        protected void setLong(Object o, long i) {
            UnsafeMemory.unsafePutInt((Object)o, (long)this.offset, (int)((int)i));
        }
    }

    static class CharLongConverterFieldAccess
    extends LongConverterFieldAccess {
        public CharLongConverterFieldAccess(@NotNull Field field, LongConverter longConverter) {
            super(field, longConverter);
        }

        @Override
        protected boolean rangeCheck(long i) {
            return (long)((char)i) == i;
        }

        @Override
        protected long getLong(Object o) {
            return UnsafeMemory.unsafeGetChar((Object)o, (long)this.offset);
        }

        @Override
        protected void setLong(Object o, long i) {
            UnsafeMemory.unsafePutChar((Object)o, (long)this.offset, (char)((char)i));
        }
    }

    static class ShortLongConverterFieldAccess
    extends LongConverterFieldAccess {
        public ShortLongConverterFieldAccess(@NotNull Field field, LongConverter longConverter) {
            super(field, longConverter);
        }

        @Override
        protected boolean rangeCheck(long i) {
            return (i & 0xFFFFL) == i;
        }

        @Override
        protected long getLong(Object o) {
            return (long)UnsafeMemory.unsafeGetShort((Object)o, (long)this.offset) & 0xFFFFL;
        }

        @Override
        protected void setLong(Object o, long i) {
            UnsafeMemory.unsafePutShort((Object)o, (long)this.offset, (short)((short)i));
        }
    }

    static class ByteLongConverterFieldAccess
    extends LongConverterFieldAccess {
        public ByteLongConverterFieldAccess(@NotNull Field field, LongConverter longConverter) {
            super(field, longConverter);
        }

        @Override
        protected boolean rangeCheck(long i) {
            return (i & 0xFFL) == i;
        }

        @Override
        protected long getLong(Object o) {
            return (long)UnsafeMemory.unsafeGetByte((Object)o, (long)this.offset) & 0xFFL;
        }

        @Override
        protected void setLong(Object o, long i) {
            UnsafeMemory.unsafePutByte((Object)o, (long)this.offset, (byte)((byte)i));
        }
    }

    static class ShortIntConversionFieldAccess
    extends IntConversionFieldAccess {
        public ShortIntConversionFieldAccess(@NotNull Field field, @NotNull LongConversion conversion) {
            super(field, conversion);
        }

        @Override
        protected int getInt(Object o) {
            return UnsafeMemory.unsafeGetShort((Object)o, (long)this.offset) & 0xFFFF;
        }

        @Override
        protected void putInt(Object o, int i) {
            UnsafeMemory.unsafePutShort((Object)o, (long)this.offset, (short)((short)i));
        }
    }

    static class ByteIntConversionFieldAccess
    extends IntConversionFieldAccess {
        public ByteIntConversionFieldAccess(@NotNull Field field, @NotNull LongConversion conversion) {
            super(field, conversion);
        }

        @Override
        protected int getInt(Object o) {
            return UnsafeMemory.unsafeGetByte((Object)o, (long)this.offset) & 0xFF;
        }

        @Override
        protected void putInt(Object o, int i) {
            UnsafeMemory.unsafePutByte((Object)o, (long)this.offset, (byte)((byte)i));
        }
    }

    static class IntegerFieldAccess
    extends FieldAccess {
        IntegerFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            if (previous == null) {
                write.int32(UnsafeMemory.unsafeGetInt((Object)o, (long)this.offset));
            } else {
                write.int32(UnsafeMemory.unsafeGetInt((Object)o, (long)this.offset), UnsafeMemory.unsafeGetInt((Object)previous, (long)this.offset));
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            int i = overwrite ? read.int32() : read.int32(UnsafeMemory.unsafeGetInt((Object)o, (long)this.offset));
            UnsafeMemory.unsafePutInt((Object)o, (long)this.offset, (int)i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeInt(UnsafeMemory.unsafeGetInt((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.unsafeGetInt((Object)o, (long)this.offset) == UnsafeMemory.unsafeGetInt((Object)o2, (long)this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.unsafePutInt((Object)to, (long)this.offset, (int)UnsafeMemory.unsafeGetInt((Object)from, (long)this.offset));
        }
    }

    static class CharFieldAccess
    extends FieldAccess {
        public static final String INVALID_CHAR_STR = String.valueOf('\uffff');

        CharFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            char c = UnsafeMemory.unsafeGetChar((Object)o, (long)this.offset);
            if (c == '\uffff') {
                write.nu11();
            } else {
                try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                    StringBuilder sb = (StringBuilder)stlSb.get();
                    sb.append(c);
                    write.text(sb);
                }
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            String text = read.text();
            if (text == null || text.length() < 1) {
                if (overwrite) {
                    text = INVALID_CHAR_STR;
                } else {
                    return;
                }
            }
            UnsafeMemory.unsafePutChar((Object)o, (long)this.offset, (char)text.charAt(0));
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeUnsignedShort((int)UnsafeMemory.unsafeGetChar((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.unsafeGetChar((Object)o, (long)this.offset) == UnsafeMemory.unsafeGetChar((Object)o2, (long)this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.unsafePutChar((Object)to, (long)this.offset, (char)UnsafeMemory.unsafeGetChar((Object)from, (long)this.offset));
        }
    }

    static class ShortFieldAccess
    extends FieldAccess {
        ShortFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            write.int16(UnsafeMemory.unsafeGetShort((Object)o, (long)this.offset));
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            UnsafeMemory.unsafePutShort((Object)o, (long)this.offset, (short)read.int16());
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeShort(UnsafeMemory.unsafeGetShort((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.unsafeGetShort((Object)o, (long)this.offset) == UnsafeMemory.unsafeGetShort((Object)o2, (long)this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.unsafePutShort((Object)to, (long)this.offset, (short)UnsafeMemory.unsafeGetShort((Object)from, (long)this.offset));
        }
    }

    static class ByteFieldAccess
    extends FieldAccess {
        ByteFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            write.int8(UnsafeMemory.unsafeGetByte((Object)o, (long)this.offset));
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            UnsafeMemory.unsafePutByte((Object)o, (long)this.offset, (byte)read.int8());
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeByte(UnsafeMemory.unsafeGetByte((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.unsafeGetByte((Object)o, (long)this.offset) == UnsafeMemory.unsafeGetByte((Object)o2, (long)this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.unsafePutByte((Object)to, (long)this.offset, (byte)UnsafeMemory.unsafeGetByte((Object)from, (long)this.offset));
        }
    }

    static class BooleanFieldAccess
    extends FieldAccess {
        BooleanFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            write.bool(UnsafeMemory.unsafeGetBoolean((Object)o, (long)this.offset));
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            UnsafeMemory.unsafePutBoolean((Object)o, (long)this.offset, (boolean)read.bool());
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeBoolean(UnsafeMemory.unsafeGetBoolean((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.unsafeGetBoolean((Object)o, (long)this.offset) == UnsafeMemory.unsafeGetBoolean((Object)o2, (long)this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.unsafePutBoolean((Object)to, (long)this.offset, (boolean)UnsafeMemory.unsafeGetBoolean((Object)from, (long)this.offset));
        }
    }

    static class MapFieldAccess
    extends FieldAccess {
        @NotNull
        final Supplier<Map> collectionSupplier;
        private final Class<?> type;
        @NotNull
        private final Class keyType;
        @NotNull
        private final Class valueType;

        MapFieldAccess(@NotNull Field field) {
            super(field);
            this.type = field.getType();
            this.collectionSupplier = this.type == Map.class ? LinkedHashMap::new : (this.type == SortedMap.class || this.type == NavigableMap.class ? TreeMap::new : this.newInstance());
            Type[] actualTypeArguments = WireMarshaller.computeActualTypeArguments(Map.class, field);
            this.keyType = MapFieldAccess.extractClass(actualTypeArguments[0]);
            this.valueType = MapFieldAccess.extractClass(actualTypeArguments[1]);
        }

        @NotNull
        private Supplier<Map> newInstance() {
            return () -> (Map)ObjectUtils.newInstance(this.type);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException, InvalidMarshallableException {
            @NotNull Map map = (Map)this.field.get(o);
            write.marshallable(map, this.keyType, this.valueType, Boolean.TRUE.equals(this.isLeaf));
        }

        @Override
        protected void copy(Object from, Object to) throws IllegalAccessException {
            Map fromMap = (Map)this.field.get(from);
            if (fromMap == null) {
                this.field.set(to, null);
                return;
            }
            Map map = (Map)this.field.get(to);
            if (map == null) {
                map = this.collectionSupplier.get();
                this.field.set(to, map);
            } else if (!map.isEmpty()) {
                map.clear();
            }
            map.clear();
            if (!fromMap.isEmpty()) {
                map.putAll(fromMap);
            }
        }

        @Override
        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException, InvalidMarshallableException {
            Map map = (Map)this.field.get(o);
            if (map == null) {
                map = this.collectionSupplier.get();
                this.field.set(o, map);
            } else if (!map.isEmpty()) {
                map.clear();
            }
            if (read.marshallableAsMap(this.keyType, this.valueType, map) == null) {
                this.field.set(o, null);
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getAsBytes(Object o, Bytes<?> bytes) {
            throw new UnsupportedOperationException();
        }
    }

    static class StringCollectionFieldAccess
    extends FieldAccess {
        @NotNull
        final Supplier<Collection> collectionSupplier;
        private final Class<?> type;
        @NotNull
        private final BiConsumer<Collection, ValueIn> seqConsumer = (c, in2) -> {
            Bytes<?> bytes = in2.wireIn().bytes();
            while (in2.hasNextSequenceItem()) {
                long start = bytes.readPosition();
                c.add(in2.text());
                long end = bytes.readPosition();
                if (start != end) continue;
                int ch = bytes.readUnsignedByte(start);
                throw new IORuntimeException("Expected a ] but found " + ch + " '" + (char)ch + "'");
            }
        };

        public StringCollectionFieldAccess(@NotNull Field field, Boolean isLeaf, @Nullable Supplier<Collection> collectionSupplier, Class<?> type) {
            super(field, isLeaf);
            this.collectionSupplier = collectionSupplier == null ? this.newInstance() : collectionSupplier;
            this.type = type;
        }

        private Supplier<Collection> newInstance() {
            return () -> (Collection)ObjectUtils.newInstance(this.type);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            @NotNull Collection c = (Collection)this.field.get(o);
            if (c == null) {
                write.nu11();
                return;
            }
            write.sequence(c, (coll, out) -> {
                if (coll instanceof RandomAccess) {
                    @NotNull List list = (List)coll;
                    @NotNull int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        out.text((String)list.get(i));
                    }
                } else {
                    for (String element : coll) {
                        out.text(element);
                    }
                }
            });
        }

        @Override
        protected void copy(Object from, Object to) throws IllegalAccessException {
            Collection fromColl = (Collection)this.field.get(from);
            if (fromColl == null) {
                this.field.set(to, null);
                return;
            }
            Collection coll = (Collection)this.field.get(to);
            if (coll == null) {
                coll = this.collectionSupplier.get();
                this.field.set(to, coll);
            }
            coll.clear();
            if (!fromColl.isEmpty()) {
                coll.addAll(fromColl);
            }
        }

        @Override
        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException {
            Collection coll = (Collection)this.field.get(o);
            if (coll == null) {
                coll = this.collectionSupplier.get();
                this.field.set(o, coll);
            } else if (!coll.isEmpty()) {
                coll.clear();
            }
            boolean sequenced = read.sequence(coll, this.seqConsumer);
            if (overwrite && !sequenced) {
                this.field.set(o, null);
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getAsBytes(Object o, Bytes<?> bytes) {
            throw new UnsupportedOperationException();
        }
    }

    static class CollectionFieldAccess
    extends FieldAccess {
        @NotNull
        final Supplier<Collection> collectionSupplier;
        private final Class componentType;
        private final Class<?> type;
        private final BiConsumer<Object, ValueOut> sequenceGetter;

        public CollectionFieldAccess(@NotNull Field field, Boolean isLeaf, @Nullable Supplier<Collection> collectionSupplier, Class componentType, Class<?> type) {
            super(field, isLeaf);
            this.collectionSupplier = collectionSupplier == null ? this.newInstance() : collectionSupplier;
            this.componentType = componentType;
            this.type = type;
            this.sequenceGetter = (o, out) -> {
                Collection coll;
                try {
                    coll = (Collection)field.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                if (coll instanceof RandomAccess) {
                    @NotNull List list = (List)coll;
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        out.object(componentType, list.get(i));
                    }
                } else if (coll == null) {
                    try {
                        field.set(coll, null);
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                } else {
                    for (Object element : coll) {
                        out.object(componentType, element);
                    }
                }
            };
        }

        @NotNull
        static FieldAccess of(@NotNull Field field) {
            Boolean isLeaf = null;
            Class<?> type = field.getType();
            Supplier<Collection> collectionSupplier = type == List.class || type == Collection.class ? ArrayList::new : (type == SortedSet.class || type == NavigableSet.class ? TreeSet::new : (type == Set.class ? LinkedHashSet::new : null));
            @NotNull Class componentType = CollectionFieldAccess.extractClass(WireMarshaller.computeActualTypeArguments(Collection.class, field)[0]);
            if (componentType != Object.class) {
                isLeaf = !Throwable.class.isAssignableFrom(componentType) && ((WireMarshaller)WIRE_MARSHALLER_CL.get(componentType)).isLeaf;
            }
            return componentType == String.class ? new StringCollectionFieldAccess(field, true, collectionSupplier, type) : new CollectionFieldAccess(field, isLeaf, collectionSupplier, componentType, type);
        }

        private Supplier<Collection> newInstance() {
            return () -> (Collection)ObjectUtils.newInstance(this.type);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            @NotNull Collection c = (Collection)this.field.get(o);
            if (c == null) {
                write.nu11();
                return;
            }
            write.sequence(o, this.sequenceGetter);
        }

        @Override
        protected void copy(Object from, Object to) throws IllegalAccessException {
            Collection fromColl = (Collection)this.field.get(from);
            if (fromColl == null) {
                this.field.set(to, null);
                return;
            }
            Collection coll = (Collection)this.field.get(to);
            if (coll == null) {
                coll = this.collectionSupplier.get();
                this.field.set(to, coll);
            }
            coll.clear();
            if (!fromColl.isEmpty()) {
                coll.addAll(fromColl);
            }
        }

        @Override
        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException {
            Collection coll = (Collection)this.field.get(o);
            if (coll == null) {
                coll = this.collectionSupplier.get();
                this.field.set(o, coll);
            }
            if (!read.sequence(coll, (c, in2) -> {
                if (!c.isEmpty()) {
                    c.clear();
                }
                while (in2.hasNextSequenceItem()) {
                    c.add(in2.object(this.componentType));
                }
            })) {
                Collection defaultColl = (Collection)this.field.get(defaults);
                if (defaultColl == null) {
                    this.field.set(o, null);
                } else {
                    coll.clear();
                    if (!defaultColl.isEmpty()) {
                        coll.addAll(defaultColl);
                    }
                }
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getAsBytes(Object o, Bytes<?> bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean sameValue(Object o, Object o2) throws IllegalAccessException {
            return super.sameValue(o, o2);
        }
    }

    static class EnumSetFieldAccess
    extends FieldAccess {
        private final Object[] values;
        private final BiConsumer<Object, ValueOut> sequenceGetter;
        private final Class componentType;
        private final Supplier<EnumSet> enumSetSupplier;
        private final BiConsumer<EnumSet, ValueIn> addAll;

        EnumSetFieldAccess(@NotNull Field field, Boolean isLeaf, Object[] values, Class componentType) {
            super(field, isLeaf);
            this.values = values;
            this.componentType = componentType;
            this.enumSetSupplier = () -> EnumSet.noneOf(this.componentType);
            this.sequenceGetter = (o, out) -> EnumSetFieldAccess.sequenceGetter(o, out, this.values, this.field, this.componentType);
            this.addAll = this::addAll;
        }

        private static void sequenceGetter(Object o, ValueOut out, Object[] values, Field field, Class componentType) throws InvalidMarshallableException {
            EnumSet coll;
            try {
                coll = (EnumSet)field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            for (Object v : values) {
                if (!coll.contains(v)) continue;
                out.object(componentType, v);
            }
        }

        @Override
        protected void getValue(Object o, ValueOut write, Object previous) throws IllegalAccessException {
            @NotNull Collection c = (Collection)this.field.get(o);
            if (c == null) {
                write.nu11();
                return;
            }
            write.sequence(o, this.sequenceGetter);
        }

        @Override
        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException {
            EnumSet coll = (EnumSet)this.field.get(o);
            if (coll == null) {
                coll = this.enumSetSupplier.get();
                this.field.set(o, coll);
            }
            if (!read.sequence(coll, this.addAll)) {
                Collection defaultColl = (Collection)this.field.get(defaults);
                if (defaultColl == null) {
                    this.field.set(o, null);
                } else {
                    coll.clear();
                    if (!defaultColl.isEmpty()) {
                        coll.addAll(defaultColl);
                    }
                }
            }
        }

        @Override
        protected void copy(Object from, Object to) throws IllegalAccessException {
            EnumSet fromColl = (EnumSet)this.field.get(from);
            if (fromColl == null) {
                this.field.set(to, null);
                return;
            }
            EnumSet coll = (EnumSet)this.field.get(to);
            if (coll == null) {
                coll = this.enumSetSupplier.get();
                this.field.set(to, coll);
            }
            coll.clear();
            for (int i = this.values.length - 1; i != -1; --i) {
                if (!fromColl.contains(this.values[i])) continue;
                coll.add(this.values[i]);
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getAsBytes(Object o, Bytes<?> bytes) {
            throw new UnsupportedOperationException();
        }

        private void addAll(EnumSet c, ValueIn in2) {
            if (!c.isEmpty()) {
                c.clear();
            }
            while (in2.hasNextSequenceItem()) {
                c.add(in2.asEnum(this.componentType));
            }
        }
    }

    static class ByteArrayFieldAccess
    extends FieldAccess {
        ByteArrayFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            Object arr = this.field.get(o);
            boolean leaf = write.swapLeaf(true);
            if (arr == null) {
                write.nu11();
            } else {
                write.bytes((byte[])arr);
            }
            write.swapLeaf(leaf);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) throws IllegalAccessException {
            Object arr = this.field.get(o);
            if (read.isNull()) {
                if (arr != null) {
                    this.field.set(o, null);
                }
                return;
            }
            byte[] arr2 = read.bytes((byte[])arr);
            if (arr2 != arr) {
                this.field.set(o, arr2);
            }
        }

        @Override
        public void getAsBytes(Object o, Bytes<?> bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEqual(Object o1, Object o2) {
            try {
                Class<?> aClass2;
                Object a1 = this.field.get(o1);
                Object a2 = this.field.get(o2);
                if (a1 == null) {
                    return a2 == null;
                }
                if (a2 == null) {
                    return false;
                }
                Class<?> aClass1 = a1.getClass();
                if (aClass1 != (aClass2 = a2.getClass()) && !aClass1.isAssignableFrom(aClass2) && !aClass2.isAssignableFrom(aClass1)) {
                    return false;
                }
                return Arrays.equals((byte[])a1, (byte[])a2);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class ArrayFieldAccess
    extends FieldAccess {
        private final Class componentType;
        private final Class objectType;

        ArrayFieldAccess(@NotNull Field field) {
            super(field);
            this.componentType = field.getType().getComponentType();
            this.objectType = ObjectUtils.implementationToUse((Class)ObjectUtils.primToWrapper((Class)this.componentType));
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            Object arr = this.field.get(o);
            boolean leaf = write.swapLeaf(true);
            if (arr == null) {
                write.nu11();
            } else {
                write.sequence(arr, (array, out) -> {
                    int len = Array.getLength(array);
                    for (int i = 0; i < len; ++i) {
                        out.object(this.objectType, Array.get(array, i));
                    }
                });
            }
            write.swapLeaf(leaf);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) throws IllegalAccessException {
            Object arr = this.field.get(o);
            if (read.isNull()) {
                if (arr != null) {
                    this.field.set(o, null);
                }
                return;
            }
            @NotNull ArrayList<E> list = new ArrayList();
            read.sequence(list, (l, in) -> {
                while (in.hasNextSequenceItem()) {
                    l.add(in.object(this.componentType));
                }
            });
            Object arr2 = Array.newInstance(this.componentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(arr2, i, list.get(i));
            }
            this.field.set(o, arr2);
        }

        @Override
        public void getAsBytes(Object o, Bytes<?> bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEqual(Object o1, Object o2) {
            try {
                int len2;
                Class<?> aClass2;
                Object a1 = this.field.get(o1);
                Object a2 = this.field.get(o2);
                if (a1 == null) {
                    return a2 == null;
                }
                if (a2 == null) {
                    return false;
                }
                Class<?> aClass1 = a1.getClass();
                if (aClass1 != (aClass2 = a2.getClass()) && !aClass1.isAssignableFrom(aClass2) && !aClass2.isAssignableFrom(aClass1)) {
                    return false;
                }
                int len1 = Array.getLength(a1);
                if (len1 != (len2 = Array.getLength(a2))) {
                    return false;
                }
                for (int i = 0; i < len1; ++i) {
                    if (Objects.equals(Array.get(a1, i), Array.get(a2, i))) continue;
                    return false;
                }
                return true;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class BytesFieldAccess
    extends FieldAccess {
        BytesFieldAccess(@NotNull Field field) {
            super(field, false);
        }

        @Override
        protected void getValue(@NotNull Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            Bytes bytesField = (Bytes)this.field.get(o);
            write.bytes((BytesStore)bytesField);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            WireIn wireIn;
            @NotNull Bytes bytes = (Bytes)UnsafeMemory.unsafeGetObject((Object)o, (long)this.offset);
            if (bytes == null) {
                bytes = Bytes.allocateElasticOnHeap((int)128);
                UnsafeMemory.unsafePutObject((Object)o, (long)this.offset, (Object)bytes);
            }
            if ((wireIn = read.wireIn()) instanceof TextWire) {
                wireIn.consumePadding();
                if (wireIn.bytes().startsWith(TextWire.BINARY)) {
                    this.decodeBytes(read, bytes);
                    return;
                }
            }
            if (read.textTo(bytes) == null) {
                UnsafeMemory.unsafePutObject((Object)o, (long)this.offset, null);
            } else {
                bytes.singleThreadedCheckReset();
            }
        }

        private void decodeBytes(@NotNull ValueIn read, Bytes<?> bytes) {
            try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                @NotNull StringBuilder sb0 = (StringBuilder)stlSb.get();
                read.text(sb0);
                String s = WireInternal.INTERNER.intern((CharSequence)sb0);
                byte[] decode = Base64.getDecoder().decode(s);
                bytes.clear();
                bytes.write(decode);
            }
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) throws IllegalAccessException {
            Bytes bytesField = (Bytes)this.field.get(o);
            bytes.write((BytesStore)bytesField);
        }

        @Override
        protected void copy(Object from, Object to) {
            Bytes toBytes;
            Bytes fromBytes = (Bytes)UnsafeMemory.unsafeGetObject((Object)from, (long)this.offset);
            if (fromBytes == (toBytes = (Bytes)UnsafeMemory.unsafeGetObject((Object)to, (long)this.offset))) {
                return;
            }
            if (fromBytes == null) {
                UnsafeMemory.unsafePutObject((Object)to, (long)this.offset, null);
                return;
            }
            if (toBytes == null) {
                toBytes = Bytes.elasticByteBuffer();
                UnsafeMemory.unsafePutObject((Object)to, (long)this.offset, (Object)toBytes);
            }
            toBytes.clear();
            toBytes.write((BytesStore)fromBytes);
        }
    }

    static class StringBuilderFieldAccess
    extends FieldAccess {
        private StringBuilder defaultValue;

        public StringBuilderFieldAccess(@NotNull Field field, @Nullable Object defaultObject) throws IllegalAccessException {
            super(field, true);
            this.defaultValue = defaultObject == null ? null : (StringBuilder)field.get(defaultObject);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            @NotNull CharSequence cs = (CharSequence)UnsafeMemory.unsafeGetObject((Object)o, (long)this.offset);
            write.text(cs);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            StringBuilder sb = (StringBuilder)UnsafeMemory.unsafeGetObject((Object)o, (long)this.offset);
            if (sb == null) {
                sb = new StringBuilder();
                UnsafeMemory.unsafePutObject((Object)o, (long)this.offset, (Object)sb);
            }
            if (read.textTo(sb) == null) {
                UnsafeMemory.unsafePutObject((Object)o, (long)this.offset, null);
            }
        }

        @Override
        protected void setDefaultValue(Object defaultObject, Object o) throws IllegalAccessException {
            if (this.defaultValue == null) {
                super.setDefaultValue(defaultObject, o);
                return;
            }
            StringBuilder sb = (StringBuilder)UnsafeMemory.unsafeGetObject((Object)o, (long)this.offset);
            if (sb == this.defaultValue) {
                return;
            }
            if (sb == null) {
                sb = new StringBuilder();
                UnsafeMemory.unsafePutObject((Object)o, (long)this.offset, (Object)sb);
            }
            sb.setLength(0);
            sb.append((CharSequence)this.defaultValue);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeUtf8((CharSequence)UnsafeMemory.unsafeGetObject((Object)o, (long)this.offset));
        }

        @Override
        protected boolean sameValue(Object o1, Object o2) throws IllegalAccessException {
            return StringUtils.isEqual((StringBuilder)((StringBuilder)this.field.get(o1)), (CharSequence)((StringBuilder)this.field.get(o2)));
        }

        @Override
        protected void copy(Object from, Object to) {
            StringBuilder fromSequence = (StringBuilder)UnsafeMemory.unsafeGetObject((Object)from, (long)this.offset);
            StringBuilder toSequence = (StringBuilder)UnsafeMemory.unsafeGetObject((Object)to, (long)this.offset);
            if (fromSequence == null) {
                UnsafeMemory.unsafePutObject((Object)to, (long)this.offset, null);
                return;
            }
            if (toSequence == null) {
                toSequence = new StringBuilder();
                UnsafeMemory.unsafePutObject((Object)to, (long)this.offset, (Object)toSequence);
            }
            toSequence.setLength(0);
            toSequence.append((CharSequence)fromSequence);
        }
    }

    static class StringFieldAccess
    extends FieldAccess {
        StringFieldAccess(@NotNull Field field) {
            super(field, false);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            write.text((String)UnsafeMemory.unsafeGetObject((Object)o, (long)this.offset));
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            UnsafeMemory.unsafePutObject((Object)o, (long)this.offset, (Object)read.text());
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            bytes.writeUtf8((String)UnsafeMemory.unsafeGetObject((Object)o, (long)this.offset));
        }
    }

    static class ResettableFieldAccess
    extends ObjectFieldAccess {
        private final Object defaultValue;

        ResettableFieldAccess(@NotNull Field field, Boolean isLeaf, Object defaultValue) {
            super(field, isLeaf);
            this.defaultValue = defaultValue;
        }

        @Override
        protected void setDefaultValue(Object defaultObject, Object o) throws IllegalAccessException {
            Object existingValue = UnsafeMemory.unsafeGetObject((Object)o, (long)this.offset);
            if (existingValue == this.defaultValue) {
                return;
            }
            if (existingValue != null && existingValue.getClass() == this.defaultValue.getClass()) {
                ((Resettable)existingValue).reset();
                return;
            }
            super.setDefaultValue(defaultObject, o);
        }
    }

    static class ObjectFieldAccess
    extends FieldAccess {
        private final Class type;
        private final AsMarshallable asMarshallable;

        ObjectFieldAccess(@NotNull Field field, Boolean isLeaf) {
            super(field, isLeaf);
            this.asMarshallable = (AsMarshallable)Jvm.findAnnotation((AnnotatedElement)field, AsMarshallable.class);
            this.type = field.getType();
        }

        @Override
        protected void getValue(@NotNull Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException, InvalidMarshallableException {
            Boolean wasLeaf = null;
            if (this.isLeaf != null) {
                wasLeaf = write.swapLeaf(this.isLeaf);
            }
            assert (o != null);
            Object v = this.field.get(o);
            if (this.asMarshallable == null || !(v instanceof WriteMarshallable)) {
                write.object(this.type, v);
            } else {
                write.typedMarshallable((WriteMarshallable)v);
            }
            if (wasLeaf != null) {
                write.swapLeaf(wasLeaf);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) throws IllegalAccessException {
            block7: {
                long pos = read.wireIn().bytes().readPosition();
                try {
                    Object using = ObjectUtils.isImmutable((Class)this.type) == ObjectUtils.Immutability.NO ? this.field.get(o) : null;
                    Object object = null;
                    try {
                        object = read.object(using, this.type, false);
                    }
                    catch (Exception e) {
                        if (using == null && Modifier.isAbstract(this.type.getModifiers()) && !Modifier.isInterface(this.type.getModifiers()) && !this.type.isEnum() && !read.isTyped()) {
                            Jvm.warn().on(this.getClass(), "Ignoring exception and setting field '" + this.field.getName() + "' to null", (Throwable)e);
                        }
                        Jvm.rethrow((Throwable)e);
                    }
                    if (object instanceof SingleThreadedChecked) {
                        ((SingleThreadedChecked)object).singleThreadedCheckReset();
                    }
                    this.field.set(o, object);
                }
                catch (ClassCastException | ClassNotFoundRuntimeException | UnexpectedFieldHandlingException e) {
                    Jvm.rethrow((Throwable)e);
                }
                catch (Exception e) {
                    read.wireIn().bytes().readPosition(pos);
                    Jvm.warn().on(this.getClass(), "Unable to parse field: " + this.field.getName() + ", as a marshallable as it is " + read.objectBestEffort(), (Throwable)e);
                    if (!overwrite) break block7;
                    this.field.set(o, ObjectUtils.defaultValue(this.field.getType()));
                }
            }
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) throws IllegalAccessException {
            bytes.writeUtf8(String.valueOf(this.field.get(o)));
        }
    }

    static class LongValueAccess
    extends FieldAccess {
        LongValueAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write, Object previous) throws IllegalAccessException {
            LongValue f = (LongValue)this.field.get(o);
            long value = f == null ? 0L : f.getValue();
            write.int64forBinding(value);
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) throws IllegalAccessException {
            LongValue f = (LongValue)this.field.get(o);
            if (f == null) {
                f = read.wireIn().newLongReference();
                this.field.set(o, f);
            }
            read.int64(f);
        }

        @Override
        public void getAsBytes(Object o, Bytes<?> bytes) {
            throw new UnsupportedOperationException();
        }
    }

    static class IntValueAccess
    extends FieldAccess {
        IntValueAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write, Object previous) throws IllegalAccessException {
            IntValue f = (IntValue)this.field.get(o);
            int value = f == null ? 0 : f.getValue();
            write.int32forBinding(value);
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) throws IllegalAccessException {
            IntValue f = (IntValue)this.field.get(o);
            if (f == null) {
                f = read.wireIn().newIntReference();
                this.field.set(o, f);
            }
            read.int32(f);
        }

        @Override
        public void getAsBytes(Object o, Bytes<?> bytes) {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class FieldAccess {
        @NotNull
        final Field field;
        final long offset;
        @NotNull
        final WireKey key;
        Comment commentAnnotation;
        Boolean isLeaf;

        FieldAccess(@NotNull Field field) {
            this(field, null);
        }

        FieldAccess(@NotNull Field field, Boolean isLeaf) {
            this.field = field;
            this.offset = UnsafeMemory.unsafeObjectFieldOffset((Field)field);
            this.key = field::getName;
            this.isLeaf = isLeaf;
            try {
                this.commentAnnotation = (Comment)Jvm.findAnnotation((AnnotatedElement)field, Comment.class);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Nullable
        public static Object create(@NotNull Field field, @Nullable Object defaultObject) {
            Class<?> type = field.getType();
            try {
                Object defaultValue;
                if (type.isArray()) {
                    if (type.getComponentType() == Byte.TYPE) {
                        return new ByteArrayFieldAccess(field);
                    }
                    return new ArrayFieldAccess(field);
                }
                if (EnumSet.class.isAssignableFrom(type)) {
                    Class componentType = FieldAccess.extractClass(WireMarshaller.computeActualTypeArguments(EnumSet.class, field)[0]);
                    if (componentType == Object.class || Modifier.isAbstract(componentType.getModifiers())) {
                        throw new RuntimeException("Could not get enum constant directory");
                    }
                    boolean isLeaf = !Throwable.class.isAssignableFrom(componentType) && ((WireMarshaller)WIRE_MARSHALLER_CL.get(componentType)).isLeaf;
                    try {
                        Object[] values = (Object[])Jvm.getMethod((Class)componentType, (String)"values", (Class[])new Class[0]).invoke((Object)componentType, null);
                        return new EnumSetFieldAccess(field, isLeaf, values, componentType);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw Jvm.rethrow((Throwable)e);
                    }
                }
                if (Collection.class.isAssignableFrom(type)) {
                    return CollectionFieldAccess.of(field);
                }
                if (Map.class.isAssignableFrom(type)) {
                    return new MapFieldAccess(field);
                }
                switch (type.getName()) {
                    case "boolean": {
                        return new BooleanFieldAccess(field);
                    }
                    case "byte": {
                        LongConverter longConverter = FieldAccess.acquireLongConverter(field);
                        if (longConverter != null) {
                            return new ByteLongConverterFieldAccess(field, longConverter);
                        }
                        return new ByteFieldAccess(field);
                    }
                    case "char": {
                        LongConverter longConverter = FieldAccess.acquireLongConverter(field);
                        if (longConverter != null) {
                            return new CharLongConverterFieldAccess(field, longConverter);
                        }
                        return new CharFieldAccess(field);
                    }
                    case "short": {
                        LongConverter longConverter = FieldAccess.acquireLongConverter(field);
                        if (longConverter != null) {
                            return new ShortLongConverterFieldAccess(field, longConverter);
                        }
                        return new ShortFieldAccess(field);
                    }
                    case "int": {
                        LongConverter longConverter = FieldAccess.acquireLongConverter(field);
                        if (longConverter != null) {
                            return new IntLongConverterFieldAccess(field, longConverter);
                        }
                        return new IntegerFieldAccess(field);
                    }
                    case "float": {
                        return new FloatFieldAccess(field);
                    }
                    case "long": {
                        LongConverter longConverter = FieldAccess.acquireLongConverter(field);
                        return longConverter == null ? new LongFieldAccess(field) : new LongConverterFieldAccess(field, longConverter);
                    }
                    case "double": {
                        return new DoubleFieldAccess(field);
                    }
                    case "java.lang.String": {
                        return new StringFieldAccess(field);
                    }
                    case "java.lang.StringBuilder": {
                        return new StringBuilderFieldAccess(field, defaultObject);
                    }
                    case "net.openhft.chronicle.bytes.Bytes": {
                        return new BytesFieldAccess(field);
                    }
                }
                if (isRecord != null && ((Boolean)isRecord.invoke(type, new Object[0])).booleanValue()) {
                    throw new UnsupportedOperationException("Record classes are not supported");
                }
                Boolean isLeaf = null;
                if (IntValue.class.isAssignableFrom(type)) {
                    return new IntValueAccess(field);
                }
                if (LongValue.class.isAssignableFrom(type)) {
                    return new LongValueAccess(field);
                }
                if (WireMarshaller.class.isAssignableFrom(type)) {
                    isLeaf = ((WireMarshaller)WIRE_MARSHALLER_CL.get(type)).isLeaf;
                } else if (WireMarshaller.isCollection(type)) {
                    isLeaf = false;
                }
                Object object = defaultValue = defaultObject == null ? null : field.get(defaultObject);
                if (defaultValue != null && defaultValue instanceof Resettable && !(defaultValue instanceof DynamicEnum)) {
                    return new ResettableFieldAccess(field, isLeaf, defaultValue);
                }
                return new ObjectFieldAccess(field, isLeaf);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw Jvm.rethrow((Throwable)ex);
            }
        }

        @Nullable
        private static LongConverter acquireLongConverter(@NotNull Field field) {
            LongConversion longConversion = (LongConversion)Jvm.findAnnotation((AnnotatedElement)field, LongConversion.class);
            LongConverter longConverter = null;
            if (longConversion != null) {
                longConverter = LongConverterFieldAccess.getInstance(longConversion.value());
            }
            return longConverter;
        }

        @NotNull
        static Class extractClass(Type type0) {
            if (type0 instanceof Class) {
                return (Class)type0;
            }
            if (type0 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type0).getRawType();
            }
            return Object.class;
        }

        @NotNull
        public String toString() {
            return "FieldAccess{field=" + this.field + ", isLeaf=" + this.isLeaf + '}';
        }

        void write(Object o, @NotNull WireOut out) throws IllegalAccessException, InvalidMarshallableException {
            ValueOut valueOut = out.write(this.field.getName());
            if (valueOut instanceof CommentAnnotationNotifier && this.commentAnnotation != null) {
                this.getValueCommentAnnotated(o, out, valueOut);
                return;
            }
            this.getValue(o, valueOut, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getValueCommentAnnotated(Object o, @NotNull WireOut out, ValueOut valueOut) throws IllegalAccessException, InvalidMarshallableException {
            CommentAnnotationNotifier notifier = (CommentAnnotationNotifier)((Object)valueOut);
            notifier.hasPrecedingComment(true);
            try {
                this.getValue(o, valueOut, null);
                out.writeComment(String.format(this.commentAnnotation.value(), this.field.get(o)));
            }
            finally {
                notifier.hasPrecedingComment(false);
            }
        }

        void write(Object o, @NotNull WireOut out, Object previous, boolean copy) throws IllegalAccessException, InvalidMarshallableException {
            if (this.sameValue(o, previous)) {
                return;
            }
            ValueOut write = out.write(this.field.getName());
            this.getValue(o, write, previous);
            if (copy) {
                this.copy(o, previous);
            }
        }

        protected boolean sameValue(Object o, Object o2) throws IllegalAccessException {
            Object v1 = this.field.get(o);
            Object v2 = this.field.get(o2);
            if (v1 instanceof CharSequence && v2 instanceof CharSequence) {
                return StringUtils.isEqual((CharSequence)((CharSequence)v1), (CharSequence)((CharSequence)v2));
            }
            return Objects.equals(v1, v2);
        }

        protected void copy(Object from, Object to) throws IllegalAccessException {
            ObjectUtils.requireNonNull((Object)from);
            ObjectUtils.requireNonNull((Object)to);
            UnsafeMemory.unsafePutObject((Object)to, (long)this.offset, (Object)UnsafeMemory.unsafeGetObject((Object)from, (long)this.offset));
        }

        protected abstract void getValue(Object var1, ValueOut var2, Object var3) throws IllegalAccessException, InvalidMarshallableException;

        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException, InvalidMarshallableException {
            if (!read.isPresent()) {
                if (overwrite && defaults != null) {
                    this.copy(Objects.requireNonNull(defaults), o);
                }
            } else {
                long pos = read.wireIn().bytes().readPosition();
                try {
                    this.setValue(o, read, overwrite);
                }
                catch (ClassCastException | ClassNotFoundRuntimeException | UnexpectedFieldHandlingException e) {
                    Jvm.rethrow((Throwable)e);
                }
                catch (Exception e) {
                    read.wireIn().bytes().readPosition(pos);
                    try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                        StringBuilder sb = (StringBuilder)stlSb.get();
                        read.text(sb);
                        Jvm.warn().on(this.getClass(), "Failed to read '" + this.field.getName() + "' with '" + sb + "' taking default", (Throwable)e);
                    }
                    this.copy(defaults, o);
                }
            }
        }

        protected abstract void setValue(Object var1, ValueIn var2, boolean var3) throws IllegalAccessException;

        protected void setDefaultValue(Object defaultObject, Object o) throws IllegalAccessException {
            this.copy(defaultObject, o);
        }

        public abstract void getAsBytes(Object var1, Bytes<?> var2) throws IllegalAccessException;

        public boolean isEqual(Object o1, Object o2) {
            try {
                return this.sameValue(o1, o2);
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
    }

    static class LongConverterFieldAccess
    extends FieldAccess {
        @NotNull
        private final LongConverter longConverter;

        LongConverterFieldAccess(@NotNull Field field, @NotNull LongConverter longConverter) {
            super(field);
            this.longConverter = longConverter;
        }

        static LongConverter getInstance(Class clazz) {
            try {
                Field converterField = clazz.getDeclaredField("INSTANCE");
                return (LongConverter)converterField.get(null);
            }
            catch (NoSuchFieldException nsfe) {
                return (LongConverter)ObjectUtils.newInstance((Class)clazz);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            long aLong = this.getLong(o);
            if (write.isBinary()) {
                write.int64(aLong);
            } else {
                try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                    StringBuilder sb = (StringBuilder)stlSb.get();
                    this.longConverter.append(sb, aLong);
                    if (!write.isBinary() && sb.length() == 0) {
                        write.text("");
                    } else {
                        write.rawText(sb);
                    }
                }
            }
        }

        protected long getLong(Object o) {
            return UnsafeMemory.unsafeGetLong((Object)o, (long)this.offset);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            long i;
            if (read.isBinary()) {
                i = read.int64();
            } else {
                try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                    StringBuilder sb = (StringBuilder)stlSb.get();
                    read.text(sb);
                    i = this.longConverter.parse(sb);
                    if (!this.rangeCheck(i)) {
                        throw new IORuntimeException("value '" + sb + "' is out of range for a " + this.field.getType());
                    }
                }
            }
            this.setLong(o, i);
        }

        protected boolean rangeCheck(long i) {
            return true;
        }

        protected void setLong(Object o, long i) {
            UnsafeMemory.unsafePutLong((Object)o, (long)this.offset, (long)i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes<?> bytes) {
            try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                StringBuilder sb = (StringBuilder)stlSb.get();
                bytes.readUtf8(sb);
                long i = this.longConverter.parse(sb);
                bytes.writeLong(i);
            }
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return this.getLong(o) == this.getLong(o2);
        }

        @Override
        protected void copy(Object from, Object to) {
            this.setLong(to, this.getLong(from));
        }
    }
}

