/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.CommonMarshallable;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.ref.BinaryIntArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntArrayValues;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWriteDocumentContext;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueInStack;
import net.openhft.chronicle.wire.ValueInState;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawWire
extends AbstractWire
implements Wire {
    private final RawValueOut valueOut = new RawValueOut();
    private final RawValueIn valueIn = new RawValueIn();
    private final WriteDocumentContext writeContext = new BinaryWriteDocumentContext(this);
    private final BinaryReadDocumentContext readContext = new BinaryReadDocumentContext(this, false);
    @Nullable
    private StringBuilder lastSB;

    public RawWire(@NotNull Bytes<?> bytes) {
        this(bytes, true);
    }

    public RawWire(@NotNull Bytes<?> bytes, boolean use8bit) {
        super(bytes, use8bit);
    }

    @Override
    public void reset() {
        this.valueIn.resetState();
        this.valueOut.resetState();
        this.writeContext.reset();
        this.readContext.reset();
        this.bytes.clear();
        this.lastSB = null;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    @NotNull
    public DocumentContext writingDocument(boolean metaData) {
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) {
        if (this.writeContext.isOpen()) {
            return this.writeContext;
        }
        return this.writingDocument(metaData);
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        this.readContext.start();
        return this.readContext;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(long readLocation) {
        long readPosition = this.bytes().readPosition();
        long readLimit = this.bytes().readLimit();
        this.bytes().readPosition(readLocation);
        this.readContext.start();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @Override
    public void consumePadding() {
    }

    @Override
    @NotNull
    public String readingPeekYaml() {
        long start = this.readContext.start;
        if (start == -1L) {
            return "";
        }
        return Wires.fromSizePrefixedBlobs(this.bytes, start);
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        if (!(wire instanceof RawWire)) {
            throw new UnsupportedOperationException("Can only copy Raw Wire format to the same format.");
        }
        wire.bytes().write((BytesStore)this.bytes);
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn readEventName(@NotNull StringBuilder name) {
        if (this.use8bit) {
            this.bytes.read8bit(name);
        } else {
            this.bytes.readUtf8(name);
        }
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    @Nullable
    public <K> K readEvent(@NotNull Class<K> expectedClass) throws InvalidMarshallableException {
        return this.valueIn.object(expectedClass);
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.lastSB = name;
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder sb) {
        return this;
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    @NotNull
    public BooleanValue newBooleanReference() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean useSelfDescribingMessage(@NotNull CommonMarshallable object) {
        return object.usesSelfDescribingMessage();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    @NotNull
    public WireIn readAlignTo(int alignment) {
        long mod = this.bytes.readPosition() % (long)alignment;
        this.bytes.readSkip(mod);
        return this;
    }

    public String toString() {
        return this.bytes.toString();
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull WireKey key) {
        return this.writeEventName(key.name());
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull CharSequence name) {
        if (this.use8bit) {
            this.bytes.write8bit(name);
        } else {
            this.bytes.writeUtf8(name);
        }
        return this.valueOut;
    }

    @Override
    public void writeStartEvent() {
    }

    @Override
    public void writeEndEvent() {
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull CharSequence name) {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.writeByte((byte)0);
        }
        return this;
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new BinaryLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new BinaryIntReference();
    }

    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        return new BinaryLongArrayReference();
    }

    @Override
    @NotNull
    public IntArrayValues newIntArrayReference() {
        return new BinaryIntArrayReference();
    }

    class RawValueIn
    implements ValueIn {
        final ValueInStack stack = new ValueInStack();

        RawValueIn() {
        }

        @Override
        public void resetState() {
            this.stack.reset();
        }

        public void pushState() {
            this.stack.push();
        }

        public void popState() {
            this.stack.pop();
        }

        public ValueInState curr() {
            return this.stack.curr();
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> flag) {
            int b = RawWire.this.bytes.readUnsignedByte();
            switch (b) {
                case 187: {
                    flag.accept(t, null);
                    break;
                }
                case 0: 
                case 176: {
                    flag.accept(t, Boolean.valueOf(false));
                    break;
                }
                default: {
                    flag.accept(t, Boolean.valueOf(true));
                }
            }
            return RawWire.this;
        }

        @Override
        public boolean isTyped() {
            return false;
        }

        @Override
        public Class typePrefix() {
            return null;
        }

        @Override
        @Nullable
        public String text() {
            return RawWire.this.use8bit ? RawWire.this.bytes.readUtf8() : RawWire.this.bytes.read8bit();
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder s) {
            if (RawWire.this.use8bit) {
                return RawWire.this.bytes.read8bit(s) ? s : null;
            }
            return RawWire.this.bytes.readUtf8(s) ? s : null;
        }

        @Override
        @Nullable
        public Bytes<?> textTo(@NotNull Bytes<?> s) {
            if (RawWire.this.use8bit) {
                return RawWire.this.bytes.read8bit(s) ? s : null;
            }
            return RawWire.this.bytes.readUtf8(s) ? s : null;
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut<?> toBytes) {
            return this.bytes(toBytes, true);
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut<?> toBytes, boolean clearBytes) {
            if (clearBytes) {
                toBytes.clear();
            }
            long length = this.readLength();
            @NotNull Bytes<?> bytes = this.wireIn().bytes();
            toBytes.write(bytes, bytes.readPosition(), length);
            bytes.readSkip(length);
            return this.wireIn();
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, @NotNull BooleanConsumer consumer) {
            long length = this.readLength();
            @NotNull Bytes<?> bytes = this.wireIn().bytes();
            if (length == compareBytes.readRemaining()) {
                consumer.accept(Boolean.valueOf(bytes.equalBytes(compareBytes, length)));
            } else {
                consumer.accept(Boolean.valueOf(false));
            }
            bytes.readSkip(length);
            return this.wireIn();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            long length = this.readLength();
            if (length > RawWire.this.bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            long limit0 = RawWire.this.bytes.readLimit();
            long limit = RawWire.this.bytes.readPosition() + length;
            try {
                RawWire.this.bytes.readLimit(limit);
                bytesConsumer.readMarshallable((BytesIn)RawWire.this.bytes);
            }
            finally {
                RawWire.this.bytes.readLimit(limit0);
                RawWire.this.bytes.readPosition(limit);
            }
            return this.wireIn();
        }

        @Override
        @NotNull
        public @NotNull byte @NotNull [] bytes(byte[] using) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return RawWire.this;
        }

        @Override
        public long readLength() {
            return RawWire.this.bytes.readStopBit();
        }

        @Override
        @NotNull
        public WireIn skipValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            tb.accept(t, RawWire.this.bytes.readByte());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            ti.accept(t, (short)RawWire.this.bytes.readUnsignedByte());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            ti.accept(t, RawWire.this.bytes.readShort());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            ti.accept(t, RawWire.this.bytes.readUnsignedShort());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            ti.accept(t, RawWire.this.bytes.readInt());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            tl.accept(t, RawWire.this.bytes.readUnsignedInt());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            tl.accept(t, RawWire.this.bytes.readLong());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            tf.accept(t, RawWire.this.bytes.readFloat());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            td.accept(t, RawWire.this.bytes.readDouble());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            setLocalTime.accept(t, LocalTime.ofNanoOfDay(RawWire.this.bytes.readLong()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            tZonedDateTime.accept(t, ZonedDateTime.parse(RawWire.this.bytes.readUtf8()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            tLocalDate.accept(t, LocalDate.ofEpochDay(RawWire.this.bytes.readStopBit()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            tuuid.accept(t, new UUID(RawWire.this.bytes.readLong(), RawWire.this.bytes.readLong()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            if (!(values instanceof Byteable)) {
                values = new BinaryLongArrayReference();
            }
            @Nullable Byteable b = (Byteable)values;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.readPosition(), length);
            RawWire.this.bytes.readSkip(length);
            setter.accept(t, values);
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 8L) {
                value = new BinaryLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongValue value) {
            @Nullable Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.readPosition(), length);
            RawWire.this.bytes.readSkip(length);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntValue value) {
            @NotNull Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.readPosition(), length);
            RawWire.this.bytes.readSkip(length);
            return RawWire.this;
        }

        @Override
        public WireIn bool(@NotNull BooleanValue ret) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 8L) {
                value = new BinaryIntReference();
                setter.accept(t, value);
            }
            @Nullable Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.readPosition(), length);
            RawWire.this.bytes.readSkip(length);
            return RawWire.this;
        }

        @Override
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public <T> boolean sequence(List<T> list, @NotNull List<T> buffer, Supplier<T> bufferAdd, ValueIn.Reader reader0) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                StringBuilder sb = (StringBuilder)stlSb.get();
                RawWire.this.bytes.readUtf8(sb);
                ts.accept(t, sb);
            }
            return this;
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) {
            try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                StringBuilder sb = (StringBuilder)stlSb.get();
                RawWire.this.bytes.readUtf8(sb);
                classNameConsumer.accept(t, sb);
            }
            return RawWire.this;
        }

        @Override
        public ClassLookup classLookup() {
            return RawWire.this.classLookup();
        }

        /*
         * Loose catch block
         */
        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            Throwable throwable = null;
            try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                StringBuilder sb = (StringBuilder)stlSb.get();
                RawWire.this.bytes.readUtf8(sb);
                try {
                    Class clazz = RawWire.this.classLookup.forName((CharSequence)sb);
                    return clazz;
                }
                catch (ClassNotFoundRuntimeException e) {
                    Type type;
                    block17: {
                        block18: {
                            type = unresolvedHandler.apply(sb, e.getCause());
                            if (stlSb == null) break block17;
                            if (throwable == null) break block18;
                            try {
                                stlSb.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block17;
                        }
                        stlSb.close();
                    }
                    return type;
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            this.textTo(RawWire.this.lastSB);
            long length = RawWire.this.bytes.readUnsignedInt();
            if (length >= 0L) {
                long limit = RawWire.this.bytes.readLimit();
                long limit2 = RawWire.this.bytes.readPosition() + length;
                RawWire.this.bytes.readLimit(limit2);
                try {
                    T t = marshallableReader.apply(RawWire.this);
                    return t;
                }
                finally {
                    RawWire.this.bytes.readLimit(limit);
                    RawWire.this.bytes.readPosition(limit2);
                }
            }
            return marshallableReader.apply(RawWire.this);
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean hasNext() {
            return RawWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            throw new UnsupportedOperationException("todo");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws InvalidMarshallableException {
            long length = RawWire.this.bytes.readUnsignedInt();
            if (length == 0xFFFFFFFFL) {
                return null;
            }
            if (length > RawWire.this.bytes.readRemaining()) {
                throw new IllegalStateException("Length was " + length + " greater than remaining " + RawWire.this.bytes.readRemaining());
            }
            if (length >= 0L) {
                long limit = RawWire.this.bytes.readLimit();
                long limit2 = RawWire.this.bytes.readPosition() + length;
                RawWire.this.bytes.readLimit(limit2);
                try {
                    strategy.readUsing(null, object, this, BracketType.MAP);
                }
                finally {
                    RawWire.this.bytes.readLimit(limit);
                    RawWire.this.bytes.readPosition(limit2);
                }
            } else {
                strategy.readUsing(null, object, this, BracketType.MAP);
            }
            return object;
        }

        @Override
        public boolean bool() {
            return RawWire.this.bytes.readBoolean();
        }

        @Override
        public byte int8() {
            return RawWire.this.bytes.readByte();
        }

        @Override
        public short int16() {
            return RawWire.this.bytes.readShort();
        }

        @Override
        public int uint16() {
            return RawWire.this.bytes.readUnsignedShort();
        }

        @Override
        public int int32() {
            return RawWire.this.bytes.readInt();
        }

        @Override
        public long int64() {
            return RawWire.this.bytes.readLong();
        }

        @Override
        public double float64() {
            return RawWire.this.bytes.readDouble();
        }

        @Override
        public float float32() {
            return RawWire.this.bytes.readFloat();
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        @NotNull
        public BracketType getBracketType() {
            throw new IllegalArgumentException("Only scalar or nested types supported");
        }

        @Override
        public Object objectWithInferredType(Object using, SerializationStrategy strategy, Class type) {
            throw new UnsupportedOperationException("Cannot read " + using + " value and " + type + " type for RawWire");
        }
    }

    class RawValueOut
    implements ValueOut {
        RawValueOut() {
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            if (flag == null) {
                RawWire.this.bytes.writeUnsignedByte(187);
            } else {
                RawWire.this.bytes.writeUnsignedByte(flag != false ? 177 : 0);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (RawWire.this.use8bit) {
                RawWire.this.bytes.write8bit(s);
            } else {
                RawWire.this.bytes.writeUtf8(s);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable BytesStore s) {
            if (RawWire.this.use8bit) {
                if (s == null) {
                    RawWire.this.bytes.writeStopBit(-1L);
                } else {
                    long offset = s.readPosition();
                    long readRemaining = Math.min(RawWire.this.bytes.writeRemaining(), s.readLimit() - offset);
                    RawWire.this.bytes.writeStopBit(readRemaining);
                    try {
                        RawWire.this.bytes.write(s, offset, readRemaining);
                    }
                    catch (IllegalArgumentException | BufferUnderflowException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            } else {
                RawWire.this.bytes.writeUtf8((CharSequence)s);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            RawWire.this.bytes.writeByte(i8);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore bytesStore) {
            if (bytesStore == null) {
                this.writeLength(-1L);
            } else {
                this.writeLength(bytesStore.readRemaining());
                RawWire.this.bytes.write(bytesStore);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, @NotNull byte[] bytesArr) {
            this.typePrefix(type);
            return this.bytes(bytesArr);
        }

        @Override
        @NotNull
        public WireOut bytes(String type, @Nullable BytesStore fromBytes) {
            this.typePrefix(type);
            return this.bytes(fromBytes);
        }

        @Override
        @NotNull
        public WireOut rawBytes(byte[] value) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public ValueOut writeLength(long length) {
            RawWire.this.bytes.writeStopBit(length);
            return this;
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull byte[] fromBytes) {
            this.writeLength(fromBytes.length);
            RawWire.this.bytes.write(fromBytes);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            RawWire.this.bytes.writeUnsignedByte(u8);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            RawWire.this.bytes.writeShort(i16);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            RawWire.this.bytes.writeUnsignedShort(u16);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            RawWire.this.bytes.appendUtf8(codepoint);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            RawWire.this.bytes.writeInt(i32);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            RawWire.this.bytes.writeUnsignedInt(u32);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            RawWire.this.bytes.writeLong(i64);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int128forBinding(long i64x0, long i64x1, TwoLongValue longValue) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut int64_0x(long i64) {
            return this.int64(i64);
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            BinaryLongArrayReference.lazyWrite((Bytes)RawWire.this.bytes, (long)capacity);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            long pos = RawWire.this.bytes.writePosition();
            BinaryLongArrayReference.lazyWrite((Bytes)RawWire.this.bytes, (long)capacity);
            ((Byteable)values).bytesStore((BytesStore)RawWire.this.bytes, pos, RawWire.this.bytes.lengthWritten(pos));
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            RawWire.this.bytes.writeFloat(f);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            RawWire.this.bytes.writeDouble(d);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            long t = localTime.toNanoOfDay();
            RawWire.this.bytes.writeLong(t);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            if (RawWire.this.use8bit) {
                RawWire.this.bytes.write8bit(zonedDateTime.toString());
            } else {
                RawWire.this.bytes.writeUtf8(zonedDateTime.toString());
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            RawWire.this.bytes.writeStopBit(localDate.toEpochDay());
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut dateTime(@NotNull LocalDateTime localDateTime) {
            this.date(localDateTime.toLocalDate());
            this.time(localDateTime.toLocalTime());
            return RawWire.this;
        }

        @Override
        @NotNull
        public ValueOut typePrefix(CharSequence typeName) {
            RawWire.this.bytes.writeUtf8(typeName);
            return this;
        }

        @Override
        public ClassLookup classLookup() {
            return RawWire.this.classLookup();
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@Nullable CharSequence type) {
            RawWire.this.bytes.writeUtf8(type);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes<?>> typeTranslator, @Nullable Class type) {
            long position = RawWire.this.bytes.writePosition();
            RawWire.this.bytes.writeSkip(1L);
            typeTranslator.accept(type, RawWire.this.bytes);
            RawWire.this.bytes.writeUnsignedByte(position, (int)Maths.toInt8((long)(RawWire.this.bytes.lengthWritten(position) - 1L)));
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            RawWire.this.bytes.writeLong(uuid.getMostSignificantBits());
            RawWire.this.bytes.writeLong(uuid.getLeastSignificantBits());
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            RawWire.this.bytes.writeInt(value);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            RawWire.this.bytes.writeLong(value);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, @NotNull IntValue intValue) {
            this.int32forBinding(value);
            ((BinaryIntReference)intValue).bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.writePosition() - 4L, 4L);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, @NotNull LongValue longValue) {
            this.int64forBinding(value);
            ((BinaryLongReference)longValue).bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.writePosition() - 8L, 8L);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut boolForBinding(boolean value, @NotNull BooleanValue longValue) {
            this.bool(value);
            ((BinaryLongReference)longValue).bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.writePosition() - 1L, 1L);
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireOut sequence(T t, @NotNull BiConsumer<T, ValueOut> writer) {
            long position = RawWire.this.bytes.writePosition();
            RawWire.this.bytes.writeInt(0);
            writer.accept(t, this);
            RawWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(RawWire.this.bytes.lengthWritten(position) - 4L), (String)"Document length %,d out of 32-bit int range."));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T, K> WireOut sequence(T t, K kls, @NotNull TriConsumer<T, K, ValueOut> writer) throws InvalidMarshallableException {
            long position = RawWire.this.bytes.writePosition();
            RawWire.this.bytes.writeInt(0);
            writer.accept(t, kls, this);
            RawWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(RawWire.this.bytes.lengthWritten(position) - 4L), (String)"Document length %,d out of 32-bit int range."));
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) throws InvalidMarshallableException {
            long position = RawWire.this.bytes.writePosition();
            RawWire.this.bytes.writeInt(0);
            object.writeMarshallable(RawWire.this);
            int length = Maths.toInt32((long)(RawWire.this.bytes.lengthWritten(position) - 4L), (String)"Document length %,d out of 32-bit int range.");
            RawWire.this.bytes.writeOrderedInt(position, length);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull Serializable object) throws InvalidMarshallableException {
            long position = RawWire.this.bytes.writePosition();
            RawWire.this.bytes.writeInt(0);
            this.writeSerializable(object);
            int length = Maths.toInt32((long)(RawWire.this.bytes.lengthWritten(position) - 4L), (String)"Document length %,d out of 32-bit int range.");
            RawWire.this.bytes.writeOrderedInt(position, length);
            return RawWire.this;
        }

        private void writeSerializable(@NotNull Serializable object) throws InvalidMarshallableException {
            try {
                if (object instanceof Externalizable) {
                    ((Externalizable)object).writeExternal(RawWire.this.objectOutput());
                } else {
                    Wires.writeMarshallable(object, RawWire.this);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        @NotNull
        public WireOut map(Map map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut object(@Nullable Object o) {
            RawWire.this.bytes.writeUtf8(o == null ? null : o.toString());
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return RawWire.this;
        }

        @Override
        public void resetState() {
        }
    }
}

