/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderBuilder;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.wire.AbstractGeneratedMethodReader;
import net.openhft.chronicle.wire.GenerateMethodReader;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMethodReader;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaMethodReaderBuilder
implements MethodReaderBuilder {
    public static final String DISABLE_READER_PROXY_CODEGEN = "disableReaderProxyCodegen";
    private static final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private static final Class<?> COMPILE_FAILED = ClassNotFoundException.class;
    private final MarshallableIn in;
    private boolean ignoreDefaults;
    private WireParselet defaultParselet;
    private MethodReaderInterceptorReturns methodReaderInterceptorReturns;
    private WireType wireType;
    private Object[] metaDataHandler = null;
    private ExceptionHandler exceptionHandlerOnUnknownMethod = Jvm.debug();
    private Predicate predicate = x -> true;
    private boolean scanning = false;

    public VanillaMethodReaderBuilder(MarshallableIn in) {
        this.in = in;
    }

    @NotNull
    public static WireParselet createDefaultParselet(ExceptionHandler exceptionHandlerOnUnknownMethod) {
        return (s, v) -> {
            MessageHistory history = MessageHistory.get();
            long sourceIndex = history.lastSourceIndex();
            v.skipValue();
            ExceptionHandler eh = s.length() == 0 ? Jvm.warn() : exceptionHandlerOnUnknownMethod;
            eh.on(VanillaMethodReader.class, VanillaMethodReaderBuilder.errorMsg(s, history, sourceIndex));
        };
    }

    @NotNull
    private static String errorMsg(CharSequence s, MessageHistory history, long sourceIndex) {
        String identifierType = s.length() != 0 && Character.isDigit(s.charAt(0)) ? "@MethodId" : "method-name";
        String msg = "Unknown " + identifierType + "='" + s + "'";
        if (history.lastSourceId() >= 0) {
            msg = msg + " from " + history.lastSourceId() + " at " + Long.toHexString(sourceIndex) + " ~ " + (int)sourceIndex;
        }
        return msg;
    }

    public WireParselet defaultParselet() {
        return this.defaultParselet;
    }

    public MethodReaderBuilder defaultParselet(WireParselet defaultParselet) {
        this.defaultParselet = defaultParselet;
        return this;
    }

    public VanillaMethodReaderBuilder methodReaderInterceptorReturns(MethodReaderInterceptorReturns methodReaderInterceptorReturns) {
        this.methodReaderInterceptorReturns = methodReaderInterceptorReturns;
        return this;
    }

    public MethodReaderBuilder exceptionHandlerOnUnknownMethod(ExceptionHandler exceptionHandler) {
        this.exceptionHandlerOnUnknownMethod = exceptionHandler;
        return this;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public VanillaMethodReaderBuilder wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    public VanillaMethodReaderBuilder scanning(boolean scanning) {
        this.scanning = scanning;
        return this;
    }

    @Nullable
    private MethodReader createGeneratedInstance(Object ... impls) {
        if (this.ignoreDefaults || Jvm.getBoolean((String)DISABLE_READER_PROXY_CODEGEN)) {
            return null;
        }
        GenerateMethodReader generateMethodReader = new GenerateMethodReader(this.wireType, this.methodReaderInterceptorReturns, this.metaDataHandler, impls);
        String fullClassName = generateMethodReader.packageName() + "." + generateMethodReader.generatedClassName();
        try {
            try {
                Class<?> generatedClass = Class.forName(fullClassName);
                return this.instanceForGeneratedClass(generatedClass, impls);
            }
            catch (ClassNotFoundException e) {
                Class clazz = classCache.computeIfAbsent(fullClassName, name -> generateMethodReader.createClass());
                if (clazz != null && clazz != COMPILE_FAILED) {
                    return this.instanceForGeneratedClass(clazz, impls);
                }
            }
        }
        catch (Throwable e) {
            classCache.put(fullClassName, COMPILE_FAILED);
            Jvm.warn().on(this.getClass(), "Failed to compile generated method reader - falling back to proxy method reader. Please report this failure as support for proxy method readers will be dropped in x.25.", e);
        }
        return null;
    }

    @NotNull
    private MethodReader instanceForGeneratedClass(Class<?> generatedClass, Object[] impls) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = generatedClass.getConstructors()[0];
        WireParselet debugLoggingParselet = VanillaMethodReader::logMessage;
        MethodReader reader = (MethodReader)constructor.newInstance(this.in, this.defaultParselet, debugLoggingParselet, this.methodReaderInterceptorReturns, this.metaDataHandler, impls);
        if (reader instanceof AbstractGeneratedMethodReader) {
            AbstractGeneratedMethodReader reader0 = (AbstractGeneratedMethodReader)reader;
            reader0.scanning(this.scanning);
            reader0.predicate(this.predicate);
        }
        return reader;
    }

    public MethodReaderBuilder metaDataHandler(Object ... components) {
        this.metaDataHandler = components;
        return this;
    }

    @NotNull
    public MethodReader build(Object ... impls) {
        MethodReader generatedInstance;
        if (this.defaultParselet == null) {
            this.defaultParselet = VanillaMethodReaderBuilder.createDefaultParselet(this.exceptionHandlerOnUnknownMethod);
        }
        return (generatedInstance = this.createGeneratedInstance(impls)) == null ? new VanillaMethodReader(this.in, this.ignoreDefaults, this.defaultParselet, WireParser.SKIP_READABLE_BYTES, this.methodReaderInterceptorReturns, this.metaDataHandler, this.predicate, impls) : generatedInstance;
    }

    public MethodReaderBuilder predicate(Predicate<?> predicate) {
        this.predicate = predicate;
        return this;
    }
}

