/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;

public class WireTypeConverterInternal {
    private final Wire yamlWire = (Wire)WireType.YAML_ONLY.apply(Bytes.allocateElasticOnHeap());
    private final Wire jsonWire = (Wire)WireType.JSON_ONLY.apply(Bytes.allocateElasticOnHeap());

    public CharSequence jsonToYaml(CharSequence json) {
        this.jsonWire.reset();
        this.jsonWire.bytes().append(json);
        this.jsonWire.copyTo(this.yamlWire);
        return this.yamlWire.bytes();
    }

    public CharSequence yamlToJson(CharSequence yaml) {
        this.yamlWire.reset();
        this.yamlWire.bytes().clear().append(yaml);
        this.jsonWire.bytes().clear();
        this.yamlWire.copyTo(this.jsonWire);
        return this.jsonWire.bytes();
    }

    public void addAlias(Class newClass, String oldTypeName) {
        this.jsonWire.classLookup().addAlias(newClass, oldTypeName);
        this.yamlWire.classLookup().addAlias(newClass, oldTypeName);
    }
}

