/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.VanillaFieldInfo;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.internal.fieldinfo.CharFieldInfo;
import net.openhft.chronicle.wire.internal.fieldinfo.DoubleFieldInfo;
import net.openhft.chronicle.wire.internal.fieldinfo.IntFieldInfo;
import net.openhft.chronicle.wire.internal.fieldinfo.LongFieldInfo;
import net.openhft.chronicle.wire.internal.fieldinfo.ObjectFieldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FieldInfo {
    public static FieldInfo createForField(String name, Class<?> type, BracketType bracketType, @NotNull Field field) {
        if (!type.isPrimitive()) {
            return new ObjectFieldInfo(name, type, bracketType, field);
        }
        if (type == Integer.TYPE) {
            return new IntFieldInfo(name, type, bracketType, field);
        }
        if (type == Double.TYPE) {
            return new DoubleFieldInfo(name, type, bracketType, field);
        }
        if (type == Long.TYPE) {
            return new LongFieldInfo(name, type, bracketType, field);
        }
        if (type == Character.TYPE) {
            return new CharFieldInfo(name, type, bracketType, field);
        }
        return new VanillaFieldInfo(name, type, bracketType, field);
    }

    @NotNull
    public static Wires.FieldInfoPair lookupClass(@NotNull Class<?> aClass) {
        SerializationStrategy ss = (SerializationStrategy)Wires.CLASS_STRATEGY.get(aClass);
        switch (ss.bracketType()) {
            case NONE: 
            case SEQ: {
                return Wires.FieldInfoPair.EMPTY;
            }
            case MAP: {
                break;
            }
            case HISTORY_MESSAGE: {
                throw new AssertionError();
            }
        }
        @NotNull ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        WireMarshaller marshaller = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(aClass);
        for (WireMarshaller.FieldAccess fa : marshaller.fields) {
            String name = fa.field.getName();
            Class<?> type = fa.field.getType();
            SerializationStrategy ss2 = (SerializationStrategy)Wires.CLASS_STRATEGY.get(type);
            BracketType bracketType = ss2.bracketType();
            fields.add(FieldInfo.createForField(name, type, bracketType, fa.field));
        }
        return new Wires.FieldInfoPair(Collections.unmodifiableList(fields), fields.stream().collect(Collectors.toMap(FieldInfo::name, f -> f)));
    }

    public String name();

    public Class<?> type();

    public BracketType bracketType();

    @Nullable
    public Object get(Object var1);

    public long getLong(Object var1);

    public int getInt(Object var1);

    public char getChar(Object var1);

    public double getDouble(Object var1);

    public void set(Object var1, Object var2) throws IllegalArgumentException;

    public void set(Object var1, char var2) throws IllegalArgumentException;

    public void set(Object var1, int var2) throws IllegalArgumentException;

    public void set(Object var1, long var2) throws IllegalArgumentException;

    public void set(Object var1, double var2) throws IllegalArgumentException;

    public Class<?> genericType(int var1);

    default public void copy(Object source, Object destination) {
        this.set(destination, this.get(source));
    }

    public boolean isEqual(Object var1, Object var2);
}

